/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.util.python.pythonexampleclasses;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openjump.util.python.pythonexampleclasses.ConstrainedNClickTool;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyString;

public class DrawCustomTool
extends ConstrainedNClickTool {
    private FeatureDrawingUtil featureDrawingUtil;
    private int minClicks = 1;
    private int fireClicks = 2;
    private Icon icon = null;
    private String toolName = "Custom Tool";
    private String geoType = "Point";
    private FeedbackListener feedbackListener = null;
    private FinalDrawListener finalGeoListener = null;
    private ActivationListener activationListener = null;
    private DeActivationListener deActivationListener = null;

    public DrawCustomTool(FeatureDrawingUtil featureDrawingUtil) {
        this.drawClosed = false;
        this.featureDrawingUtil = featureDrawingUtil;
    }

    public void activate(LayerViewPanel layerViewPanel) {
        super.activate(layerViewPanel);
        if (this.activationListener != null) {
            WorkbenchContext wc = this.getWorkbench().getContext();
            CustomToolEvent toolEvent = new CustomToolEvent(this, null, wc);
            this.activationListener.handleActivation(toolEvent);
        }
    }

    public void deactivate() {
        this.cancelGesture();
        super.deactivate();
        if (this.deActivationListener != null) {
            WorkbenchContext wc = this.getWorkbench().getContext();
            CustomToolEvent toolEvent = new CustomToolEvent(this, null, wc);
            this.deActivationListener.handleDeActivation(toolEvent);
        }
    }

    public void setFireClicks(int fireClicks) {
        this.fireClicks = fireClicks;
    }

    public void setMinClicks(int minClicks) {
        this.minClicks = minClicks;
    }

    public void setMaxClicks(int maxClicks) {
        this.n = maxClicks;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void setToolName(String toolName) {
        this.toolName = toolName;
    }

    public void setGeometryType(String geoType) {
        boolean goodType;
        boolean bl = goodType = geoType.equalsIgnoreCase("POINT") || geoType.equalsIgnoreCase("LINESTRING") || geoType.equalsIgnoreCase("POLYGON");
        if (!goodType) {
            throw new PyException(Py.ValueError, (PyObject)new PyString(geoType + ": invalid geometry type"));
        }
        this.geoType = geoType;
    }

    public void setStrokeWidth(int width) {
        super.setStrokeWidth(width);
    }

    public void setFeedbackListener(FeedbackListener listener) {
        this.feedbackListener = listener;
    }

    public void setFinalGeoListener(FinalDrawListener listener) {
        this.finalGeoListener = listener;
    }

    public void setActivationListener(ActivationListener listener) {
        this.activationListener = listener;
    }

    public void setDeActivationListener(DeActivationListener listener) {
        this.deActivationListener = listener;
    }

    public String getName() {
        return this.toolName;
    }

    public Icon getIcon() {
        if (this.icon == null) {
            return new ImageIcon(this.getClass().getResource("DrawLine.gif"));
        }
        return this.icon;
    }

    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        Geometry geo = this.getFinalGeometry();
        if (geo == null) {
            return;
        }
        this.execute(this.featureDrawingUtil.createAddCommand(geo, this.isRollingBackInvalidEdits(), this.getPanel(), this));
    }

    protected Shape getShape() throws NoninvertibleTransformException {
        List coords = new ArrayList<Coordinate>(this.getCoordinates());
        if (coords.size() >= this.fireClicks) {
            coords.add(this.tentativeCoordinate);
            coords = this.fireFeedbackEvent(coords);
            Point2D firstPoint = this.getPanel().getViewport().toViewPoint((Coordinate)coords.get(0));
            GeneralPath path = new GeneralPath();
            path.moveTo((float)firstPoint.getX(), (float)firstPoint.getY());
            for (int i = 1; i < coords.size(); ++i) {
                Coordinate nextCoordinate = (Coordinate)coords.get(i);
                Point2D nextPoint = this.getPanel().getViewport().toViewPoint(nextCoordinate);
                path.lineTo((int)nextPoint.getX(), (int)nextPoint.getY());
            }
            return path;
        }
        return super.getShape();
    }

    protected Geometry getFinalGeometry() throws NoninvertibleTransformException {
        boolean goodGeo = true;
        MultiPoint geo = null;
        if (this.getCoordinates().size() < this.minClicks) {
            this.getPanel().getContext().warnUser("Must have at least " + this.minClicks + " points");
            return null;
        }
        List coords = this.fireFinalGeoEvent(this.getCoordinates());
        IsValidOp isValidOp = null;
        if (this.geoType.equalsIgnoreCase("POINT")) {
            if (coords.size() == 1) {
                geo = new GeometryFactory().createPoint((Coordinate)coords.get(0));
                isValidOp = new IsValidOp((Geometry)((Point)geo));
            } else {
                geo = new GeometryFactory().createMultiPoint(this.toArray(coords));
                isValidOp = new IsValidOp((Geometry)geo);
            }
        } else if (this.geoType.equalsIgnoreCase("LINESTRING")) {
            geo = new GeometryFactory().createLineString(this.toArray(coords));
            isValidOp = new IsValidOp((Geometry)((LineString)geo));
        } else if (this.geoType.equalsIgnoreCase("POLYGON")) {
            geo = new GeometryFactory().createPolygon(new GeometryFactory().createLinearRing(this.toArray(coords)), null);
            isValidOp = new IsValidOp((Geometry)((Polygon)geo));
        } else {
            this.getPanel().getContext().warnUser(this.geoType + " not a valid type.");
            return null;
        }
        if (!isValidOp.isValid()) {
            this.getPanel().getContext().warnUser(isValidOp.getValidationError().getMessage());
            if (this.getWorkbench().getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false)) {
                return null;
            }
        }
        return geo;
    }

    protected List fireFeedbackEvent(List coordsIn) {
        if (this.feedbackListener == null) {
            return this.fireFinalGeoEvent(coordsIn);
        }
        ArrayList coords = new ArrayList();
        Iterator i = coordsIn.iterator();
        while (i.hasNext()) {
            coords.add(((Coordinate)i.next()).clone());
        }
        WorkbenchContext wc = this.getWorkbench().getContext();
        CustomToolEvent toolEvent = new CustomToolEvent(this, coords, wc);
        this.feedbackListener.feedbackDraw(toolEvent);
        coords = (ArrayList)toolEvent.getCoords();
        return coords;
    }

    protected List fireFinalGeoEvent(List coordsIn) {
        if (this.finalGeoListener == null) {
            return coordsIn;
        }
        ArrayList coords = new ArrayList();
        Iterator i = coordsIn.iterator();
        while (i.hasNext()) {
            coords.add(((Coordinate)i.next()).clone());
        }
        WorkbenchContext wc = this.getWorkbench().getContext();
        CustomToolEvent toolEvent = new CustomToolEvent(this, coords, wc);
        this.finalGeoListener.finalDraw(toolEvent);
        coords = (ArrayList)toolEvent.getCoords();
        return coords;
    }

    public class CustomToolEvent
    extends EventObject {
        private List localCoords;
        private String statusMessage;
        private WorkbenchContext wc;

        CustomToolEvent(Object source, List coords, WorkbenchContext wc) {
            super(source);
            this.statusMessage = "";
            this.localCoords = coords;
            this.wc = wc;
        }

        public WorkbenchContext getWc() {
            return this.wc;
        }

        public List getCoords() {
            return this.localCoords;
        }

        public void setCoords(List coords) {
            this.localCoords = coords;
        }

        public void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }
    }

    public static interface DeActivationListener
    extends EventListener {
        public void handleDeActivation(CustomToolEvent var1);
    }

    public static interface ActivationListener
    extends EventListener {
        public void handleActivation(CustomToolEvent var1);
    }

    public static interface FeedbackListener
    extends EventListener {
        public void feedbackDraw(CustomToolEvent var1);
    }

    public static interface FinalDrawListener
    extends EventListener {
        public void finalDraw(CustomToolEvent var1);
    }
}

