/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeExtension;
import org.apache.batik.bridge.DefaultScriptSecurity;
import org.apache.batik.bridge.ExternalResourceSecurity;
import org.apache.batik.bridge.RelaxedExternalResourceSecurity;
import org.apache.batik.bridge.ScriptSecurity;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAElement;
import org.w3c.dom.svg.SVGDocument;

public class UserAgentAdapter
implements UserAgent {
    protected Set FEATURES = new HashSet();
    protected Set extensions = new HashSet();
    protected BridgeContext ctx;

    public void setBridgeContext(BridgeContext bridgeContext) {
        this.ctx = bridgeContext;
    }

    public void addStdFeatures() {
        this.FEATURES.add("org.w3c.svg");
        this.FEATURES.add("org.w3c.svg.lang");
        this.FEATURES.add("org.w3c.svg.static");
    }

    public Dimension2D getViewportSize() {
        return new Dimension(1, 1);
    }

    public void displayMessage(String string) {
    }

    public void displayError(String string) {
        this.displayMessage(string);
    }

    public void displayError(Exception exception) {
        this.displayError(exception.getMessage());
    }

    public void showAlert(String string) {
    }

    public String showPrompt(String string) {
        return null;
    }

    public String showPrompt(String string, String string2) {
        return null;
    }

    public boolean showConfirm(String string) {
        return false;
    }

    public float getPixelUnitToMillimeter() {
        return 0.26458332f;
    }

    public float getPixelToMM() {
        return this.getPixelUnitToMillimeter();
    }

    public String getDefaultFontFamily() {
        return "Arial, Helvetica, sans-serif";
    }

    public float getMediumFontSize() {
        return 228.59999f / (72.0f * this.getPixelUnitToMillimeter());
    }

    public float getLighterFontWeight(float f) {
        return UserAgentAdapter.getStandardLighterFontWeight(f);
    }

    public float getBolderFontWeight(float f) {
        return UserAgentAdapter.getStandardBolderFontWeight(f);
    }

    public String getLanguages() {
        return "en";
    }

    public String getMedia() {
        return "all";
    }

    public String getAlternateStyleSheet() {
        return null;
    }

    public String getUserStyleSheetURI() {
        return null;
    }

    public String getXMLParserClassName() {
        return XMLResourceDescriptor.getXMLParserClassName();
    }

    public boolean isXMLParserValidating() {
        return false;
    }

    public EventDispatcher getEventDispatcher() {
        return null;
    }

    public void openLink(SVGAElement sVGAElement) {
    }

    public void setSVGCursor(Cursor cursor) {
    }

    public void setTextSelection(Mark mark, Mark mark2) {
    }

    public void deselectAll() {
    }

    public void runThread(Thread thread) {
    }

    public AffineTransform getTransform() {
        return null;
    }

    public void setTransform(AffineTransform affineTransform) {
    }

    public Point getClientAreaLocationOnScreen() {
        return new Point();
    }

    public boolean hasFeature(String string) {
        return this.FEATURES.contains(string);
    }

    public boolean supportExtension(String string) {
        return this.extensions.contains(string);
    }

    public void registerExtension(BridgeExtension bridgeExtension) {
        Iterator iterator = bridgeExtension.getImplementedExtensions();
        while (iterator.hasNext()) {
            this.extensions.add(iterator.next());
        }
    }

    public void handleElement(Element element, Object object) {
    }

    public ScriptSecurity getScriptSecurity(String string, ParsedURL parsedURL, ParsedURL parsedURL2) {
        return new DefaultScriptSecurity(string, parsedURL, parsedURL2);
    }

    public void checkLoadScript(String string, ParsedURL parsedURL, ParsedURL parsedURL2) throws SecurityException {
        ScriptSecurity scriptSecurity = this.getScriptSecurity(string, parsedURL, parsedURL2);
        if (scriptSecurity != null) {
            scriptSecurity.checkLoadScript();
        }
    }

    public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL parsedURL, ParsedURL parsedURL2) {
        return new RelaxedExternalResourceSecurity(parsedURL, parsedURL2);
    }

    public void checkLoadExternalResource(ParsedURL parsedURL, ParsedURL parsedURL2) throws SecurityException {
        ExternalResourceSecurity externalResourceSecurity = this.getExternalResourceSecurity(parsedURL, parsedURL2);
        if (externalResourceSecurity != null) {
            externalResourceSecurity.checkLoadExternalResource();
        }
    }

    public static float getStandardLighterFontWeight(float f) {
        int n = (int)((f + 50.0f) / 100.0f) * 100;
        switch (n) {
            case 100: {
                return 100.0f;
            }
            case 200: {
                return 100.0f;
            }
            case 300: {
                return 200.0f;
            }
            case 400: {
                return 300.0f;
            }
            case 500: {
                return 400.0f;
            }
            case 600: {
                return 400.0f;
            }
            case 700: {
                return 400.0f;
            }
            case 800: {
                return 400.0f;
            }
            case 900: {
                return 400.0f;
            }
        }
        throw new IllegalArgumentException("Bad Font Weight: " + f);
    }

    public static float getStandardBolderFontWeight(float f) {
        int n = (int)((f + 50.0f) / 100.0f) * 100;
        switch (n) {
            case 100: {
                return 600.0f;
            }
            case 200: {
                return 600.0f;
            }
            case 300: {
                return 600.0f;
            }
            case 400: {
                return 600.0f;
            }
            case 500: {
                return 600.0f;
            }
            case 600: {
                return 700.0f;
            }
            case 700: {
                return 800.0f;
            }
            case 800: {
                return 900.0f;
            }
            case 900: {
                return 900.0f;
            }
        }
        throw new IllegalArgumentException("Bad Font Weight: " + f);
    }

    public SVGDocument getBrokenLinkDocument(Element element, String string, String string2) {
        throw new BridgeException(this.ctx, element, "uri.image.broken", new Object[]{string, string2});
    }
}

