/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.anim.values.AnimatableLengthValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;
import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.AbstractSVGAnimatedValue;
import org.apache.batik.dom.svg.AbstractSVGLength;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.apache.batik.dom.svg.SVGOMElement;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGLength;

public abstract class AbstractSVGAnimatedLength
extends AbstractSVGAnimatedValue
implements SVGAnimatedLength,
LiveAttributeValue {
    public static final short HORIZONTAL_LENGTH = 2;
    public static final short VERTICAL_LENGTH = 1;
    public static final short OTHER_LENGTH = 0;
    protected short direction;
    protected BaseSVGLength baseVal;
    protected AnimSVGLength animVal;
    protected boolean changing;
    protected boolean nonNegative;

    public AbstractSVGAnimatedLength(AbstractElement abstractElement, String string, String string2, short s, boolean bl) {
        super(abstractElement, string, string2);
        this.direction = s;
        this.nonNegative = bl;
    }

    protected abstract String getDefaultValue();

    public SVGLength getBaseVal() {
        if (this.baseVal == null) {
            this.baseVal = new BaseSVGLength(this.direction);
        }
        return this.baseVal;
    }

    public SVGLength getAnimVal() {
        if (this.animVal == null) {
            this.animVal = new AnimSVGLength(this.direction);
        }
        return this.animVal;
    }

    protected void updateAnimatedValue(AnimatableValue animatableValue) {
        if (animatableValue == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            AnimatableLengthValue animatableLengthValue = (AnimatableLengthValue)animatableValue;
            if (this.animVal == null) {
                this.animVal = new AnimSVGLength(this.direction);
            }
            this.animVal.setAnimatedValue(animatableLengthValue.getLengthType(), animatableLengthValue.getLengthValue());
        }
        this.fireAnimatedAttributeListeners();
    }

    public AnimatableValue getUnderlyingValue(AnimationTarget animationTarget) {
        SVGLength sVGLength = this.getBaseVal();
        return new AnimatableLengthValue(animationTarget, sVGLength.getUnitType(), sVGLength.getValueInSpecifiedUnits(), animationTarget.getPercentageInterpretation(this.getNamespaceURI(), this.getLocalName(), false));
    }

    public void attrAdded(Attr attr, String string) {
        this.attrChanged();
    }

    public void attrModified(Attr attr, String string, String string2) {
        this.attrChanged();
    }

    public void attrRemoved(Attr attr, String string) {
        this.attrChanged();
    }

    protected void attrChanged() {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    protected class AnimSVGLength
    extends AbstractSVGLength {
        public AnimSVGLength(short s) {
            super(s);
        }

        public short getUnitType() {
            if (AbstractSVGAnimatedLength.this.hasAnimVal) {
                return super.getUnitType();
            }
            return AbstractSVGAnimatedLength.this.getBaseVal().getUnitType();
        }

        public float getValue() {
            if (AbstractSVGAnimatedLength.this.hasAnimVal) {
                return super.getValue();
            }
            return AbstractSVGAnimatedLength.this.getBaseVal().getValue();
        }

        public float getValueInSpecifiedUnits() {
            if (AbstractSVGAnimatedLength.this.hasAnimVal) {
                return super.getValueInSpecifiedUnits();
            }
            return AbstractSVGAnimatedLength.this.getBaseVal().getValueInSpecifiedUnits();
        }

        public String getValueAsString() {
            if (AbstractSVGAnimatedLength.this.hasAnimVal) {
                return super.getValueAsString();
            }
            return AbstractSVGAnimatedLength.this.getBaseVal().getValueAsString();
        }

        public void setValue(float f) throws DOMException {
            throw AbstractSVGAnimatedLength.this.element.createDOMException((short)7, "readonly.length", null);
        }

        public void setValueInSpecifiedUnits(float f) throws DOMException {
            throw AbstractSVGAnimatedLength.this.element.createDOMException((short)7, "readonly.length", null);
        }

        public void setValueAsString(String string) throws DOMException {
            throw AbstractSVGAnimatedLength.this.element.createDOMException((short)7, "readonly.length", null);
        }

        public void newValueSpecifiedUnits(short s, float f) {
            throw AbstractSVGAnimatedLength.this.element.createDOMException((short)7, "readonly.length", null);
        }

        public void convertToSpecifiedUnits(short s) {
            throw AbstractSVGAnimatedLength.this.element.createDOMException((short)7, "readonly.length", null);
        }

        protected SVGOMElement getAssociatedElement() {
            return (SVGOMElement)AbstractSVGAnimatedLength.this.element;
        }

        protected void setAnimatedValue(int n, float f) {
            super.newValueSpecifiedUnits((short)n, f);
        }
    }

    protected class BaseSVGLength
    extends AbstractSVGLength {
        protected boolean valid;

        public BaseSVGLength(short s) {
            super(s);
        }

        public void invalidate() {
            this.valid = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reset() {
            try {
                AbstractSVGAnimatedLength.this.changing = true;
                String string = this.getValueAsString();
                AbstractSVGAnimatedLength.this.element.setAttributeNS(AbstractSVGAnimatedLength.this.namespaceURI, AbstractSVGAnimatedLength.this.localName, string);
            }
            finally {
                AbstractSVGAnimatedLength.this.changing = false;
            }
        }

        protected void revalidate() {
            String string;
            if (this.valid) {
                return;
            }
            this.unitType = 0;
            this.value = 0.0f;
            Attr attr = AbstractSVGAnimatedLength.this.element.getAttributeNodeNS(AbstractSVGAnimatedLength.this.namespaceURI, AbstractSVGAnimatedLength.this.localName);
            if (attr == null) {
                string = AbstractSVGAnimatedLength.this.getDefaultValue();
                if (string == null) {
                    throw new LiveAttributeException(AbstractSVGAnimatedLength.this.element, AbstractSVGAnimatedLength.this.localName, 0, null);
                }
            } else {
                string = attr.getValue();
            }
            this.parse(string);
            if (AbstractSVGAnimatedLength.this.nonNegative && this.value < 0.0f) {
                throw new LiveAttributeException(AbstractSVGAnimatedLength.this.element, AbstractSVGAnimatedLength.this.localName, 2, string);
            }
            this.valid = true;
        }

        protected SVGOMElement getAssociatedElement() {
            return (SVGOMElement)AbstractSVGAnimatedLength.this.element;
        }
    }
}

