/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.anim.values.AnimatableRectValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;
import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.AbstractSVGAnimatedValue;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.dom.svg.SVGOMRect;
import org.apache.batik.parser.DefaultNumberListHandler;
import org.apache.batik.parser.NumberListParser;
import org.apache.batik.parser.ParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAnimatedRect;
import org.w3c.dom.svg.SVGRect;

public class SVGOMAnimatedRect
extends AbstractSVGAnimatedValue
implements SVGAnimatedRect {
    protected BaseSVGRect baseVal;
    protected AnimSVGRect animVal;
    protected boolean changing;

    public SVGOMAnimatedRect(AbstractElement abstractElement, String string, String string2) {
        super(abstractElement, string, string2);
    }

    public SVGRect getBaseVal() {
        if (this.baseVal == null) {
            this.baseVal = new BaseSVGRect();
        }
        return this.baseVal;
    }

    public SVGRect getAnimVal() {
        if (this.animVal == null) {
            this.animVal = new AnimSVGRect();
        }
        return this.animVal;
    }

    protected void updateAnimatedValue(AnimatableValue animatableValue) {
        if (animatableValue == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            AnimatableRectValue animatableRectValue = (AnimatableRectValue)animatableValue;
            if (this.animVal == null) {
                this.animVal = new AnimSVGRect();
            }
            this.animVal.setAnimatedValue(animatableRectValue.getX(), animatableRectValue.getY(), animatableRectValue.getWidth(), animatableRectValue.getHeight());
        }
        this.fireAnimatedAttributeListeners();
    }

    public AnimatableValue getUnderlyingValue(AnimationTarget animationTarget) {
        SVGRect sVGRect = this.getBaseVal();
        return new AnimatableRectValue(animationTarget, sVGRect.getX(), sVGRect.getY(), sVGRect.getWidth(), sVGRect.getHeight());
    }

    public void attrAdded(Attr attr, String string) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrModified(Attr attr, String string, String string2) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrRemoved(Attr attr, String string) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    protected class AnimSVGRect
    extends SVGOMRect {
        protected AnimSVGRect() {
        }

        public float getX() {
            if (SVGOMAnimatedRect.this.hasAnimVal) {
                return super.getX();
            }
            return SVGOMAnimatedRect.this.getBaseVal().getX();
        }

        public float getY() {
            if (SVGOMAnimatedRect.this.hasAnimVal) {
                return super.getY();
            }
            return SVGOMAnimatedRect.this.getBaseVal().getY();
        }

        public float getWidth() {
            if (SVGOMAnimatedRect.this.hasAnimVal) {
                return super.getWidth();
            }
            return SVGOMAnimatedRect.this.getBaseVal().getWidth();
        }

        public float getHeight() {
            if (SVGOMAnimatedRect.this.hasAnimVal) {
                return super.getHeight();
            }
            return SVGOMAnimatedRect.this.getBaseVal().getHeight();
        }

        public void setX(float f) throws DOMException {
            throw SVGOMAnimatedRect.this.element.createDOMException((short)7, "readonly.length", null);
        }

        public void setY(float f) throws DOMException {
            throw SVGOMAnimatedRect.this.element.createDOMException((short)7, "readonly.length", null);
        }

        public void setWidth(float f) throws DOMException {
            throw SVGOMAnimatedRect.this.element.createDOMException((short)7, "readonly.length", null);
        }

        public void setHeight(float f) throws DOMException {
            throw SVGOMAnimatedRect.this.element.createDOMException((short)7, "readonly.length", null);
        }

        protected void setAnimatedValue(float f, float f2, float f3, float f4) {
            this.x = f;
            this.y = f2;
            this.w = f3;
            this.h = f4;
        }
    }

    protected class BaseSVGRect
    extends SVGOMRect {
        protected boolean valid;

        protected BaseSVGRect() {
        }

        public void invalidate() {
            this.valid = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reset() {
            try {
                SVGOMAnimatedRect.this.changing = true;
                SVGOMAnimatedRect.this.element.setAttributeNS(SVGOMAnimatedRect.this.namespaceURI, SVGOMAnimatedRect.this.localName, Float.toString(this.x) + ' ' + this.y + ' ' + this.w + ' ' + this.h);
            }
            finally {
                SVGOMAnimatedRect.this.changing = false;
            }
        }

        protected void revalidate() {
            if (this.valid) {
                return;
            }
            Attr attr = SVGOMAnimatedRect.this.element.getAttributeNodeNS(SVGOMAnimatedRect.this.namespaceURI, SVGOMAnimatedRect.this.localName);
            if (attr == null) {
                this.x = 0.0f;
                this.y = 0.0f;
                this.w = 100.0f;
                this.h = 100.0f;
            } else {
                final String string = attr.getValue();
                final float[] fArray = new float[4];
                NumberListParser numberListParser = new NumberListParser();
                numberListParser.setNumberListHandler(new DefaultNumberListHandler(){
                    protected int count;

                    public void endNumberList() {
                        if (this.count != 4) {
                            throw new LiveAttributeException(SVGOMAnimatedRect.this.element, SVGOMAnimatedRect.this.localName, 1, string);
                        }
                    }

                    public void numberValue(float f) throws ParseException {
                        if (this.count < 4) {
                            fArray[this.count] = f;
                        }
                        if (f < 0.0f && (this.count == 2 || this.count == 3)) {
                            throw new LiveAttributeException(SVGOMAnimatedRect.this.element, SVGOMAnimatedRect.this.localName, 1, string);
                        }
                        ++this.count;
                    }
                });
                numberListParser.parse(string);
                this.x = fArray[0];
                this.y = fArray[1];
                this.w = fArray[2];
                this.h = fArray[3];
            }
            this.valid = true;
        }
    }
}

