package com.sun.messaging.jmq.jmsclient.runtime;

import java.util.Properties;

import com.sun.messaging.jmq.jmsservice.BrokerEventListener;
import com.sun.messaging.jmq.jmsservice.JMSService;

public interface BrokerInstance {
	
	/**
     *  Parse broker command line and convert the args into a hashtable format.<p>
     *
     *  Additional arguments are:
     *  <UL>
     *      <LI> -varhome: The location of the VAR directory to use</LI>
     *      <LI> -imqhome: The location of the base IMQ directory</LI>
     *  </UL>
     *
     *  @param args The broker arguments in broker command line format.
     *
     *  @return The resulting Properties that represent the command line
     *          parameters passed in.
     *
     *  @throws IllegalArguementException   If args contain any invalid option.
     */
    public Properties parseArgs(String[] args) throws IllegalArgumentException;

	
	/**
	 * Initialize broker with properties specified in the properties.
	 * 
	 * The props parameter is usually obtained from parseArgs() method.
	 * 
	 * This must be called before start/stop/shutdown
	 * 
	 * @param props  the properties required to init broker.  Obtain required info from broker/Linda.
	 * 
	 * @param evlistener used to listen to broker life cycle events.
	 */
	public void init (Properties props, BrokerEventListener evlistener);
	
	/**
	 * start the broker instance.  
	 */
	public void start();
	
	/**
	 * stop the broker instance
	 */
	public void stop();
	
	/**
	 * shutdown the broker instance.
	 */
	public void shutdown();
	
	/**
	 * Get broker init properties
	 * 
	 * @return
	 */
	public Properties getProperties();
	
	/**
	 * Get the broker event listener.
	 * @return
	 */
	public BrokerEventListener getBrokerEventListener();
	
	/**
	 * check if broker is running
	 * @return
	 */
	public boolean isBrokerRunning();
	
	/**
	 * check if broker instance implements direct mode connection.
	 * 
	 * @return
	 */
	public boolean isDirectMode();

	/**
	 * Return a JMSService that can be used to create legacy RADirect
	 * connections to this broker
	 * 
	 * @return
	 */
	public JMSService getJMSService();
}