/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2009 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)DurableInfo.java	1.6 06/29/07
 */ 

package com.sun.messaging.jmq.util.admin;

/**
 * DurableInfo encapsulates information about a JMQ Durable subscription.
 * It is used to pass this information between the Broker and an
 * administration client.
 *
 * This class has no updateable fields. The admin client should consider
 * it "read-only"
 */
public class DurableInfo implements java.io.Serializable {

    public String	name;
    public String	clientID;
    public int		nMessages;
    public boolean      isActive;

    public ConsumerInfo consumer;

    /**
     * Constructor for Durable.
     *
     */
    public DurableInfo() {
	reset();
    }

    public void reset() {
	name = null;
	clientID = null;
	nMessages = 0;
        isActive = false;
	consumer = null;
    }

    /**
     * Return a string representation of the durable subscription. 
     *
     * @return String representation of durable subscription.
     */
    public String toString() {
	return clientID + "/" + name + ": " + consumer;
    }
}
