<?php

/*
+---------------------------------------------------------------------------+
| OpenX v2.4                                                                |
| ==========                                                                |
|                                                                           |
| Copyright (c) 2003-2008 OpenX Limited                                     |
| For contact details, see: http://www.openx.org/                           |
|                                                                           |
| This program is free software; you can redistribute it and/or modify      |
| it under the terms of the GNU General Public License as published by      |
| the Free Software Foundation; either version 2 of the License, or         |
| (at your option) any later version.                                       |
|                                                                           |
| This program is distributed in the hope that it will be useful,           |
| but WITHOUT ANY WARRANTY; without even the implied warranty of            |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
| GNU General Public License for more details.                              |
|                                                                           |
| You should have received a copy of the GNU General Public License         |
| along with this program; if not, write to the Free Software               |
| Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA |
+---------------------------------------------------------------------------+
$Id: Auto.php 20123 2008-05-12 10:04:45Z david.keen@openx.org $
*/

setupIncludePath();

require_once MAX_PATH . '/lib/Max.php';
require_once MAX_PATH . '/lib/max/Admin/Preferences.php';

require_once MAX_PATH . '/lib/OA/DB/AdvisoryLock.php';

/**
 * A library class for providing automatic maintenance process methods.
 *
 * @static
 * @package    OpenX
 * @subpackage Maintenance
 * @author     Matteo Beccati <matteo.beccati@openx.org>
 */
class OA_Maintenance_Auto
{
    function run()
    {
    	// Make sure that the output is sent to the browser before
    	// loading libraries and connecting to the db
    	flush();

    	MAX_Admin_Preferences::loadPrefs(0);

        $aConf = $GLOBALS['_MAX']['CONF'];

        // Set longer time out, and ignore user abort
        if (!ini_get('safe_mode')) {
            @set_time_limit($aConf['maintenance']['timeLimitScripts']);
            @ignore_user_abort(true);
        }

	    if (!defined('OA_VERSION')) {
	        // If the code is executed inside delivery, the constants
	        // need to be initialized
    	    require_once MAX_PATH . '/constants.php';
    	    setupConstants();
	    }

	    $oLock =& OA_DB_AdvisoryLock::factory();

		if ($oLock->get(OA_DB_ADVISORYLOCK_MAINTENANCE))
		{
            OA::debug('Running automatic maintenance tasks', PEAR_LOG_INFO);

		    require_once MAX_PATH . '/lib/OA/Maintenance.php';
			$oMaint = new OA_Maintenance();
			$oMaint->run();
			$oLock->release();

			OA::debug('Automatic maintenance tasks completed', PEAR_LOG_INFO);
		} else {
			OA::debug('Automatic maintenance tasks not run: could not acquire lock', PEAR_LOG_INFO);
		}
    }
}

?>