#!/usr/bin/perl -w

# use diagnostics;
# use strict;

use File::Spec::Functions;
use Data::Dumper;
use optitools;

#####
#
# Optimax - Source generator and benchmarker
#
#####
#
# Version	:	0.63
# Author	:	Sascha Zapf
# 				Christian Schmidt
# Date		:	27.06.2004
#
#####
#
# Command : optimax.pl -[t|s] warrior|file
#
#####
#
# Versionhistory:
#
# 0.1	First version - ready to test. Implementation of the !(), !<>, !{} and ![] - operator.
#		4 phases modell with html-reporting of topscores and singlescoreoverwiew of the top-
#		scoring Randry's. ( 29.10.2003 )
#
# 0.2	( 01.11.2003 )
#		Addings:
#		Randomnumber-generator can now be initialized from the ;optimax random n command.
#
#		If a Randry in the phase 3 or phase 4 topscore is in the other's topscore too, an link
#		to the singleresult's of the other phase will appear behind the score.
#
#		Changings:
#		If one Randry reached a phase 3 topscore, then the dynamic and static thresholds are
#		ignored and the Randry can absolve phase 4
#
#		The phase highscore, used by the dynamic threshold will now calculated by
#		newhighscore = (oldhighscore+newhiscore)/2
#		exmars -F values in phases 2,3 and 4 are now different ( 2000, 4000 and 1000 ) to avoid
#		magical abuse by one of the Randries.
#
# 0.3	( 07.11.2003 )
#		Addings:
#		Targetvalues for phase 2 and phase 3 can be modified while optimax is running.
#
#		In each singlescoretable the original-warrior is linked.
#
#		F-value are now calculated by the suiteconfig, so phase2 use -F CORESIZE*0.25, phase 3 uses
#		CORESIZE*0.5 and phase 4 uses CORESIZE*0.75
#
#		Statistics are now print to file workdir/index.html
#
#		The DNS of each Randry in the topscores is dump in the file phase3/phase4 dnsdump.
#
#		Bugfixings:
#		Greedy operators are removed from operatormatching. So two operators in one Sourceline
#		are problem no more.
#
# 0.4	( 15.11.2003 )
#
#		Colors and Short descriptions of the warriorclasses are now taken from the "classes"-file
#		in the suitedirectory.
#
#		Basehighscore for the dynamic target is now the average score of the 5 first topscores.
#
#		Topscoreoverride removed.
#
# 0.5	( 25.11.2003 )
#
#		in/out-relations korrected.
#
#		Possible "division by zero" if to many Randry failing in one Phase removed.
#
#		Class "ano" for not specified Hillentry's added.
#
#		Randrytemplate's name is setted to 'anonymous' if no ;name-line is given.
#
# 0.5.1 ( 26.11.2003 )
#
#		Negative-score behavior fixed.
#
# 0.6   ( 01.05.2004 )
#
#		Added some statistics at tospscore and main-site. Reworked some sub's
#
# 0.6.1 ( 11.05.2004 )
#
#		Added operator-commenting with !(from-to"comment") for all operator's
#
#		Fixed curious timestamp-behaviour.
#
#		Topscore DNA now as dump and pretty-HTML-file
#
# 0.6.2 (10.06.2004)
#
#       Major-changes for portability, tested on linux, winXP and winME.
#
#		Bundled all system-call's in core_fight, for easy maintenance.
#
#		Factor out optimax code into optitools.pm, so fsh.pl can use it too.
#
# 0.6.3 (27.06.2004)
#
#		First published beta. 
#
#		Working on portability. Serious probs with Windows ME and XP.
#
#		Starting global hashes for stats, data and settings
#
#		Redesigned commandline-parser
#
#####

# Sub's

sub expanded;
sub benchmark;
sub fight;
sub timer;
sub parser;
sub wilkies;
sub collectdetails;
sub writesettings;
sub reinitsettings;
sub writestats;
sub templatewarrior;
sub stripwarrior;
sub randomizer;
sub get_randomly_from_table;
sub createphase3htmldna();
sub createphase4htmldna();
sub import_suite_config;

# Sub's only for factor out the HTML-Source templates

sub topscore3pre;
sub topscore4pre;
sub topscorepost;

sub singlescorepre;
sub singlescorefirstmiddle;
sub singlescoresecondmiddle;
sub singlescorepost;

# New global config and stat hashes

our %config = ();
our %stats = ();

# Predefined config.

$config{debugmode} = 'off';
$config{verbosemode} = 'off';

$config{points}{win} = 3;
$config{points}{loss} = 0;
$config{points}{tie} = 1;

# Statistics

my $warriorscreated = 0;
my $warriorsnio     = 0;

my $phase1cyclemin = 100;

my %phase2highscore = ( winsp => 0,
						lossp => 0,
						tiesp => 0,
						score => 0, );

my $phase2actualinoutrelation;
my @phase2actualinout = ();
my $phase2statscounter = 0;
my $phase2failed = 0;
my $phase2dynhighscore = 0;
my @phase2hshistory = (0,0,0,0,0);
my $phase2targetstatic = 0;
my $phase2targetdynamic = 0;
my $phase2reached = 0;
my %phase3highscore = ( winsp => 0,
						lossp => 0,
						tiesp => 0,
						score => 0, );

my $phase3actualinoutrelation;
my @phase3actualinout = ();
my $phase3dynhighscore = 0;
my $phase3scoresum = 0;
my $phase3averagescore = 0;
my @phase3actualscores = ();
my $phase3actualaveragescore = 0;
my @phase3hshistory = (0,0,0,0,0);
my @phase3hill = ();
my $phase3targetstatic = 0;
my $phase3targetdynamic = 0;
my $phase3failed = 0;
my $phase3reached = 0;
my $phase3top	= 10;
my $phase3topscoretime = '--:--:--';
my $phase3score;

my %phase4highscore = ( winsp => 0,
						lossp => 0,
						tiesp => 0,
						score => 0, );
my $phase4scoresum = 0;
my $phase4averagescore = 0;
my @phase4actualscores = ();
my $phase4actualaveragescore = 0;
my @phase4hill = ();
my $phase4failed = 0;
my $phase4reached = 0;
my $phase4top = 10;
my $phase4topscoretime = '--:--:--';
my $phase4score;
my %classhighscore =(	cds => [ 0,0,0,0 ],
						clr => [ 0,0,0,0 ],
						pap => [ 0,0,0,0 ],
						pwi => [ 0,0,0,0 ],
						pws => [ 0,0,0,0 ],
						sai => [ 0,0,0,0 ],
						sbi => [ 0,0,0,0 ],
						scn => [ 0,0,0,0 ],
						stn => [ 0,0,0,0 ],
					);

# Options

my @phaseenabled = ( 0,0,0,0 );			# All phases are disabled
my @rounds = ( 1,100,200,200 );			# How much rounds in the phases


# Data

my $alarm = 'no';
my $workdir;
my $temprandry;
my $workrandry;
my $suitedir;
my $resetname;
my $stopname;
my $skipname;

my $clientname = 'anonymous';
my $clientfile;

my $suiteconfig;

my $phase2opponent;
my $phase2fvalue;

my $phase3dir;
my @phase3opponents;			# Filenames
my @phase3opponentsdetailed;	# All datas about the Warriors
my $phase3fvalue;

my $phase4dir;
my @phase4opponents;			# Filenames
my @phase4opponentsdetailed;	# All datas about the Warriors
my $phase4fvalue;

my @dna = ();				# What have the Operators done in this Randry.

my @diff34;
my $diff34overall;
my $diff34overalsd;
# Classes

my %classes = ();

# Main

if (@ARGV < 1)
{
	print "Usage : optimax.pl [-tsdv] warrior|file\n";
	exit;
}

printf ("optimax v0.63 - The ultimate optimizer by Sascha Zapf and Christian Schmidt.\n");
printf ("Betaversion from 11.07.2004\n\n");

# Parsing commandline-args

my $command = shift;

stripwarrior( shift ) if ( $command eq '-s' );
templatewarrior( shift, shift ) if ( $command eq '-t' );
$config{verbosemode} = 'on' if ( $command eq '-v');
$config{debugmode} = 'on' if ( $command eq '-d');

$clientfile = shift;

check_optimars();

# Read the original warrior into memory.

open(WARRIOR, "$clientfile") or die "Couldn't find Warrior $clientfile: $!";
my @wlines = <WARRIOR>;
close(WARRIOR);

# Check if !() are used, if not, argv[2] is needless and should be 1

my $howmuch = 0;

my @matchingrandom = grep { /!\(\d+-\d+(?:"[^"]*")?\)/ } @wlines;
my @matchingrantable = grep { /!\(\w+\.\w+(?:"[^"]*")?\)/ } @wlines;

 if (( $#matchingrandom == -1 ) && ( $#matchingrantable == -1 )) { $howmuch = 1; }


# Creators loop

parser( @wlines );

while ( 1 )
{
	# !() - loop
	my @temp = @wlines;
	@dna = ();

	# Fla-operatoren arbeiten. Spter in eigene Sub legen.

	foreach (@temp) { $_ =~ s/!\(\d+-\d+(?:"[^"]*")?\)/randomizer("$&")/eg }
	foreach (@temp) { $_ =~ s/!\(\w+\.\w+(?:"[^"]*")?\)/get_randomly_from_table("$&")/eg }
    if ( expanded( @temp) ) { benchmark ( @temp ) }
	exit if ( $howmuch == 1 )
} # Creators loop

# Sub's Code

sub parser
{
	my @lines = @_;

	foreach my $line ( @lines )
	{
		if (( my $name = $line ) =~ s/;name //i )
		{
			chomp $name;
			$clientname = $name;
		}

		if ( $line =~ m/;optimax/ )
		{
			my @options = split(/ /, $line);

			if ( $options[1] =~ m/suite/ )
			{
				chomp $options[2];
				$suitedir = $options[2];
                import_suite_config( $suitedir );
                next;
			}
			if ( $options[1] =~ m/rounds/ )
			{
				for(my $pi=0,my $oi=2;$pi<=3;$pi++)
				{
					if ( $phaseenabled[$pi] == 1 )
					{
						$rounds[$pi]=$options[$oi++];
					}
				}
				chomp @rounds;
                next;
			}

            if ( $options[1] =~ m/wlt/ )
            {
            	chomp $options[2];

                my $p = $config{points};

                ( $p->{win}, $p->{loss}, $p->{tie} ) = split(/\|/, $options[2] );

				next;

            }

			if ( $options[1] =~ m/work/ )
			{
				chomp $options[2];
				$workdir = catfile('work', $options[2]);
				mkdir( 'work' );
                register_run( $workdir );
                $phase3dir = catfile($workdir,"phase3");
				$phase4dir = catfile($workdir,"phase4");
				$temprandry = catfile($workdir,"temp.red");
				$workrandry = catfile($workdir,$clientfile);
                $resetname = catfile($workdir,"reset.txt");
                $stopname = catfile($workdir,"stop");
				$skipname = catfile($workdir,"skip");
                mkdir ( $workdir   );
				mkdir ( $phase3dir );
				mkdir ( $phase4dir );

                open(RANDRY, ">$workrandry");
				print RANDRY @lines;
                close(RANDRY);
                next;
			}

			if ( $options[1] =~ m/random/ )
			{
				chomp $options[2];
				srand $options[2];
                next;
			}

			if ( $options[1] =~m/alarm/ )
			{
				chomp $options[2];
				$alarm = $options[2];
                next;
			}

			if ( $options[1] =~m/cycle_override/ )
			{
            	chomp $options[2];
				$config{fsh}{cycles} = $options[2];
                next;
			}


            if ( $options[1] =~m/cycle_groups/ )
			{
            	chomp $options[2];
				if ( $options[2] =~ /^\d+$/ )
                {
                	create_cycle_groups_by_step( $options[2] );
                }
                if ( $options[2] =~ /^.+\..+$/ )
                {
                	create_cycle_groups_by_table( $options[2] );
                }
				warn "Illegal config for cyclelogging\n";
                next;
            }



            if ( $options[1] =~ m/phase1/ )
            {
				chomp $options[2];
				if ( $options[2] =~ m/cyclemin/ )
                {
                	chomp $options[3];
                    $options[3] =~ s/%//;
                    $phase1cyclemin = $options[3];
                }
                next;
			}


            if ( $options[1] =~ m/phase2/ )
			{
				chomp $options[2];
				if ( $options[2] =~ m/.+\.[rR][eE][dD]/ )
				{
					$phase2opponent = $options[2];
					next;
				}
				if ( $options[2] =~ m/\d+/ )
				{
					if ( $options[2] =~ s/%// )
					{
						$phase2targetdynamic = $options[2];
					}
					else
					{
						$phase2targetstatic = $options[2];
					}
					next;
                }

				if ( $options[2] =~ m/fvalue/ )
                {
                	chomp $options[3];
                    $config{phase2}{fvalue} = $options[3];
                }

                next;
			}

			if ( $options[1] =~ m/phase3/ )
			{
				chomp $options[2];

				# Match if warrior.lst
				if ( $options[2] =~ m/.+\.[lL][sS][tT]/ )
				{
					open(LST, "$options[2]") or die "Can't open listfile: $!\n";
					while(<LST>)
					{
						chomp;
						push @phase3opponents, $_;
					}
					close(LST);
					# Delete multiple entry's
					my %seen = ();
					@phase3opponents = grep { ! $seen{$_} ++ } @phase3opponents;

					next;
				}

				# Match if top
				if ( $options[2] =~ s/top// )
				{
					$phase3top = $options[2];
					next;
				}

				# Match if target
				if ( $options[2] =~ m/\d+/ )
				{
					if ( $options[2] =~ s/%// )
					{
						$phase3targetdynamic = $options[2];
					}
					else
					{
						$phase3targetstatic = $options[2];
					}
					next;
				}

				# Match if classes
				my @tempclasses = $options[2] =~ m/[^\:]+/g ;

				foreach my $class ( @tempclasses )
				{
					my $path = catfile($suitedir,$class );
					@phase3opponents = (@phase3opponents, glob(catfile($path,'*.[rR][eE][dD]')));
				}

				# Delete multiple entry's
				my %seen = ();
				@phase3opponents = grep { ! $seen{$_} ++ } @phase3opponents;

                if ( $options[2] =~ m/fvalue/ )
                {
                	chomp $options[3];
                    $config{phase3}{fvalue} = $options[3];
                }

				next;
			}

			if ( $options[1] =~ m/phase4/ )
			{
				if ( $options[2] =~ s/top// )
				{
					$phase4top = $options[2];
					next;
				}
				if ( $options[2] =~ s/%// )
                                {
					my $indexfilename = catfile($suitedir,"index");
					open(WLIST, "$indexfilename") or die "Can't find index file : $!\n";
					while (<WLIST>)
					{
						chomp;
						push @phase4opponents, catfile($suitedir,$_);
					}
					close(WLIST);
					$#phase4opponents = (int((($#phase4opponents+1)/100)*$options[2]))-1;
                    next;
				}

				if ( $options[2] =~ m/fvalue/ )
                {
                	chomp $options[3];
                    $config{phase4}{fvalue} = $options[3];
                    next;
                }

                next;
			}

			# Phases line - ;optimax 1234

			$phaseenabled[0] = 1 if $options[1] =~ m/1/;
			$phaseenabled[1] = 1 if $options[1] =~ m/2/;
			$phaseenabled[2] = 1 if $options[1] =~ m/3/;
			$phaseenabled[3] = 1 if $options[1] =~ m/4/;
        }
	}
	@phase3opponentsdetailed = collectdetails( @phase3opponents );
	@phase4opponentsdetailed = collectdetails( @phase4opponents );

    # Create switches-string for optimars.

	$config{fsh}{optimars_str} = sprintf("-c %d -s %d -p %d -l %d -d %d ",$config{fsh}{cycles}
																					,$config{fsh}{coresize}
                                                                                    ,$config{fsh}{processes}
                                                                                    ,$config{fsh}{length}
			                                                                       ,$config{fsh}{distance} );

    writesettings();

    print Dumper(\%config) if ( $config{debugmode} eq 'on' );

}

sub benchmark
{
	# Create temporary warriorfile for optimars.
	my @temp = @_;
	open(TEMP, ">$temprandry") or die "Can't create temporary warriorfile: $!\n";
	print TEMP @temp;
	close(TEMP);

	$warriorscreated++;

	reinitsettings() if ( -s $resetname ); # Reset settings if file 'reset' is available.

    if ( -e $stopname )
    {
    	unlink $stopname;
        die "optimax - run was terminated\n"
	}
	my $dnastring = join(" | ", @dna);

	##################################################################################
	#
	# Phase 1 - EOC-Test ( end of cycles ) 	Let optimars do one round with the given
	#           Warrior and see if it's came to the end. Optional a given percentage
    #           of the max. cycles must be reached.
	#
	##################################################################################

    # Phase 1 code reworked for -1 exmars at 06-14-04

    if ( $phaseenabled[0] )
    {
		print ( "Processing Phase 1 ...                                                  \r");
		my @mars_spec = ('-1', $suiteconfig, $temprandry );

		my @result = core_fight( @mars_spec );

    	@result = split(/:/, $result[0]);
        chomp @result;

		if ( (($result[0]-$result[1])/ $result[0] ) * 100 < $phase1cyclemin )
        {
        	# Without cyclewin : This Randry kills itself without an enemy.
            # With cyclemin : This Randry kills itself earlier than it is allowed.

            $warriorsnio++;
            return 0;
        }

    }

	########################################################################################
	#
	# Phase 2 - Non-starter Test. Let optimars challenger the generated one against
	#	    some not-so-good warrior, to see if they are
	#	    worth to go on.
	#
	########################################################################################

	if ( $phaseenabled[1] )
	{
		if ( $#phase2actualinout == 24 )
		{
			$phase2actualinoutrelation-=shift @phase2actualinout;
		}
		push @phase2actualinout, 0;

		$phase2reached++;

		chomp $phase2highscore{score};
		#printf ( "Processing Phase 2 ... actual Phase 2 Highscore is %6.2f                                                   \r",$phase2highscore{score});
		print ( "Processing Phase 2 ...                                                    \r");

		my %result = fight( $temprandry,$phase2opponent,$rounds[1],$config{phase2}{fvalue} );
		my %score = wilkies($result{wins},$result{ties},$rounds[1]);

		push @phase2hshistory, $score{score};
		@phase2hshistory = sort { $b <=> $a } @phase2hshistory;
		$#phase2hshistory = 4 if ( $#phase2hshistory > 4 );
		$phase2dynhighscore = ($phase2hshistory[0] + $phase2hshistory[-1])/2;
		$phase2statscounter++;
		if ( $phase2statscounter == 20 )
		{
			writestats() if ( @phase3hill && @phase4hill );
			$phase2statscounter=0;
		}
		if ( $score{score} > $phase2highscore{score} )
		{
			%phase2highscore = %score;
		}
		if ( $score{score} <= $phase2targetstatic )
		{
			$phase2failed++;
			return 0;
		}
		if ($score{score} <= ( $phase2highscore{score}/100)*$phase2targetdynamic )
		{
			$phase2failed++;
			return 0;
		}
	}

	$phase2actualinout[$#phase2actualinout] = 1;
	$phase2actualinoutrelation++;
	$phase2statscounter = 0; # Reset, only after 20 Phase 2 without Phase 3

	##################################################################################
	#
	# Phase 3 and 4 are collecting score, so now the warrior must be saved to his own
	# file that he can remembered.
	#
	##################################################################################

	$phase3reached++;

	#my $ownfilename = sprintf( "$workdir%0.8u.red",$phase3reached );

	my $ownfilename = catfile( $workdir, sprintf("%0.8u.red",$phase3reached));
	open(TEMP, ">$ownfilename") or die "Can't create warriorfile: $!\n";
	print TEMP @temp;
	close(TEMP);

	##########################################################################################
	#
	# Phase 3 - Selection challenge			Let optimars challenger against a selection of
	#										a handful of warrior.
	#
	###########################################################################################

	if ( $phaseenabled[2] )
	{
		if ( $#phase3actualinout == 24 )
		{
			$phase3actualinoutrelation-=shift @phase3actualinout;
		}
		push @phase3actualinout, 0;

		my	( $wins,$loss,$ties,$rounds )= 0;
		my	@opponents = @phase3opponentsdetailed;

		my $oppcount = 1;
		my $oppmax = $#opponents+1;
		my $progress = ' ';

		foreach my $opponent ( @opponents )
		{
			$progress = sprintf("=" x (($oppcount++/$oppmax)*50) );
			printf("%4d/%4d in Phase 3 |%-50s|\r",$phase3reached,$warriorscreated,$progress);

			my %result = fight( $ownfilename,$opponent->{file},$rounds[2],$config{phase3}{fvalue} );

			# Score of the generetes warrior

			$wins+=$result{wins};
			$loss+=$result{loss};
			$ties+=$result{ties};
			$rounds+=$rounds[2];

			# Score of the opponent

			my %oppscore = wilkies( $result{loss},$result{ties},$rounds[2] );
			my %ranscore = wilkies( $result{wins},$result{ties},$rounds[2] );
            $opponent->{wins} = $oppscore{winsp};
			$opponent->{loss} = $oppscore{lossp};
			$opponent->{ties} = $oppscore{tiesp};
			$opponent->{score} = $oppscore{score};
			$opponent->{ranscore} = $ranscore{score};

			# Class highscore ?
			#print "Kampf : $opponent->{name} erreicht $opponent->{score}\n";
		}

		my %genscore = wilkies( $wins, $ties, $rounds );

		# Save score for compare Phase3 to Phase4 scores.

		$phase3score = $genscore{score};

		# Recalculate average score and actual average score.

		$phase3scoresum+=$genscore{score};
		$phase3averagescore=$phase3scoresum/$phase3reached;

		# Actual scores

		shift @phase3actualscores if ( $#phase3actualscores == 24 );
		push @phase3actualscores, $genscore{score};
		$phase3actualaveragescore = 0;
		foreach (@phase3actualscores)
		{
			$phase3actualaveragescore+=$_;
		}
		$phase3actualaveragescore/=$#phase3actualscores+1;

		if ( $genscore{score} > $phase3highscore{score} )
		{
			%phase3highscore = %genscore;
			print "\a\r" if ( $alarm eq 'highscore' );
		}
		my $phase3filename = catfile( $phase3dir, sprintf("%0.8u.red",$phase3reached));
		my $phase3htmlname = catfile( $phase3dir, sprintf("%0.8u.html",$phase3reached));


		if ( ($#phase3hill) == ($phase3top-1) )
		{
			if ( $genscore{score} > $phase3hill[$phase3top-1]{score} )
			{
				unlink ( $phase3hill[$phase3top-1]{filename} );
				unlink ( $phase3hill[$phase3top-1]{htmlname} );
				$#phase3hill = $phase3top-2;
			}
		}
		if ( $#phase3hill < ($phase3top-1 ))
		{
			# Randry hat einen Topscore erreicht.
			print "\a\r" if ( $alarm eq 'topscore' );
			printf ("Randry %u of %u has reached a topscore at phase 3 at %s.                     \n",$phase3reached,$warriorscreated,timer);

			$phase3topscoretime = timer();

			push @phase3hill, { filename =>	$phase3filename,
								htmlname =>	$phase3htmlname,
								number	=>	$phase3reached,
								try		=>	$warriorscreated,
								timestamp	=>	timer,
								wins =>		$genscore{winsp},
								loss =>		$genscore{lossp},
								ties =>		$genscore{tiesp},
								score =>	$genscore{score},
								dna =>		$dnastring,
								};

			# Update dynamic-highscore

			push @phase3hshistory, $genscore{score};
			@phase3hshistory = sort { $b <=> $a } @phase3hshistory;
			$#phase3hshistory = 4 if ( $#phase3hshistory > 4 );
			$phase3dynhighscore = ($phase3hshistory[0] + $phase3hshistory[-1])/2;

			# Sort new Table

			@phase3hill = sort { $b->{score} <=> $a->{score} } @phase3hill;

			# Save warriorfile to phasedir

			open(PHASEFILE, ">$phase3filename") or die "Can't create Phasefile : $!\n";
			print PHASEFILE @temp;
			close(PHASEFILE);

			# Create File for DNS-String's
			my $dnafilename = catfile( $phase3dir, 'dnadump' );
			open(DNA, ">$dnafilename") or die "Can't create dna-file.\n";

			# Determine oldest and newest entry on Hill

			my $newest = 0;

			foreach my $rank ( @phase3hill )
			{
				$newest = $rank->{number} if ( $newest < $rank->{number} );
			}

			# Create HTML-Site for Topscores
			my $topscore3name = catfile($phase3dir,'topscore.html' );
			open(TOPSCORE, ">$topscore3name") or die "Can't create Topsoresite\n";
			print TOPSCORE topscore3pre;
			my $rankindex = 1;
			foreach my $rank ( @phase3hill )
			{
				my $color = ( $rankindex/2 == int($rankindex/2) ) ? '#dddddd' : '#ffffff';
				printf TOPSCORE ("<tr>\n");
				printf TOPSCORE (" <td width=\"5%%\" align=\"center\" bgcolor=\"%s\"><big>%u<br></big></td>\n",( $rank->{number} == $newest ) ? '#aaaaff' : $color,$rankindex);
				printf TOPSCORE (" <td bgcolor=\"%s\" width=\"10%%\" align=\"center\"><big>%u<br></big></td>\n",$color,$rank->{try});
				printf TOPSCORE (" <td bgcolor=\"%s\"><a href=\"%0.8u.red\"><big>%0.8u</big></a><br></td>\n",$color,$rank->{number},$rank->{number});
				printf TOPSCORE (" <td bgcolor=\"%s\" width=\"10%%\" align=\"center\"><big>%s<br></big></td>\n",$color,$rank->{timestamp},$rank->{wins});
				printf TOPSCORE (" <td bgcolor=\"%s\" width=\"10%%\" align=\"center\"><big>%6.2f<br></big></td>\n",$color,$rank->{wins});
				printf TOPSCORE (" <td bgcolor=\"%s\" width=\"10%%\" align=\"center\"><big>%6.2f<br></big></td>\n",$color,$rank->{loss});
				printf TOPSCORE (" <td bgcolor=\"%s\" width=\"10%%\" align=\"center\"><big>%6.2f<br></big></td>\n",$color,$rank->{ties});
				printf TOPSCORE (" <td bgcolor=\"%s\" width=\"15%%\" align=\"center\"><big><a href=\"%0.8u.html\">%6.2f</a> ",$color,$rank->{number},$rank->{score});
				foreach my $entry ( @phase4hill )
				{
					printf TOPSCORE ("<a href=\"%s\">(4)</a>",catfile( "..","..",$entry->{htmlname})) if ( $rank->{number} == $entry->{number} );
				}
				printf TOPSCORE ("<br></big></td>\n");

				printf TOPSCORE ("</tr>\n");

				$rankindex++;

				# Print dnsstring to dump file.
				print DNA "$rank->{dna}\n";
			}
			print TOPSCORE topscorepost;
			close(TOPSCORE);

			close(DNA);
            
            createphase3htmldna();

			# Create HTML-Site for Score of one generated warrior

			@opponents = sort { $b->{score} <=> $a->{score} } @opponents;

			open(PH, ">$phase3htmlname") or die "Can't create Phasefile : $!\n";
			print PH singlescorepre;
			printf PH ("<big><big>Phase 3 result of Version <a href=\"%0.8u.red\">%0.8u</a> of <a href=\"%s\">%s</a> is %6.2f/%6.2f/%6.2f - Score = %6.2f<br>\n",$phase3reached,$phase3reached,catfile( "..","..",$clientfile ),$clientname,$genscore{winsp},$genscore{lossp},$genscore{tiesp},$genscore{score});
			print PH singlescorefirstmiddle;
			$rankindex = 1;

			my %cleval = ();	# Hash fr class-evaluation.

			foreach my $opp ( @opponents )
			{
				my $cstring = $opp->{class};
				my $color = $classes{$cstring}{color};
				print PH "<tr>\n";
				printf PH ("<td align=\"center\" bgcolor=\"%s\"><big>%u<br></big></td>\n",$color,$rankindex);
				printf PH ("<td align=\"center\" bgcolor=\"%s\"><big>%s<br></big></td>\n",$color,$opp->{class});
				printf PH ("<td bgcolor=\"%s\"><a href=\"../../%s\"><big>%s<br></big></a></td>\n",$color,$opp->{file},$opp->{name});
				printf PH ("<td width=\"10%%\" align=\"center\" bgcolor=\"%s\"><big>%6.2f<br></big></td>\n",$color,$opp->{wins});
				printf PH ("<td width=\"10%%\" align=\"center\" bgcolor=\"%s\"><big>%6.2f<br></big></td>\n",$color,$opp->{loss});
				printf PH ("<td width=\"10%%\" align=\"center\" bgcolor=\"%s\"><big>%6.2f<br></big></td>\n",$color,$opp->{ties});
				printf PH ("<td width=\"10%%\" align=\"center\" bgcolor=\"%s\"><big>%6.2f<br></big></td>\n",$color,$opp->{score});
				printf PH ("<td width=\"10%%\" align=\"center\" bgcolor=\"%s\"><big>%6.2f<br></big></td>\n",$color,$opp->{ranscore});
                print PH "</tr>\n";

				# Collect data for by class evaluation.
				$cleval{$cstring}{count}++;			# How much entrys for actual class
				$cleval{$cstring}{avwins}+=$opp->{wins};
				$cleval{$cstring}{avloss}+=$opp->{loss};
				$cleval{$cstring}{avties}+=$opp->{ties};
				$cleval{$cstring}{avscore}+=$opp->{score};
				$cleval{$cstring}{avrank}+=$rankindex;

				$cleval{$cstring}{hiwins} = $opp->{wins} if ( ! $cleval{$cstring}{hiwins} );
				$cleval{$cstring}{hiloss} = $opp->{loss} if ( ! $cleval{$cstring}{hiloss} );
				$cleval{$cstring}{hities} = $opp->{ties} if ( ! $cleval{$cstring}{hities} );
				$cleval{$cstring}{hiscore} = $opp->{score} if ( ! $cleval{$cstring}{hiscore} );
				$cleval{$cstring}{hirank} = $rankindex if ( ! $cleval{$cstring}{hirank} );

				$cleval{$cstring}{hiwins}=$opp->{wins} if ( $cleval{$cstring}{hiwins} < $opp->{wins} );
				$cleval{$cstring}{hiloss}=$opp->{loss} if ( $cleval{$cstring}{hiloss} < $opp->{loss} );
				$cleval{$cstring}{hities}=$opp->{ties} if ( $cleval{$cstring}{hities} < $opp->{ties} );
				$cleval{$cstring}{hiscore}=$opp->{score} if ( $cleval{$cstring}{hiscore} < $opp->{score} );
				$cleval{$cstring}{hirank}= $rankindex if ( $cleval{$cstring}{hirank} > $rankindex );

				$rankindex++;
			}

			foreach my $key ( keys %cleval )
			{
				$cleval{$key}{avwins}/=$cleval{$key}{count};
				$cleval{$key}{avloss}/=$cleval{$key}{count};
				$cleval{$key}{avties}/=$cleval{$key}{count};
				$cleval{$key}{avscore}/=$cleval{$key}{count};
				$cleval{$key}{avrank}/=$cleval{$key}{count};
			}

			my @cls = sort { $cleval{$b}{avscore} <=> $cleval{$a}{avscore} } keys %cleval;

			print PH singlescoresecondmiddle;

			foreach my $key ( @cls )
			{
				printf PH ("<tr>");
				printf PH ("<td bgcolor=\"%s\">%s<br></td>",$classes{$key}{color},$classes{$key}{name});
				printf PH ("<td bgcolor=\"%s\" width=\"5%%\" align=\"center\">%u<br></td>",$classes{$key}{color},$cleval{$key}{avrank});
				printf PH ("<td bgcolor=\"%s\" width=\"20%%\" align=\"center\">%6.2f/%6.2f/%6.2f<br></td>",$classes{$key}{color},$cleval{$key}{avwins},$cleval{$key}{avloss},$cleval{$key}{avties});
				printf PH ("<td bgcolor=\"%s\" width=\"10%%\" align=\"center\">%6.2f<br></td>",$classes{$key}{color},$cleval{$key}{avscore});
				printf PH ("<td bgcolor=\"%s\" width=\"5%%\" align=\"center\">%u<br></td>",$classes{$key}{color},$cleval{$key}{hirank});
				printf PH ("<td bgcolor=\"%s\" width=\"20%%\" align=\"center\">%6.2f/%6.2f/%6.2f<br></td>",$classes{$key}{color},$cleval{$key}{hiwins},$cleval{$key}{hiloss},$cleval{$key}{hities});
				printf PH ("<td bgcolor=\"%s\" width=\"10%%\" align=\"center\">%6.2f<br></td>",$classes{$key}{color},$cleval{$key}{hiscore});
				printf PH ("</tr>");
			}
			print PH singlescorepost;
			close(PH);
		}

		if ( $genscore{score} <= $phase3targetstatic )
		{
			$phase3failed++;
			unlink $ownfilename;
			return 0;
		}
		if ( $genscore{score} <= ($phase3highscore{score}/100)*$phase3targetdynamic )
		{
			$phase3failed++;
			unlink $ownfilename;
			return 0;
		}

	}
	$phase3actualinout[$#phase3actualinout] = 1;
	$phase3actualinoutrelation++;


	######################################################################################
	#
	# Phase 4 - Grand Prix		Challenger against the Top-Warriors from each
	#							Warriorclass.
	#
	######################################################################################

	writestats() if ( @phase4hill );

	$phase4reached++;

	if ( $phaseenabled[3] )
	{
		my	( $wins,$loss,$ties,$rounds ) = 0;
		my	@opponents = @phase4opponentsdetailed;

		my $oppcount = 1;
		my $oppmax = $#opponents+1;
		my $progress = ' ';


		foreach my $opponent ( @opponents )
		{

		    if ( -e $skipname )
    		{
    			unlink $skipname;
     			printf("%4d/%4d was skipped.                                                     \n" ,$phase4reached,$warriorscreated);
				return 0;
			}

            $progress = sprintf("=" x (($oppcount++/$oppmax)*50) );
			printf("%4d/%4d in Phase 4 |%-50s|\r",$phase4reached,$warriorscreated,$progress);

			my %result = fight( $ownfilename,$opponent->{file},$rounds[3],$config{phase4}{fvalue} );

			# Accumulate results of the generated warriors

			$wins+=$result{wins};
			$loss+=$result{loss};
			$ties+=$result{ties};
			$rounds+=$rounds[3];

			# Ownscore for sd-calc

			my %ownscore = wilkies( $result{wins},$result{ties}, $rounds[3] );

			# Score of the opponent

			my %oppscore = wilkies( $result{loss},$result{ties},$rounds[3] );

			# Save scores in each opponents-structure

			$opponent->{wins} = $oppscore{winsp};
			$opponent->{loss} = $oppscore{lossp};
			$opponent->{ties} = $oppscore{tiesp};
			$opponent->{score} = $oppscore{score};
			$opponent->{ranscore} = $ownscore{score};

			# Class highscore ?
			#print "Kampf : $opponent->{name} erreicht $opponent->{score}\n";
		}

		my %genscore = wilkies( $wins, $ties, $rounds );

		# Calc the standart deviation of the score against the opponents.

		my $stddev = 0;

		foreach $opponent ( @opponents )
		{
			$stddev += ($opponent->{ranscore} - $genscore{score}) ** 2
		}

		$stddev /= ($#opponents+1);

		$stddev=sqrt($stddev);

		$phase4score = $genscore{score};

		# Calculate difference between 3 and 4 percentage.

		push @diff34, $phase4score/($phase3score/100);

		# Calculate global difference between Phase3 and Phase4 in %

    	if ( $phaseenabled[2] )
		{
			$diff34overall = 0;
			foreach $diff ( @diff34 )
			{
				$diff34overall += $diff;
			}
			$diff34overall/=($#diff34+1);
		}

		my $diffsd = 0;

        foreach $diff ( @diff34 )
		{
			$diffsd += ($diff - $diff34overall) ** 2;
        }

        $diffsd /= $#diff34+1;

        $diff34overallsd =sqrt($diffsd);

		# Recalculate average score and actual average score.

		$phase4scoresum+=$genscore{score};
		$phase4averagescore=$phase4scoresum/$phase4reached;

		# Actual scores

		shift @phase4actualscores if ( $#phase4actualscores == 24 );
		push @phase4actualscores, $genscore{score};
		$phase4actualaveragescore = 0;
		foreach (@phase4actualscores)
		{
			$phase4actualaveragescore+=$_;
		}
		$phase4actualaveragescore/=$#phase4actualscores+1;
		if ( $genscore{score} > $phase4highscore{score} )
		{
			%phase4highscore = %genscore;
			print "\a\r" if ( $alarm eq 'highscore' );
		}
		my $phase4filename = catfile( $phase4dir, sprintf("%0.8u.red",$phase3reached));
		my $phase4htmlname = catfile( $phase4dir, sprintf("%0.8u.html",$phase3reached));

		if ( ($#phase4hill) == ($phase4top-1) )
		{
			if ( $genscore{score} > $phase4hill[$phase4top-1]{score} )
			{
				unlink ( $phase4hill[$phase4top-1]{filename} );
				unlink ( $phase4hill[$phase4top-1]{htmlname} );
				$#phase4hill = $phase4top-2;
			}
			else
			{
				unlink $ownfilename;	# Cleaning up after 3, if 4 is open this line must go down.
				return 0;
			}
		}
		if ( $#phase4hill < ($phase4top-1 ))
		{
			# Randry hat einen Topscore erreicht.

			print "\a\r" if ( $alarm eq 'topscore' );
			printf ("Randry %u of %u has reached a topscore at phase 4 at %s.                     \n",$phase3reached,$warriorscreated,timer);

			$phase4topscoretime = timer();

			push @phase4hill, { filename =>	$phase4filename,
								htmlname =>	$phase4htmlname,
								number	=>	$phase3reached,
								try		=>	$warriorscreated,
								timestamp	=>	timer,
								wins =>		$genscore{winsp},
								loss =>		$genscore{lossp},
								ties =>		$genscore{tiesp},
								score =>	$genscore{score},
								dna =>		$dnastring,
								sd =>		$stddev,
								};

			# Sort new Table

			@phase4hill = sort { $b->{score} <=> $a->{score} } @phase4hill;

			# Save warriorfile to phasedir

			open(PHASEFILE, ">$phase4filename") or die "Can't create Phasefile : $!\n";
			print PHASEFILE @temp;
			close(PHASEFILE);

			# Determine oldest and newest entry on Hill

			my $newest = 0;

			foreach my $rank ( @phase4hill )
			{
				$newest = $rank->{number} if ( $newest < $rank->{number} );
			}

			# Create File for DNS-String's
			my $dnafilename = catfile( $phase4dir, 'dnadump' );
			open(DNA, ">$dnafilename") or die "Can't create dna-file.\n";
			# Create HTML-Site for Topscores
			my $topscore4name = catfile($phase4dir,'topscore.html' );
			open(TOPSCORE, ">$topscore4name") or die "Can't create Topsoresite\n";
			print TOPSCORE topscore4pre;
			my $rankindex = 1;
			foreach my $rank ( @phase4hill )
			{
				my $color = ( $rankindex/2 == int($rankindex/2) ) ? '#dddddd' : '#ffffff';
				printf TOPSCORE ("<tr>\n");
				printf TOPSCORE (" <td width=\"5%%\" align=\"center\" bgcolor=\"%s\"><big>%u<br></big></td>\n",( $rank->{number} == $newest ) ? '#aaaaff' : $color,$rankindex);
				printf TOPSCORE (" <td bgcolor=\"%s\" width=\"10%%\" align=\"center\"><big>%u<br></big></td>\n",$color,$rank->{try});
				printf TOPSCORE (" <td bgcolor=\"%s\"><a href=\"%0.8u.red\"><big>%0.8u</big></a><br></td>\n",$color,$rank->{number},$rank->{number});
				printf TOPSCORE (" <td bgcolor=\"%s\" width=\"10%%\" align=\"center\"><big>%s<br></big></td>\n",$color,$rank->{timestamp},$rank->{wins});
				printf TOPSCORE (" <td bgcolor=\"%s\" width=\"10%%\" align=\"center\"><big>%6.2f<br></big></td>\n",$color,$rank->{wins});
				printf TOPSCORE (" <td bgcolor=\"%s\" width=\"10%%\" align=\"center\"><big>%6.2f<br></big></td>\n",$color,$rank->{loss});
				printf TOPSCORE (" <td bgcolor=\"%s\" width=\"10%%\" align=\"center\"><big>%6.2f<br></big></td>\n",$color,$rank->{ties});
				printf TOPSCORE (" <td bgcolor=\"%s\" width=\"15%%\" align=\"center\"><big><a href=\"%0.8u.html\">%6.2f</a> ",$color,$rank->{number},$rank->{score});
				foreach my $entry ( @phase3hill )
				{
					printf TOPSCORE ("<a href=\"%s\">(3)</a>",catfile( "..","..",$entry->{htmlname})) if ( $rank->{number} == $entry->{number} );
				}
				printf TOPSCORE ("<br></big></td>\n");
				printf TOPSCORE (" <td bgcolor=\"%s\" width=\"10%%\" align=\"center\"><big>%6.2f</big></td>\n",$color,$rank->{sd});
				printf TOPSCORE ("</tr>\n");

				$rankindex++;

				# Print dnsstring to dump file.
				print DNA "$rank->{dna}\n";
			}
			print TOPSCORE topscorepost;
			close(TOPSCORE);

			close(DNA);

            createphase4htmldna();

			# Create HTML-Site for Score of one generated warrior

			@opponents = sort { $b->{score} <=> $a->{score} } @opponents;

			open(PH, ">$phase4htmlname") or die "Can't create Phasefile : $!\n";
			print PH singlescorepre;
			printf PH ("<big><big>Phase 4 result of version <a href=\"%0.8u.red\">%0.8u</a> of <a href=\"%s\">%s</a> is %6.2f/%6.2f/%6.2f - Score = %6.2f<br>\n",$phase3reached,$phase3reached,catfile( "..","..",$clientfile ),$clientname,$genscore{winsp},$genscore{lossp},$genscore{tiesp},$genscore{score});
			print PH singlescorefirstmiddle;
			$rankindex = 1;

			my %cleval = ();	# Hash fr class-evaluation.

			foreach my $opp ( @opponents )
			{
				my $cstring = $opp->{class};
				my $color = $classes{$cstring}{color};
				print PH "<tr>\n";
				printf PH ("<td align=\"center\" bgcolor=\"%s\"><big>%u<br></big></td>\n",$color,$rankindex);
				printf PH ("<td align=\"center\" bgcolor=\"%s\"><big>%s<br></big></td>\n",$color,$opp->{class});
				printf PH ("<td bgcolor=\"%s\"><a href=\"../../%s\"><big>%s<br></big></a></td>\n",$color,$opp->{file},$opp->{name});
				printf PH ("<td width=\"10%%\" align=\"center\" bgcolor=\"%s\"><big>%6.2f<br></big></td>\n",$color,$opp->{wins});
				printf PH ("<td width=\"10%%\" align=\"center\" bgcolor=\"%s\"><big>%6.2f<br></big></td>\n",$color,$opp->{loss});
				printf PH ("<td width=\"10%%\" align=\"center\" bgcolor=\"%s\"><big>%6.2f<br></big></td>\n",$color,$opp->{ties});
				printf PH ("<td width=\"10%%\" align=\"center\" bgcolor=\"%s\"><big>%6.2f<br></big></td>\n",$color,$opp->{score});
				printf PH ("<td width=\"10%%\" align=\"center\" bgcolor=\"%s\"><big>%6.2f<br></big></td>\n",$color,$opp->{ranscore});
                print PH "</tr>\n";

				# Collect data for by class evaluation.
				$cleval{$cstring}{count}++;			# How much entrys for actual class
				$cleval{$cstring}{avwins}+=$opp->{wins};
				$cleval{$cstring}{avloss}+=$opp->{loss};
				$cleval{$cstring}{avties}+=$opp->{ties};
				$cleval{$cstring}{avscore}+=$opp->{score};
				$cleval{$cstring}{avrank}+=$rankindex;

				$cleval{$cstring}{hiwins} = $opp->{wins} if ( ! $cleval{$cstring}{hiwins} );
				$cleval{$cstring}{hiloss} = $opp->{loss} if ( ! $cleval{$cstring}{hiloss} );
				$cleval{$cstring}{hities} = $opp->{ties} if ( ! $cleval{$cstring}{hities} );
				$cleval{$cstring}{hiscore} = $opp->{score} if ( ! $cleval{$cstring}{hiscore} );
				$cleval{$cstring}{hirank} = $rankindex if ( ! $cleval{$cstring}{hirank} );

				$cleval{$cstring}{hiwins}=$opp->{wins} if ( $cleval{$cstring}{hiwins} < $opp->{wins} );
				$cleval{$cstring}{hiloss}=$opp->{loss} if ( $cleval{$cstring}{hiloss} < $opp->{loss} );
				$cleval{$cstring}{hities}=$opp->{ties} if ( $cleval{$cstring}{hities} < $opp->{ties} );
				$cleval{$cstring}{hiscore}=$opp->{score} if ( $cleval{$cstring}{hiscore} < $opp->{score} );
				$cleval{$cstring}{hirank}= $rankindex if ( $cleval{$cstring}{hirank} > $rankindex );

				$rankindex++;
			}

			foreach my $key ( keys %cleval )
			{
				$cleval{$key}{avwins}/=$cleval{$key}{count};
				$cleval{$key}{avloss}/=$cleval{$key}{count};
				$cleval{$key}{avties}/=$cleval{$key}{count};
				$cleval{$key}{avscore}/=$cleval{$key}{count};
				$cleval{$key}{avrank}/=$cleval{$key}{count};
			}

			my @cls = sort { $cleval{$b}{avscore} <=> $cleval{$a}{avscore} } keys %cleval;

			#foreach $key ( @cls )
			#{
		#		print "Klasse $key hat durchschn. $cleval{$key}{avscore} Punkte.\n";
			#}
			print PH singlescoresecondmiddle;

			foreach my $key ( @cls )
			{
			printf PH ("<tr>");
			printf PH ("<td bgcolor=\"%s\">%s<br></td>",$classes{$key}{color},$classes{$key}{name});
			printf PH ("<td bgcolor=\"%s\" width=\"5%%\" align=\"center\">%u<br></td>",$classes{$key}{color},$cleval{$key}{avrank});
			printf PH ("<td bgcolor=\"%s\" width=\"20%%\" align=\"center\">%6.2f/%6.2f/%6.2f<br></td>",$classes{$key}{color},$cleval{$key}{avwins},$cleval{$key}{avloss},$cleval{$key}{avties});
			printf PH ("<td bgcolor=\"%s\" width=\"10%%\" align=\"center\">%6.2f<br></td>",$classes{$key}{color},$cleval{$key}{avscore});
			printf PH ("<td bgcolor=\"%s\" width=\"5%%\" align=\"center\">%u<br></td>",$classes{$key}{color},$cleval{$key}{hirank});
			printf PH ("<td bgcolor=\"%s\" width=\"20%%\" align=\"center\">%6.2f/%6.2f/%6.2f<br></td>",$classes{$key}{color},$cleval{$key}{hiwins},$cleval{$key}{hiloss},$cleval{$key}{hities});
			printf PH ("<td bgcolor=\"%s\" width=\"10%%\" align=\"center\">%6.2f<br></td>",$classes{$key}{color},$cleval{$key}{hiscore});

			printf PH ("</tr>");
			}
			print PH singlescorepost;
			close(PH);
		}
	}
	unlink $ownfilename;	# Cleaning up after 3, if 4 is open this line must go down.
	writestats();
	return 0;
}

sub randomizer
{
    my $dnatext = ();
    $_[0]  =~ s/".+"//;
    $dnatext = $&;
    #print "$dnatext\n";
    my @data = $_[0] =~ m/(\d+)/g;
    ( $data[0], $data[1] ) = ( $data[1], $data[0] ) if ( $data[0] > $data[1] );
	my $zufall = int((rand($data[1]-$data[0])+$data[0])+0.5);
	#print "$zufall\n";
    if ( !$dnatext )
    {
      push @dna, "!($data[0]-$data[1])";
    }
    else
    {
      push @dna, $dnatext;
    }
    push @dna, $zufall;
	return $zufall;
}

sub get_randomly_from_table
{
    my $dnatext = "";
    $_[0]  =~ s/".+"//;
    $dnatext = $&;

    my $tablefile = substr ( $_[0], 2, length( $_[0] )-3 );
    if ( !exists($tables{$tablefile}) )
    {
    	# Tabelle einlesen und gre setzen.

        my $tablefilename = catfile( "tables", $tablefile );
        open(TABLE, "$tablefilename") or die "Couldn't find table $tablefilename : $!\n";

    	my @data = <TABLE>;
		chomp @data;
		close(TABLE);

		$tables{$tablefile}{data} = [ @data ];
        $tables{$tablefile}{size} = $#data;
    }

    my $pindex = int( rand( $tables{$tablefile}{size}) +0.5 );

    my $zufall = $tables{$tablefile}{data}[$pindex];
    if ( !$dnatext )
    {
      push @dna, "!($tablefile)";
    }
    else
    {
      push @dna, $dnatext;
    }
    push @dna, $zufall;
    return $zufall;
}


BEGIN
{
	my	$starttime = time;            # Get the starting Time.

	# timer returns an hh:mm:ss string with the time optimax runs.

	sub timer
	{
		my $nowtime = time;
		my $difftime = $nowtime - $starttime;

		@timeparts = gmtime( $difftime );
		
        if ( $timeparts[7] >=1 ) # If run's more than 24h day of year is 1
        {
			return sprintf("%0.2ud %0.2u:%0.2u",$timeparts[7],$timeparts[2],$timeparts[1]);

        }
		else # Run's < 24h
        {
			return sprintf("%0.2u:%0.2u:%0.2u",$timeparts[2],$timeparts[1],$timeparts[0]);
		}
	}
}


sub expanded
{
	my @lines = @_;
	my ( @matching, @data, @temp ) = ();

    @matching = grep { /!\{\d+-\d+}|!<.+?>|!\[.+?\]|!<.+?:\d>/ } @lines or return 1;

	#####
	#
	# !<:n> - operator
	#
	#####

	if  ( $matching[0] =~ /!<.+?:\d>/ )
	{
		my $opstr = $&;
        my @data = split(/:/, substr( $&, 2, -1 ));
		open(DATAFILE, "<$data[0]") or die "Couldn't open $data[0] : $!\n";
		my @rows=();
		while (<DATAFILE>)
		{
			chomp;
			push @rows, $_
		}
		close(DATAFILE);

		my @dnastack = @dna;
		foreach my $row ( @rows )
		{
			@dna = @dnastack;
			my @temp = @lines;
			my @columns = split(/\|/, $row);
			foreach my $line ( @temp )
			{
				if ( $line =~ /!<$data[0]:\d>/ )
				{
					my $col = substr( $&, -2, 1 );
					my $line =~ s/!<$data[0]:\d>/$columns[$col]/;
					push @dna, $opstr;
                    push @dna, $columns[$col];
				}
			}
			if ( expanded( @temp) )	{ benchmark ( @temp ) }
		}
		return 0;
	}

	#####
	#
	# !{} - operator
	#
	#####

    if ( $matching[0] =~ m/!\{\d+-\d+\}/ )
	{
		my $opstr = $&;
		my @fromto = $& =~ m/(\d+)/g;
        #print "$opstr\n";

        my @data = ();
		if ( $fromto[0] > $fromto[1] )
		{
			@data = reverse ($fromto[1]..$fromto[0])
		}
		else
		{
			@data = ($fromto[0]..$fromto[1]);
		}
		my @dnastack = @dna;
		foreach my $date ( @data )
		{
			@dna = @dnastack;
			push @dna, $opstr;
			my @temp = @lines;
			my $c=-1;		# Counter fr beide Array's
			do { $c++ } until ( $temp[$c] =~ s/!\{\d+-\d+\}/$date/ );
			push @dna, $date;
			if ( expanded( @temp) ) { benchmark ( @temp ) }
		}
		return 0;
	}

	#####
	#
	# !<> - operator
	#
	#####

	if  ( $matching[0] =~ /!<.+?>/ )
	{
		my $opstr = $&;
		my $filename = substr( $&, 2, -1 );
		open(DATAFILE, "<$filename") or die "Couldn't open $filename : $!\n";
		my @data= ();
		while (<DATAFILE>)
		{
			chomp;
			push @data, $_
		}
		close(DATAFILE);

		my @dnastack = @dna;
		foreach my $date ( @data )
		{
			@dna = @dnastack;
			push @dna, $opstr;
			my @temp = @lines;
			my $c=-1;		# Counter fr beide Array's
			do { $c++ } until( $temp[$c] =~ s/!<.+?>/$date/);
			push @dna, $date;
			if ( expanded( @temp) )	{ benchmark ( @temp ) }
		}
		return 0;
	}

	#####
	#
	# ![] - operator
	#
	#####

	if ( $matching[0] =~ m/!\[.+?\]/ )
	{
		my $opstr = $&;
		my @data = substr( $&, 2, -1 ) =~ m/[^\|]+/g ;
		my @dnastack = @dna;
		foreach my $date ( @data )
		{
			@dna = @dnastack;
			push @dna, $opstr;
			my @temp = @lines;
			my $c=-1;		# Counter fr beide Array's
			do { $c++ } until ( $temp[$c] =~ s/!\[.+?\]/$date/ );
			push @dna, $date;
			if ( expanded( @temp) ) { benchmark ( @temp ) }
		}
		return 0;
	}
}

# wilkies - Scoring formula, needs wins,ties and rounds as params
# Returns an Array with W%,L%,T%, Score

sub wilkies
{
	my	%result;
	my	( $win, $tie, $rounds ) = @_;
	$result{winsp} = $win/($rounds/100);
	$result{lossp} = ($rounds-$win-$tie)/($rounds/100);
	$result{tiesp} = $tie/($rounds/100);
	$result{score} = $result{winsp}*3+$result{tiesp};

	return %result;
}

# collectdetails - fills an array with all datas about the warriors from the given list.

sub collectdetails
{
	my @list = @_;
	my @warriordetails = ();

	foreach my $fname ( @list )
	{
		my ( $name,$author,$class ) = ( 'anonymous', 'anonymous', 'ano' );
		my ( $wins,$loss,$ties,$score ) = 0;

		my $file = $fname;
		open(WFILE, "$fname") or die "Can't find $fname : $!\n";
		while (	my $line = <WFILE> )
		{
			chomp $line;
			( $name = $line ) =~ s/;[nN][aA][mM][eE] // if ( $line =~ m/;[nN][aA][mM][eE]/ );
			( $author = $line ) =~ s/;[aA][uU][tT][hH][oO][rR] // if ( $line =~ m/;[aA][uU][tT][hH][oO][rR]/);
			( $class = $line ) =~ s/;[oO][pP][tT][iI][mM][aA][xX] // if ( $line =~ m/;[oO][pP][tT][iI][mM][aA][xX]/);


			chomp $name;
			chomp $author;
			chomp $class;
		}
		close(WFILE);
		push @warriordetails, { file => $file,
								name => $name,
								author => $author,
								class => $class,
								wins => $wins,
								loss => $loss,
								ties => $ties,
								score => $score,
							  };
	}
	return @warriordetails;
}

sub topscore3pre {

my $pre = <<"PRE";
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
  <title>Topscores Phase 3</title>
  <meta http-equiv="content-type" content="text/html; charset=ISO-8859-1">
  <meta http-equiv="refresh" content="10">
</head>
<body>
<big><big>Phase 3 - Topscores <a href=\"dna.html\">(DNA)</a> -----> (<a href=\"../phase4/topscore.html\">Topscore 4</a>)<br>
<br>
</big></big>
<table cellpadding="2" cellspacing="1" border="1" width="100%">
  <tbody>
    <tr>
      <td bgcolor="#000000" valign="top" width="5%" align="center"><font color="#fffff"><big>Rank<br></big></td>
      <td bgcolor="#000000" valign="top" width="10%" align="center"><font color="#fffff"><big>Randry No.<br></big></td>
	  <td bgcolor="#000000" valign="top"><font color="#fffff"><big>Phase 3 Name<br></big></td>
      <td bgcolor="#000000" valign="top" width="10%" align="center"><font color="#fffff"><big>Time<br></big></td>
      <td bgcolor="#000000" valign="top" width="10%" align="center"><font color="#fffff"><big>Win %<br></big></td>
      <td bgcolor="#000000" valign="top" width="10%" align="center"><font color="#fffff"><big>Loss %<br></big></td>
      <td bgcolor="#000000" valign="top" width="10%" align="center"><font color="#fffff"><big>Tie %<br></big></td>
      <td bgcolor="#000000" valign="top" width="15%" align="center"><font color="#fffff"><big>Score<br></big></td>
    </tr>
PRE

return $pre;
}

sub topscore4pre {

my $pre = <<"PRE";
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
  <title>Topscores Phase 4</title>
  <meta http-equiv="content-type" content="text/html; charset=ISO-8859-1">
  <meta http-equiv="refresh" content="10">
</head>
<body>
<big><big>Phase 4 - Topscores <a href=\"dna.html\">(DNA)</a> -----> (<a href=\"../phase3/topscore.html\">Topscore 3</a>)<br>
<br>
</big></big>
<table cellpadding="2" cellspacing="1" border="1" width="100%">
  <tbody>
    <tr>
      <td bgcolor="#000000" valign="top" width="5%" align="center"><font color="#fffff"><big>Rank<br></big></td>
      <td bgcolor="#000000" valign="top" width="10%" align="center"><font color="#fffff"><big>Randry No.<br></big></td>
	  <td bgcolor="#000000" valign="top"><font color="#fffff"><big>Phase 4 Name<br></big></td>
      <td bgcolor="#000000" valign="top" width="10%" align="center"><font color="#fffff"><big>Time<br></big></td>
      <td bgcolor="#000000" valign="top" width="10%" align="center"><font color="#fffff"><big>Win %<br></big></td>
      <td bgcolor="#000000" valign="top" width="10%" align="center"><font color="#fffff"><big>Loss %<br></big></td>
      <td bgcolor="#000000" valign="top" width="10%" align="center"><font color="#fffff"><big>Tie %<br></big></td>
      <td bgcolor="#000000" valign="top" width="15%" align="center"><font color="#fffff"><big>Score<br></big></td>
      <td bgcolor="#000000" valign="top" width="10%" align="center"><font color="#fffff"><big>Stddev<br></big></td>
	</tr>
PRE

return $pre;
}


sub topscorepost {

my $post = <<"POST";
  </tbody>
</table>

</body>
</html>
POST

return $post;
}


sub singlescorepre {

my $pre = <<"PRE";
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
  <title>Scoring One by one / by Class</title>
  <meta http-equiv="content-type" content="text/html; charset=ISO-8859-1">
</head>
<body>
PRE

return $pre
}

sub singlescorefirstmiddle
{

my $firstmiddle = <<"FIRSTMIDDLE";
<br>
<a name="onebyone"></a>Opponents-score One-by-one ( by Class look <a href="#byclass">here</a> )
<br>
</big></big>
<table cellpadding="2" cellspacing="1" border="1" width="100%">
  <tbody>
    <tr>
      <td valign="top" bgcolor="#000000" width="5%"><font color="#fffff"><big>Rank<br></big></td>
      <td valign="top" bgcolor="#000000" width="5%"><font color="#fffff"><big>Class<br></big></td>
      <td valign="top" bgcolor="#000000" ><font color="#fffff"><big>Name <br></big></td>
      <td valign="top" bgcolor="#000000" width="10%" align="center"><font color="#fffff"><big>Win %<br></big></td>
      <td valign="top" bgcolor="#000000" width="10%" align="center"><font color="#fffff"><big>Loss %<br></big></td>
      <td valign="top" bgcolor="#000000" width="10%" align="center"><font color="#fffff"><big>Tie %<br></big></td>
      <td valign="top" bgcolor="#000000" width="10%" align="center"><font color="#fffff"><big>Score taken<br></big></td>
      <td valign="top" bgcolor="#000000" width="10%" align="center"><font color="#fffff"><big>Score given<br></big></td>
    </tr>
FIRSTMIDDLE

return $firstmiddle;
}

sub singlescoresecondmiddle
{
my $secondmiddle = <<"SECONDMIDDLE";
  </tbody>
</table>
  <big><big><br>
  <br>
<a name="byclass"></a>Opponents-score by Class ( One-by-one look <a href="#onebyone">here</a> )
 <br>
  </big></big><big><big><br>
 </big></big>
<table cellpadding="2" cellspacing="1" border="1" width="100%">
<tbody>
<tr>
<td valign="top" bgcolor="#000000"><font color="#ffffff">Class<br></font></td>
<td valign="top" width="5%" align="center" bgcolor="#000000"><font color="#ffffff">Average<br>Rank<br></font></td>
<td valign="top" width="15%" align="center" bgcolor="#000000"><font color="#ffffff">Average<br>W%/L%/T%<br></font></td>
<td valign="top" width="10%" align="center" bgcolor="#000000"><font color="#ffffff">Average <br>Score<br></font></td>
<td valign="top" width="5%" align="center" bgcolor="#000000"><font color="#ffffff">Peak<br>Rank<br></font></td>
<td valign="top" width="15%" align="center" bgcolor="#000000"><font color="#ffffff">Peak<br>W%/L%/T%<br></font></td>
<td valign="top" width="10%" align="center" bgcolor="#000000"><font color="#ffffff">Peak<br>Score<br></font></td>
</tr>
SECONDMIDDLE

return $secondmiddle;
}

sub singlescorepost
{
my $post = <<"POST";
  </tbody>
</table>
<big><big><br>
</big></big>
</body>
</html>
POST

return $post;
}

# fight needs the two Warriors to fight and the number of rounds. It invokes optimars and
# return an extract of the optimars output.

sub fight
{
	my ( $warrior1, $warrior2, $rounds, $F ) = @_;

	my %result = ();

	my @lines = ();

    @lines = core_fight( '-r',$rounds, '-F', $F, $config{fsh}{optimars_str}, $warrior1, $warrior2 );

	my @values = ( split(/ /, $lines[0]),split(/ /, $lines[1]) );

	chomp @values;
	#print "@values\n";
	$result{wins} = $values[0];
	$result{ties} = $values[1];
	$result{loss} = $values[2];

	#printf ("Fight %s vs. %s - %u/%u/%u \n",$warrior1,$warrior2,$result{wins},$result{loss},$result{ties});
	return %result;
}

sub writesettings
{
    open(SETTINGS, ">".catfile( $workdir, "settings.txt"))
	 or die "Can't create settingsfile: $!\n";

	print SETTINGS "phase2targetstatic = $phase2targetstatic\n";
	print SETTINGS "phase2targetdynamic = $phase2targetdynamic\n";
	print SETTINGS "phase3targetstatic = $phase3targetstatic\n";
	print SETTINGS "phase3targetdynamic = $phase3targetdynamic\n";

	close(SETTINGS);
}

sub reinitsettings
{
	open(RESET, "$resetname")
	 or die "Can't open settingsfile: $!\n";
	my @lines = <RESET>;
	chomp @lines;
	foreach my $line ( @lines )
	{
		my @parts = split(/ = /,$line);
		$phase2targetstatic = $parts[1] if ( $parts[0] eq 'phase2targetstatic' );
		$phase2targetdynamic = $parts[1] if ( $parts[0] eq 'phase2targetdynamic' );
		$phase3targetstatic = $parts[1] if ( $parts[0] eq 'phase3targetstatic' );
		$phase3targetdynamic = $parts[1] if ( $parts[0] eq 'phase3targetdynamic' );
	}
	close(RESET);
	print "Setting's have been changed.                                                    \n";
	unlink $resetname;
	writesettings();
}

sub writestats {

my $statname = catfile( $workdir, "index.html" );
open(STAT, ">$statname") or die "Can't create $statname.\n";
printf STAT ("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
printf STAT ("<html><head>\n");
printf STAT ("<title>optimax - statistic</title>\n");
printf STAT ("<meta http-equiv=\"content-type\" content=\"text/html; charset=ISO-8859-1\">\n");
printf STAT ("<meta http-equiv=\"refresh\" content=\"10\">\n");
printf STAT ("</head>\n");
printf STAT ("<body><div align=\"center\"><big><big>Statistic for \"%s\"</big></big><br><br></div>\n",$clientname);
printf STAT ("\n");
printf STAT ("<table cellpadding=\"5\" cellspacing=\"0\" border=\"0\" width=\"100%%\"><tbody><tr>\n");
printf STAT ("<td valign=\"top\" width=\"20%%\" bgcolor=\"#ccffff\"><big><big>General</big></big><br></td>\n");
printf STAT ("<td valign=\"middle\" width=\"25%%\" bgcolor=\"#ccffff\" rowspan=\"1\" colspan=\"1\" align=\"center\"><big><br></big></td>\n");
printf STAT ("<td valign=\"middle\" width=\"15%%\" bgcolor=\"#ccffff\" rowspan=\"1\" colspan=\"1\" align=\"center\"><big><a href=\"%s\">Randry-Template</a></big><br></td>\n",$clientfile);
printf STAT ("<td valign=\"middle\" width=\"25%%\" bgcolor=\"#ccffff\" rowspan=\"1\" colspan=\"1\" align=\"right\"><big>Used Hill<br></big></td>\n");
printf STAT ("<td valign=\"middle\" width=\"15%%\" bgcolor=\"#ccffff\" rowspan=\"1\" colspan=\"1\" align=\"center\"><big>%s<br></big></td>\n",$suitedir);
printf STAT ("</tr><tr>\n");
printf STAT ("<td valign=\"top\" width=\"20%%\" bgcolor=\"#ccffff\"><br></td>\n");
printf STAT ("<td valign=\"middle\" width=\"25%%\" bgcolor=\"#ccffff\" rowspan=\"1\" colspan=\"1\" align=\"center\"><big><br></big></td>\n");
printf STAT ("<td valign=\"middle\" width=\"15%%\" bgcolor=\"#ccffff\" rowspan=\"1\" colspan=\"1\" align=\"center\"><big><a href=\"settings.txt\">Settings</a></big><br></td>\n");
printf STAT ("<td valign=\"middle\" width=\"25%%\" bgcolor=\"#ccffff\" rowspan=\"1\" colspan=\"1\" align=\"right\"><big>Randries generated</big><br></td>\n");
printf STAT ("<td valign=\"middle\" width=\"15%%\" bgcolor=\"#ccffff\" rowspan=\"1\" colspan=\"1\" align=\"center\"><big>%u<br></big></td>\n",$warriorscreated);
printf STAT ("</tr></tbody></table><br>\n");
printf STAT ("\n");
if ( $phaseenabled[0] ) {
printf STAT ("<table cellpadding=\"5\" cellspacing=\"0\" border=\"0\" width=\"100%%\"><tbody><tr>\n");
printf STAT ("<td valign=\"top\" rowspan=\"1\" colspan=\"1\" width=\"20%%\" bgcolor=\"#ffffcc\" align=\"left\"><big><big>Phase 1&nbsp;</big></big></td>\n");
printf STAT ("<td valign=\"middle\" width=\"25%%\" align=\"right\" bgcolor=\"#ffffcc\"><big><br></big></td>\n");
printf STAT ("<td valign=\"middle\" width=\"15%%\" bgcolor=\"#ffffcc\" align=\"center\"><big><br></big></td>\n");
printf STAT ("<td valign=\"middle\" width=\"25%%\" bgcolor=\"#ffffcc\" align=\"right\"><big>overall relation in/out<br></big></td>\n");
printf STAT ("<td valign=\"middle\" width=\"15%%\" bgcolor=\"#ffffcc\" align=\"center\"><big>%6.2f/1<br></big></td>\n",$warriorscreated/$phase2reached);
printf STAT ("</tr><tr>\n");
printf STAT ("<td valign=\"middle\" bgcolor=\"#ffffcc\" width=\"20%%\" align=\"left\"><tt>(EOC - Test )</tt><br></td>\n");
printf STAT ("<td valign=\"middle\" width=\"25%%\" bgcolor=\"#ffffcc\"><br></td>\n");
printf STAT ("<td valign=\"middle\" width=\"15%%\" bgcolor=\"#ffffcc\"><br></td>\n");
printf STAT ("<td valign=\"middle\" width=\"25%%\" bgcolor=\"#ffffcc\" align=\"right\"><big>Randries passed to Phase 2</big></td>\n");
printf STAT ("<td valign=\"middle\" width=\"15%%\" bgcolor=\"#ffffcc\" align=\"center\"><big>%u</big></td>\n",$phase2reached);
printf STAT ("</tr></tbody></table>\n");
}
if ( $phaseenabled[1] ) {
printf STAT ("<table cellpadding=\"5\" cellspacing=\"0\" border=\"0\" width=\"100%%\"><tbody><tr>\n");
printf STAT ("<td valign=\"top\" rowspan=\"1\" colspan=\"1\" width=\"20%%\" bgcolor=\"#ffcc99\"><big><big>Phase 2</big></big><br></td>\n");
printf STAT ("<td valign=\"middle\" width=\"25%%\" bgcolor=\"#ffcc99\" align=\"right\"><big>Highscore</big><br></td>\n");
printf STAT ("<td valign=\"middle\" bgcolor=\"#ffcc99\" width=\"15%%\" align=\"center\"><big>%6.2f</big></td>\n",$phase2highscore{score});
printf STAT ("<td valign=\"middle\" bgcolor=\"#ffcc99\" width=\"25%%\" align=\"right\"><big>overall relation in/out<br></big></td>\n");
printf STAT ("<td valign=\"middle\" bgcolor=\"#ffcc99\" width=\"15%%\" align=\"center\"><big>%6.2f/1<br></big></td>\n",$phase2reached/$phase3reached);
printf STAT ("</tr><tr>\n");
printf STAT ("<td valign=\"top\" rowspan=\"1\" bgcolor=\"#ffcc99\"><br></td>\n");
printf STAT ("<td valign=\"middle\" width=\"25%%\" bgcolor=\"#ffcc99\" align=\"right\"><big>Target static</big><br></td>\n");
printf STAT ("<td valign=\"middle\" bgcolor=\"#ffcc99\" width=\"15%%\" align=\"center\"><big>%u</big><br></td>\n",$phase2targetstatic);
printf STAT ("<td valign=\"middle\" width=\"25%%\" bgcolor=\"#ffcc99\" align=\"right\"><big>actual (-25) relation in/out<br></big></td>\n");

if ( $phase2actualinoutrelation > 0 )
{
	printf STAT ("<td valign=\"middle\" bgcolor=\"#ffcc99\" width=\"15%%\" align=\"center\"><big>%6.2f/1<br></big></td>\n",25/$phase2actualinoutrelation);
}
else
{
	printf STAT ("<td valign=\"middle\" bgcolor=\"#ffcc99\" width=\"15%%\" align=\"center\"><big>n.a.<br></big></td>\n");
}

printf STAT ("</tr><tr>\n");
printf STAT ("<td valign=\"middle\" rowspan=\"1\" bgcolor=\"#ffcc99\" align=\"left\"><tt>(Non-starter selection)</tt><br></td>\n");
printf STAT ("<td valign=\"middle\" width=\"25%%\" bgcolor=\"#ffcc99\" align=\"right\"><big>Target dynamic</big><br></td>\n");
printf STAT ("<td valign=\"middle\" bgcolor=\"#ffcc99\" width=\"15%%\" align=\"center\"><big>%u%%/%6.2f</big><br></td>\n",$phase2targetdynamic,$phase2dynhighscore);
printf STAT ("<td valign=\"middle\" width=\"25%%\" bgcolor=\"#ffcc99\" align=\"right\"><big>Randries passed to Phase 3</big><br></td>\n");
printf STAT ("<td valign=\"middle\" width=\"15%%\" bgcolor=\"#ffcc99\" align=\"center\"><big>%u</big><br></td>\n",$phase3reached);
printf STAT ("</tr></tbody></table>\n");
}
if ( $phaseenabled[2] ) {
printf STAT ("<table cellpadding=\"5\" cellspacing=\"0\" border=\"0\" width=\"100%%\"><tbody><tr>\n");
printf STAT ("<td valign=\"top\" rowspan=\"1\" colspan=\"1\" width=\"20%%\" bgcolor=\"#ffcccc\"><big><big>Phase 3</big></big><br></td>\n");
printf STAT ("<td valign=\"middle\" width=\"25%%\" bgcolor=\"#ffcccc\" align=\"right\"><big>Topscore high<br></big></td>\n");
printf STAT ("<td valign=\"middle\" width=\"15%%\" bgcolor=\"#ffcccc\" align=\"center\"><big>%6.2f<br></big></td>\n",$phase3hill[0]->{score});
printf STAT ("<td valign=\"middle\" bgcolor=\"#ffcccc\" width=\"25%%\" align=\"right\"><big>overall relation in/out<br></big></td>\n");
printf STAT ("<td valign=\"middle\" bgcolor=\"#ffcccc\" width=\"15%%\" align=\"center\"><big>%6.2f/1<br></big></td>\n",$phase3reached/$phase4reached);
printf STAT ("</tr><tr>\n");
printf STAT ("<td valign=\"top\" rowspan=\"1\" bgcolor=\"#ffcccc\"><br></td>\n");
printf STAT ("<td valign=\"middle\" width=\"25%%\" bgcolor=\"#ffcccc\" align=\"right\"><big>Topscore low<br></big></td>\n");
printf STAT ("<td valign=\"middle\" width=\"15%%\" bgcolor=\"#ffcccc\" align=\"center\"><big>%6.2f<br></big></td>\n",$phase3hill[$#phase3hill]->{score});
printf STAT ("<td valign=\"middle\" bgcolor=\"#ffcccc\" width=\"25%%\" align=\"right\"><big>actual (-25) relation in/out<br></big></td>\n");

if ( $phase3actualinoutrelation > 0 )
{
	printf STAT ("<td valign=\"middle\" bgcolor=\"#ffcccc\" width=\"15%%\" align=\"center\"><big>%6.2f/1<br></big></td>\n",25/$phase3actualinoutrelation);
}
else
{
	printf STAT ("<td valign=\"middle\" bgcolor=\"#ffcccc\" width=\"15%%\" align=\"center\"><big>n.a.<br></big></td>\n");
}

printf STAT ("</tr><tr>\n");
printf STAT ("<td valign=\"top\" rowspan=\"1\" bgcolor=\"#ffcccc\"><br></td>\n");
printf STAT ("<td valign=\"middle\" width=\"25%%\" bgcolor=\"#ffcccc\" align=\"right\"><big>Last <a href=\"phase3/topscore.html\">Topscore</a> at<br></big></td>\n");
printf STAT ("<td valign=\"middle\" width=\"15%%\" bgcolor=\"#ffcccc\" align=\"center\"><big>%s<br></big></td>\n",$phase3topscoretime);
printf STAT ("<td valign=\"middle\" bgcolor=\"#ffcccc\" width=\"25%%\" align=\"right\"><big>overall average score<br></big></td>\n");
printf STAT ("<td valign=\"middle\" bgcolor=\"#ffcccc\" width=\"15%%\" align=\"center\"><big>%6.2f<br></big></td>\n",$phase3averagescore);
printf STAT ("</tr><tr>\n");
printf STAT ("<td valign=\"top\" rowspan=\"1\" bgcolor=\"#ffcccc\"><br></td>\n");
printf STAT ("<td valign=\"middle\" width=\"25%%\" bgcolor=\"#ffcccc\" align=\"right\"><big>Target static<br></big></td>\n");
printf STAT ("<td valign=\"middle\" width=\"15%%\" bgcolor=\"#ffcccc\" align=\"center\"><big>%u<br></big></td>\n",$phase3targetstatic);
printf STAT ("<td valign=\"middle\" bgcolor=\"#ffcccc\" width=\"25%%\" align=\"right\"><big>actual (-25) average score<br></big></td>\n");
printf STAT ("<td valign=\"middle\" bgcolor=\"#ffcccc\" width=\"15%%\" align=\"center\"><big>%6.2f<br></big></td>\n",$phase3actualaveragescore);
printf STAT ("</tr><tr>\n");
printf STAT ("<td valign=\"middle\" rowspan=\"1\" bgcolor=\"#ffcccc\" align=\"left\"><tt>(Preselection)</tt><br></td>\n");
printf STAT ("<td valign=\"middle\" width=\"25%%\" bgcolor=\"#ffcccc\" align=\"right\"><big>Target dynamic<br></big></td>\n");
printf STAT ("<td valign=\"middle\" width=\"15%%\" bgcolor=\"#ffcccc\" align=\"center\"><big>%u%%/%6.2f<br></big></td>\n",$phase3targetdynamic,$phase3dynhighscore);
printf STAT ("<td valign=\"middle\" bgcolor=\"#ffcccc\" width=\"25%%\" align=\"right\"><big>Randries passed to Phase 4</big><br></td>\n");
printf STAT ("<td valign=\"middle\" bgcolor=\"#ffcccc\" width=\"15%%\" align=\"center\"><big>%u</big><br></td>\n",$phase4reached);
printf STAT ("</tr></tbody></table>\n");
}
if ( $phaseenabled[3] ) {
printf STAT ("<table cellpadding=\"5\" cellspacing=\"0\" border=\"0\" width=\"100%%\"><tbody><tr>\n");
printf STAT ("<td valign=\"top\" rowspan=\"1\" colspan=\"1\" width=\"20%%\" bgcolor=\"#ffccff\"><big><big>Phase 4</big></big><br></td>\n");
printf STAT ("<td valign=\"middle\" width=\"25%%\" bgcolor=\"#ffccff\" align=\"right\"><big>Topscore high<br></big></td>\n");
printf STAT ("<td valign=\"middle\" width=\"15%%\" bgcolor=\"#ffccff\" align=\"center\"><big>%6.2f<br></big></td>\n",$phase4hill[0]->{score});
printf STAT ("<td valign=\"middle\" bgcolor=\"#ffccff\" width=\"25%%\" align=\"right\"><big>overall average score</big><br></td>\n");
printf STAT ("<td valign=\"middle\" bgcolor=\"#ffccff\" width=\"15%%\" align=\"center\"><big>%6.2f<br></big></td>\n",$phase4averagescore);
printf STAT ("</tr><tr>\n");
printf STAT ("<td valign=\"top\" rowspan=\"1\" bgcolor=\"#ffccff\"><br></td>\n");
printf STAT ("<td valign=\"middle\" width=\"25%%\" bgcolor=\"#ffccff\" align=\"right\"><big>Topscore low<br></big></td>\n");
printf STAT ("<td valign=\"middle\" width=\"15%%\" bgcolor=\"#ffccff\" align=\"center\"><big>%6.2f<br></big></td>\n",$phase4hill[$#phase4hill]->{score});
printf STAT ("<td valign=\"middle\" bgcolor=\"#ffccff\" width=\"25%%\" align=\"right\"><big>actual (-25) average score</big><br></td>\n");
printf STAT ("<td valign=\"middle\" bgcolor=\"#ffccff\" width=\"15%%\" align=\"center\"><big>%6.2f<br></big></td>\n",$phase4actualaveragescore);
printf STAT ("</tr><tr>\n");
printf STAT ("<td valign=\"middle\" bgcolor=\"#ffccff\" align=\"left\"><tt>(Grand Prix)</tt><br></td>\n");
printf STAT ("<td valign=\"middle\" width=\"25%%\" bgcolor=\"#ffccff\" align=\"right\"><big>Last <a href=\"phase4/topscore.html\">Topscore</a> at<br></big></td>\n");
printf STAT ("<td valign=\"middle\" width=\"15%%\" bgcolor=\"#ffccff\" align=\"center\"><big>%s<br></big></td>\n",$phase4topscoretime);
printf STAT ("<td valign=\"middle\" bgcolor=\"#ffccff\" width=\"25%%\" align=\"right\"><big>Score relation 4->3(sd)<br></big></td>\n");
printf STAT ("<td valign=\"middle\" bgcolor=\"#ffccff\" width=\"15%%\" align=\"center\"><big>%5.2f%%/%5.2f<br></big></td>\n",$diff34overall,$diff34overallsd);
printf STAT ("</tr></tbody></table><br>\n");
}
printf STAT ("<br>\n");
printf STAT ("<table cellpadding=\"2\" cellspacing=\"0\" border=\"0\" width=\"100%%\"><tbody><tr>\n");
printf STAT ("<td valign=\"top\" width=\"50%%\" align=\"right\" bgcolor=\"#3366ff\"><b><font color=\"#ffffff\"><big><big>Runtime <br></big></big></font></b></td>\n");
printf STAT ("<td valign=\"top\" width=\"50%%\" bgcolor=\"#3366ff\" ><b><font color=\"#ffffff\"><big><big>%s<br></big></big></font></b></td>\n",timer());
printf STAT ("</tr></tbody></table></body></html>\n");

close(STAT);

}

sub templatewarrior
{
my ( $warrior, $templatefile ) = @_;

open(WARRIOR, ">>$warrior") or die "Can't open Warrior $warrior\n";
my @optistrings;
if (!$templatefile)
{
@optistrings = <<"OPTISTRINGS";
;optimax 1234
;optimax work [directory]
;optimax suite [directory]
;optimax rounds 1 100 200 200
;optimax random 42
;optimax alarm [high|top]score

;optimax phase2 [warrior.red]
;optimax phase2 0
;optimax phase2 0%

;optimax phase3 0
;optimax phase3 0%
;optimax phase3 top10
;optimax phase3 [warrior.lst]
;optimax phase3 [classes]

;optimax phase4 100%
;optimax phase4 top10
OPTISTRINGS
}
else
{
	open(TEMPLATE, catfile('templates', $templatefile) )
		or die "Can't open Template templates/$templatefile]\n";
	while ( my $line = <TEMPLATE> )
	{
		push @optistrings, $line if ( $line =~m/^;optimax/ );
	}
	close(TEMPLATE);
}
print WARRIOR @optistrings;
close(WARRIOR);
exit;
}

sub stripwarrior
{
my $wname = shift;

open(WARRIOR, "$wname") or die "Can't open Warrior $wname at ".(caller(0))[3]."\n";
my @lines = <WARRIOR>;
close(WARRIOR);
open(WARRIOR, ">$wname") or die "Can't rewrite Warrior $wname\n";
foreach ( @lines )
{
	print WARRIOR $_ if ( $_ !~ m/;optimax/ );
}
close(WARRIOR);
exit;
}

sub createphase3htmldna()
{
	# Daten aus der Hill-Struktur extrahieren.
	# Operatoren beschriftung.

    my @parts = $phase3hill[0]->{dna} =~ m/[^\|]+/g ;
    my @describe;
    for ($p=0;$p<$#parts;$p+=2) { push @describe, $parts[$p]; }

    my $dnahtml = catfile( $phase3dir, 'dna.html' );
	open(DNAHTML, ">$dnahtml") or die "Can't create dnahtml-file.\n";

    sub writednacolumn {
     print DNAHTML "<td valign=\"top\" align=\"right\" bgcolor=\"#$_[0]\"><font color=\"#$_[1]\">$_[2]<br></font></td>\n";
    }

	 # Jetzt HTML-Header schreiben.

     print DNAHTML <<EOH;
<html><head>  <title>Phase 3 DNA</title>
  <meta http-equiv="content-type" content="text/html; charset=ISO-8859-1">
</head>
  <body>
<table cellpadding="2" cellspacing="2" frame="box" rules="columns" border="1">
   <tbody>
EOH

	print DNAHTML "<tr>\n";
    foreach (@describe) { writednacolumn( '000000','ffffff',$_ ) }
    print DNAHTML "</tr>\n";

    my $rank = 0;
    foreach $entry ( @phase3hill )
	{
		print DNAHTML "<tr>\n";
		my @parts = $entry->{dna} =~ m/[^\|]+/g ;
    	my @data;
    	for ($p=1;$p<=$#parts;$p+=2) { push @data, $parts[$p]; }
	    foreach ( @data )
   		{
            writednacolumn( int($rank/2) == $rank/2  ? 'ffffff' : 'cccccc' ,'000000', $_ );
		}
	    print DNAHTML "</tr>\n";
        $rank++;
    }
	print DNAHTML <<EOF;
  </tbody></table><br> <br></body></html>
EOF

    close(DNAHTML);
}

sub createphase4htmldna()
{
	# Daten aus der Hill-Struktur extrahieren.
	# Operatoren beschriftung.

    my @parts = $phase4hill[0]->{dna} =~ m/[^\|]+/g ;
    my @describe;
    for ($p=0;$p<$#parts;$p+=2) { push @describe, $parts[$p]; }

    my $dnahtml = catfile( $phase4dir, 'dna.html' );
	open(DNAHTML, ">$dnahtml") or die "Can't create dnahtml-file.\n";

    sub write4dnacolumn {
     print DNAHTML "<td valign=\"top\" align=\"right\" bgcolor=\"#$_[0]\"><font color=\"#$_[1]\">$_[2]<br></font></td>\n";
    }

	 # Jetzt HTML-Header schreiben.

     print DNAHTML <<EOH;
<html><head>  <title>Phase 4 DNA</title>
  <meta http-equiv="content-type" content="text/html; charset=ISO-8859-1">
</head>
  <body>
<table cellpadding="2" cellspacing="2" frame="box" rules="columns" border="1">
   <tbody>
EOH

	print DNAHTML "<tr>\n";
    foreach (@describe) { write4dnacolumn( '000000','ffffff',$_ ) }
    print DNAHTML "</tr>\n";

    my $rank = 0;
    foreach $entry ( @phase4hill )
	{
		print DNAHTML "<tr>\n";
		my @parts = $entry->{dna} =~ m/[^\|]+/g ;
    	my @data;
    	for ($p=1;$p<=$#parts;$p+=2) { push @data, $parts[$p]; }
	    foreach ( @data )
   		{
            writednacolumn( int($rank/2) == $rank/2  ? 'ffffff' : 'cccccc' ,'000000', $_ );
		}
	    print DNAHTML "</tr>\n";
        $rank++;
    }
	print DNAHTML <<EOF;
  </tbody></table><br> <br></body></html>
EOF

    close(DNAHTML);
}

sub register_run
{
	my $run = $_[0];

 	# First, save workdir for remote control

    open ( WD, ">run" );
    print WD "$run";
    close(WD);

    # Register workdir for HTML'ing

    my $runstr = sprintf ("%s\n",$run);

    my @runs = ();

    push @runs, $runstr;
    
    
    if ( -e 'runs' )
    {
    	open( RW, "runs" );
		while ( my $line =  <RW> )
    	{
    		push @runs, $line;
    	}
    	close( RW );
	}
    my %seen = ();
	my @uniq = grep { !$seen{$_} ++ } @runs;


    open( RW, ">runs" );
	print RW @uniq;
    close( RW );
    
    # Now create run directory

	open( RD, ">".catfile('work','index.html')) || die "Can't create work/index.html\n";
    
    print RD <<"IHEAD";
<html>
<head>
<title>optiMAX - run directory</title>
<meta http-equiv="content-type"
content="text/html; charset=ISO-8859-1">
</head><body>
<big><big><b>optiMAX - run directory</b><br></big></big><br>

IHEAD

    foreach my $dir ( @uniq )
    {
    	my ( undef, undef ,$rdir ) = File::Spec -> splitpath( $dir );

        printf RD ("<big><a href=\"%s/index.html\">%s</a></big><br>\n",$rdir,$rdir);
    }

	print RD "</body></html>\n";

	close(RD);
}

sub import_suite_config
{
	my $suitedir = shift;

	# Now read the config from the suite
	my $configfilename = catfile($suitedir,"config");
	open(CONFIG, "<$configfilename") or die "Can't read configfile: $configfilename : $!\n";
	$suiteconfig = <CONFIG>;
	chomp $suiteconfig;
	close(CONFIG);
	my $classesfilename = catfile($suitedir,"classes");
	open(CLASSES, "<$classesfilename") or die "Can't read classesfile: $!\n";
	while ( $line = <CLASSES> )
	{
		chomp $line;
		my @parts = split(/\t/, $line);
		$classes{$parts[0]}{name} = $parts[1];
		$classes{$parts[0]}{color} = $parts[2];
	}
	close(CLASSES);

    my @parts = split(/ /, $suiteconfig);
	
    for(my $pi=0;$pi<=$#parts;$pi++)
	{
		$config{fsh}{cycles} = $parts[$pi+1] if ( $parts[$pi] eq '-c' );
		$config{fsh}{coresize} = $parts[$pi+1] if ( $parts[$pi] eq '-s' );
		$config{fsh}{processes} = $parts[$pi+1] if ( $parts[$pi] eq '-p' );
		$config{fsh}{length} = $parts[$pi+1] if ( $parts[$pi] eq '-l' );
		$config{fsh}{distance} = $parts[$pi+1] if ( $parts[$pi] eq '-d' );
    }

	$config{phase2}{fvalue} = $config{fsh}{coresize}/4;
	$config{phase3}{fvalue} = $config{phase2}{fvalue}*2;
	$config{phase4}{fvalue} = $config{phase2}{fvalue}*3;

	return;
}
