/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core;

import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.epic.perleditor.PerlEditorPlugin;

public class Perspective
implements IPerspectiveFactory {
    public void createInitialLayout(IPageLayout layout) {
        this.defineActions(layout);
        this.defineLayout(layout);
    }

    public void defineActions(IPageLayout layout) {
        layout.addNewWizardShortcut("org.epic.newproject.wizard");
        layout.addNewWizardShortcut("org.epic.newfile.wizard");
        layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.folder");
        layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.file");
        layout.addShowViewShortcut("org.eclipse.ui.views.ResourceNavigator");
        layout.addShowViewShortcut("org.eclipse.ui.views.BookmarkView");
        layout.addShowViewShortcut("org.eclipse.ui.views.ContentOutline");
        layout.addShowViewShortcut("org.eclipse.ui.views.PropertySheet");
        layout.addShowViewShortcut("org.eclipse.ui.views.TaskList");
        layout.addShowViewShortcut("org.epic.perleditor.views.ExplainErrorsView");
        layout.addShowViewShortcut("org.epic.perleditor.views.PerlDocView");
        layout.addShowViewShortcut("org.epic.core.views.browser.BrowserView");
        layout.addPerspectiveShortcut("org.eclipse.ui.resourcePerspective");
        layout.addPerspectiveShortcut("org.eclipse.debug.ui.DebugPerspective");
        layout.addActionSet("org.eclipse.ui.NavigateActionSet");
        layout.addActionSet(IDebugUIConstants.LAUNCH_ACTION_SET);
    }

    public void defineLayout(IPageLayout layout) {
        String editorArea = layout.getEditorArea();
        IFolderLayout topLeft = layout.createFolder("topLeft", 1, 0.26f, editorArea);
        topLeft.addView("org.eclipse.ui.views.ResourceNavigator");
        topLeft.addPlaceholder("org.eclipse.ui.views.BookmarkView");
        IFolderLayout bottomLeft = layout.createFolder("bottomLeft", 4, 0.5f, "topLeft");
        bottomLeft.addView("org.eclipse.ui.views.ContentOutline");
        layout.addView("org.eclipse.ui.views.TaskList", 4, 0.66f, editorArea);
    }

    public static void switchPerspective(final String perspectiveId) {
        final IWorkbench workBench = PerlEditorPlugin.getDefault().getWorkbench();
        Display display = workBench.getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = workBench.getActiveWorkbenchWindow();
                if (window == null) {
                    window = workBench.getWorkbenchWindows()[0];
                }
                IPerspectiveRegistry reg = WorkbenchPlugin.getDefault().getPerspectiveRegistry();
                PerspectiveDescriptor rtPerspectiveDesc = (PerspectiveDescriptor)reg.findPerspectiveWithId(perspectiveId);
                if (window != null && rtPerspectiveDesc != null) {
                    IWorkbenchPage page = window.getActivePage();
                    page.setPerspective((IPerspectiveDescriptor)rtPerspectiveDesc);
                }
            }
        });
    }
}

