/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.epic.core.model.IMultilineElement;
import org.epic.core.model.ModuleUse;
import org.epic.core.model.Subroutine;
import org.epic.core.parser.CurlyToken;
import org.epic.core.parser.PerlToken;

public class Package
implements IMultilineElement {
    private final int index;
    private final int blockLevel;
    private final PerlToken packageKeyword;
    private final PerlToken name;
    private final List subs;
    private final List uses;
    private PerlToken lastToken;

    public Package() {
        this.index = 0;
        this.blockLevel = 0;
        this.packageKeyword = null;
        this.name = null;
        this.subs = new ArrayList();
        this.uses = new ArrayList();
    }

    public Package(int index, int blockLevel, PerlToken packageKeyword, PerlToken name) {
        this.index = index;
        this.blockLevel = blockLevel;
        this.packageKeyword = packageKeyword;
        this.name = name;
        this.subs = new ArrayList();
        this.uses = new ArrayList();
    }

    public Subroutine addSub(PerlToken subKeyword, PerlToken name, CurlyToken openCurly) {
        Subroutine ret = new Subroutine(this, this.subs.size(), subKeyword, name, openCurly);
        this.subs.add(ret);
        return ret;
    }

    public ModuleUse addUse(PerlToken keyword, PerlToken name) throws BadLocationException {
        ModuleUse ret = new ModuleUse(this, this.uses.size(), keyword, name);
        this.uses.add(ret);
        return ret;
    }

    public boolean equals(Object obj) {
        return obj instanceof Package && this.index == ((Package)obj).index;
    }

    public int getBlockLevel() {
        return this.blockLevel;
    }

    public int getEndLine() {
        return this.lastToken.getLine() - 1;
    }

    public int getStartLine() {
        return this.packageKeyword != null ? this.packageKeyword.getLine() - 1 : 0;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLength() {
        return this.name != null ? this.name.getLength() : "main".length();
    }

    public String getName() {
        return this.name != null ? this.name.getText() : "main";
    }

    public int getOffset() {
        return this.name != null ? this.name.getOffset() : -1;
    }

    public List getSubs() {
        return Collections.unmodifiableList(this.subs);
    }

    public List getUses() {
        return Collections.unmodifiableList(this.uses);
    }

    public int hashCode() {
        return this.index;
    }

    public void setLastToken(PerlToken lastToken) {
        this.lastToken = lastToken;
    }
}

