/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.epic.perleditor.actions.OpenDeclarationAction;
import org.epic.perleditor.editors.PartitionTypes;
import org.epic.perleditor.editors.PerlEditor;

public class PerlSubHyperlinkDetector
implements IHyperlinkDetector {
    private final PerlEditor editor;

    public PerlSubHyperlinkDetector(PerlEditor editor) {
        this.editor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        return this.detectHyperlinks(document, region.getOffset());
    }

    private IHyperlink[] detectHyperlinks(IDocument doc, int offset) {
        ITypedRegion partition;
        try {
            partition = PartitionTypes.getPerlPartition(doc, offset);
            if (!"__dftl_partition_content_type".equals(partition.getType())) {
                return null;
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        try {
            return new IHyperlink[]{new PerlSubHyperlink(this.editor, doc.get(partition.getOffset(), partition.getLength()), (IRegion)partition)};
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private static class PerlSubHyperlink
    implements IHyperlink {
        private final PerlEditor editor;
        private final String subName;
        private final IRegion subNameRegion;

        public PerlSubHyperlink(PerlEditor editor, String subName, IRegion subNameRegion) {
            this.editor = editor;
            this.subName = subName;
            this.subNameRegion = subNameRegion;
        }

        public IRegion getHyperlinkRegion() {
            return this.subNameRegion;
        }

        public String getTypeLabel() {
            return null;
        }

        public String getHyperlinkText() {
            return null;
        }

        public void open() {
            OpenDeclarationAction action = (OpenDeclarationAction)this.editor.getAction("org.epic.perleditor.actions.OpenDeclarationAction");
            if (action != null) {
                action.run((ITextSelection)new TextSelection(this.subNameRegion.getOffset(), this.subNameRegion.getLength()));
            }
        }
    }
}

