/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors.util;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import org.epic.core.ResourceMessages;

public class PerlValidatorErrors {
    private final Set errorMessages;
    private final ErrorMessage unknownErrorMessage = new ErrorMessage(ResourceMessages.getString("PerlValidatorErrors.unknownErrorMessage"), ResourceMessages.getString("PerlValidatorErrors.unknownErrorMessage.descr"), true);

    public PerlValidatorErrors() {
        this.errorMessages = new HashSet();
        ResourceBundle errorBundle = ResourceBundle.getBundle("org.epic.perleditor.editors.errorsAndWarnings");
        Pattern re1 = Pattern.compile("[\\$\\(\\)\\[\\]\\{\\}\\?\\|\\*\\+\\\\]");
        Pattern re2 = Pattern.compile("%([sdcl][x]{0,1})");
        Pattern re3 = Pattern.compile("%\\.[0-9]s");
        Enumeration<String> e = errorBundle.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String value = errorBundle.getString(key);
            int tabIndex = value.indexOf("\t");
            String msg = value.substring(0, tabIndex);
            String descr = value.substring(tabIndex + 1);
            msg = re1.matcher(msg).replaceAll(".");
            msg = re2.matcher(msg).replaceAll(".*?");
            msg = re3.matcher(msg).replaceAll(".*?");
            this.errorMessages.add(new ErrorMessage(msg, descr, false));
        }
    }

    public ErrorMessage getErrorMessage(String line) {
        Iterator i = this.errorMessages.iterator();
        while (i.hasNext()) {
            ErrorMessage errorMessage = (ErrorMessage)i.next();
            if (!errorMessage.matches(line)) continue;
            return errorMessage;
        }
        return this.unknownErrorMessage;
    }

    public static class ErrorMessage {
        private final Pattern pattern;
        private final String descr;
        private final boolean warning;
        private final boolean unknown;

        private ErrorMessage(String regex, String descr, boolean unknown) {
            this.descr = descr;
            this.unknown = unknown;
            this.pattern = Pattern.compile(regex);
            this.warning = descr.startsWith("(W") || descr.startsWith("(D") || descr.startsWith("(S");
        }

        public String getExplanation() {
            return this.descr;
        }

        public Integer getSeverity() {
            return new Integer(this.warning ? 1 : 2);
        }

        public boolean isUnknown() {
            return this.unknown;
        }

        public boolean isWarning() {
            return this.warning;
        }

        public String toString() {
            return this.descr;
        }

        private boolean matches(String error) {
            return this.pattern.matcher(error).find();
        }
    }
}

