/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.cgi.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sunlabs.brazil.server.Request;
import sunlabs.brazil.server.Server;

class CGIConfig {
    private final Server server;
    private final String propsPrefix;
    private final boolean debugMode;
    private String debugInc;
    private List runInc;
    private final String hostname;
    private final int portIn;
    private final int portOut;
    private final int portErr;
    private final String protocol;
    private final String perlExecutable;
    private final String perlParams;
    private final int serverPort;

    public CGIConfig(Server server, String propsPrefix) {
        this.server = server;
        this.propsPrefix = propsPrefix;
        this.serverPort = server.listen.getLocalPort();
        this.hostname = server.hostName;
        this.protocol = server.protocol;
        this.portIn = this.getIntProperty("InPort");
        this.portOut = this.getIntProperty("OutPort");
        this.portErr = this.getIntProperty("ErrorPort");
        this.debugMode = this.getProperty("Debug").equalsIgnoreCase("true");
        this.debugInc = this.getProperty("DebugInclude");
        this.runInc = this.getListProperty("RunInclude");
        this.perlParams = this.getProperty("PerlParams");
        this.perlExecutable = this.getProperty("executable");
    }

    public String getDebugInclude() {
        return this.debugInc;
    }

    public boolean getDebugMode() {
        return this.debugMode;
    }

    public int getErrorPort() {
        return this.portErr;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getDiagPort() {
        return this.portIn;
    }

    public int getOutPort() {
        return this.portOut;
    }

    public String getPerlExecutable() {
        return this.perlExecutable;
    }

    public String getPerlParams() {
        return this.perlParams;
    }

    public String getPropsPrefix() {
        return this.propsPrefix;
    }

    public Map getProperties(String prefix) {
        HashMap<String, String> ret = new HashMap<String, String>();
        int len = (String.valueOf(this.propsPrefix) + prefix).length();
        Iterator<Object> i = this.server.props.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.startsWith(String.valueOf(this.propsPrefix) + prefix)) continue;
            ret.put(key.substring(len), this.server.props.getProperty(key));
        }
        return ret;
    }

    public String getRequestProperty(Request request, String name, String defaultValue) {
        return request.props.getProperty(String.valueOf(this.propsPrefix) + name, defaultValue);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public List getRunInclude() {
        return Collections.unmodifiableList(this.runInc);
    }

    public int getServerPort() {
        return this.serverPort;
    }

    private int getIntProperty(String name) {
        return Integer.parseInt(this.getProperty(name));
    }

    private List getListProperty(String name) {
        String value;
        ArrayList<String> values = new ArrayList<String>();
        int i = 0;
        while ((value = this.getProperty(String.valueOf(name) + "[" + i + "]")) != null) {
            values.add(value);
            ++i;
        }
        return values;
    }

    private String getProperty(String name) {
        return this.server.props.getProperty(String.valueOf(this.propsPrefix) + name);
    }
}

