/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.db.DebuggerInterface;
import org.epic.debug.db.DumpedEntity;
import org.epic.debug.db.DumpedEntityReader;
import org.epic.debug.db.HelperScript;
import org.epic.debug.db.LexicalVariable;
import org.epic.debug.db.PackageVariable;
import org.epic.debug.db.PerlDebugThread;
import org.epic.debug.db.PerlVariable;
import org.epic.debug.ui.action.HighlightVarUpdatesActionDelegate;
import org.epic.debug.ui.action.ShowGlobalVariableActionDelegate;
import org.epic.debug.ui.action.ShowLocalVariableActionDelegate;
import org.epic.debug.ui.action.ShowPerlInternalVariableActionDelegate;

public class StackFrame
extends DebugElement
implements IStackFrame {
    private static final IRegisterGroup[] NO_REGISTER_GROUPS = new IRegisterGroup[0];
    private static final String DB_DUMP_LOCAL_VARS;
    private static final String DB_DUMP_GLOBAL_VARS;
    private static final Set PERL_INTERNAL_VARS;
    private PerlVariable[] vars;
    private final PerlDebugThread thread;
    private final IPath path;
    private final IPath localPath;
    private final int lineNumber;
    private final DebuggerInterface db;
    private StackFrame previous;
    private final int frameIndex;
    private final HashMap rememberedVariables;

    static {
        PERL_INTERNAL_VARS = StackFrame.initInternalVars();
        DB_DUMP_LOCAL_VARS = HelperScript.load("dump_local_vars.pl");
        DB_DUMP_GLOBAL_VARS = HelperScript.load("dump_global_vars.pl");
    }

    public StackFrame(PerlDebugThread thread, IPath path, int lineNumber, IPath localPath, DebuggerInterface db, StackFrame previous, int frameIndex) throws DebugException {
        super(thread.getDebugTarget());
        if (previous != null) {
            previous.previous = null;
        }
        this.thread = thread;
        this.path = path;
        this.localPath = localPath;
        this.lineNumber = lineNumber;
        this.db = db;
        this.previous = previous;
        this.frameIndex = frameIndex;
        this.rememberedVariables = new HashMap();
        if (HighlightVarUpdatesActionDelegate.getPreferenceValue()) {
            this.getVariables();
        }
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public boolean canStepInto() {
        return this.thread.canStepInto();
    }

    public boolean canStepOver() {
        return this.thread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.thread.canStepReturn();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean canTerminate() {
        return this.thread.canTerminate();
    }

    public void discardCachedVars() {
        this.vars = null;
        this.rememberedVariables.clear();
        this.fireChangeEvent(512);
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getFrameIndex() {
        return this.frameIndex;
    }

    public int getLineNumber() throws DebugException {
        return this.lineNumber;
    }

    public IPath getLocalPath() {
        return this.localPath;
    }

    public String getModelIdentifier() {
        return this.thread.getModelIdentifier();
    }

    public String getName() throws DebugException {
        return String.valueOf(this.path.lastSegment()) + "[line: " + Integer.toString(this.lineNumber) + "]";
    }

    public IPath getPath() {
        return this.path;
    }

    public PerlDebugThread getPerlThread() {
        return this.thread;
    }

    public PerlVariable getPreviousVariable(PerlVariable var) {
        if (this.previous == null) {
            return null;
        }
        return this.previous.getRememberedVariable(var.getDumpedEntity().getAddress());
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return NO_REGISTER_GROUPS;
    }

    public IThread getThread() {
        return this.thread;
    }

    public IVariable[] getVariables() throws DebugException {
        if (!this.thread.isSuspended()) {
            return new IVariable[0];
        }
        if (this.vars == null) {
            try {
                ArrayList vars = new ArrayList();
                if (ShowGlobalVariableActionDelegate.getPreferenceValue()) {
                    this.dumpGlobalVars(vars);
                }
                if (ShowLocalVariableActionDelegate.getPreferenceValue() && this.db.hasPadWalker()) {
                    this.dumpLocalVars(vars);
                }
                this.vars = vars.toArray(new PerlVariable[vars.size()]);
                if (HighlightVarUpdatesActionDelegate.getPreferenceValue() && this.rememberedVariables.isEmpty()) {
                    this.rememberVariables();
                }
                this.fireChangeEvent(512);
            }
            catch (IOException e) {
                throw new DebugException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "An error occurred while retrieving variables from the debugger process", (Throwable)e));
            }
        }
        return this.vars;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean hasVariables() throws DebugException {
        return true;
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public void resume() throws DebugException {
        this.thread.resume();
    }

    public void stepInto() throws DebugException {
        this.thread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.thread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.thread.stepReturn();
    }

    public void suspend() throws DebugException {
        this.thread.suspend();
    }

    public void terminate() throws DebugException {
        this.thread.terminate();
    }

    private void dumpGlobalVars(List vars) throws IOException, DebugException {
        String globalVarsString = this.db.eval(DB_DUMP_GLOBAL_VARS);
        if (globalVarsString == null) {
            return;
        }
        try {
            DumpedEntityReader r = new DumpedEntityReader(globalVarsString);
            boolean showInternal = ShowPerlInternalVariableActionDelegate.getPreferenceValue();
            while (r.hasMoreEntities()) {
                DumpedEntity ent = r.nextEntity();
                if (!showInternal && PERL_INTERNAL_VARS.contains(ent.getName())) continue;
                vars.add(new PackageVariable(this.db, this, ent));
            }
        }
        catch (Exception e) {
            PerlDebugPlugin.log(e);
            throw new DebugException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "An error occurred while dumping global variables; contents of the Variables view may become invalid", (Throwable)e));
        }
    }

    private void dumpLocalVars(List vars) throws IOException, DebugException {
        String code = HelperScript.replace(DB_DUMP_LOCAL_VARS, "#SET_OFFSET#", "my $offset = " + this.frameIndex + ";");
        String localVarsString = this.db.eval(code);
        if (localVarsString == null) {
            return;
        }
        try {
            DumpedEntityReader r = new DumpedEntityReader(localVarsString);
            while (r.hasMoreEntities()) {
                vars.add(new LexicalVariable(this.db, this, r.nextEntity()));
            }
        }
        catch (Exception e) {
            throw new DebugException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "An error occurred while dumping local variables; contents of the Variables view may become invalid", (Throwable)e));
        }
    }

    private PerlVariable getRememberedVariable(String addr) {
        return (PerlVariable)((Object)this.rememberedVariables.get(addr));
    }

    private static Set initInternalVars() {
        ResourceBundle rb = ResourceBundle.getBundle("org.epic.debug.perlIntVars");
        Enumeration<String> e = rb.getKeys();
        HashSet<String> vars = new HashSet<String>();
        while (e.hasMoreElements()) {
            vars.add(e.nextElement());
        }
        return vars;
    }

    private void rememberVariables() throws DebugException {
        LinkedList<IVariable[]> queue = new LinkedList<IVariable[]>();
        queue.add(this.vars);
        while (!queue.isEmpty()) {
            IVariable[] vars = (IVariable[])queue.removeFirst();
            int i = 0;
            while (i < vars.length) {
                PerlVariable var = (PerlVariable)vars[i];
                String addr = var.getDumpedEntity().getAddress();
                if (this.rememberedVariables.put(addr, var) == null && var.getValue().hasVariables()) {
                    queue.add(var.getValue().getVariables());
                }
                ++i;
            }
        }
    }
}

