/*
 * Decompiled with CFR 0.152.
 */
package org.epic.regexp.views;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.epic.regexp.views.RegExpImages;

public class RegExpView
extends ViewPart {
    private Composite panel;
    private List colorTable = new ArrayList();
    private Action validateAction;
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private Action stopDebugAction;
    private Action forwardDebugAction;
    private Action backDebugAction;
    private StyledText regExpText;
    private StyledText matchText;
    private Label resultImageLabel;
    private Button ignoreCaseCheckBox;
    private Button multilineCheckBox;
    private Object activeInput = null;
    private DebugInfo debugInfo = null;
    private int debugPosition = 0;
    private static final String SHORTCUTS_FILE = "shortcuts";

    public void createPartControl(Composite parent) {
        this.makeActions();
        this.contributeToActionBars();
        this.panel = new Composite(parent, 0);
        this.buildColorTable();
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        this.panel.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.panel.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalSpan = 1;
        Label regExpLabel = new Label(this.panel, 0);
        regExpLabel.setText("RegExp:");
        regExpLabel.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalSpan = 1;
        this.resultImageLabel = new Label(this.panel, 0);
        this.setResultLabelImage(RegExpImages.RESULT_GRAY);
        this.resultImageLabel.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 1;
        this.ignoreCaseCheckBox = new Button(this.panel, 32);
        this.ignoreCaseCheckBox.setText("ignore case");
        this.ignoreCaseCheckBox.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 1;
        this.multilineCheckBox = new Button(this.panel, 32);
        this.multilineCheckBox.setText("multiline");
        this.multilineCheckBox.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalSpan = 4;
        this.regExpText = new StyledText(this.panel, 2048);
        this.regExpText.setLayoutData((Object)data);
        this.regExpText.addFocusListener((FocusListener)new focusListener());
        data = new GridData(768);
        data.horizontalSpan = 4;
        Label matchTextLabel = new Label(this.panel, 0);
        matchTextLabel.setText("Match text:");
        matchTextLabel.setLayoutData((Object)data);
        data = new GridData(1808);
        data.horizontalSpan = 4;
        this.matchText = new StyledText(this.panel, 2816);
        this.matchText.setLayoutData((Object)data);
        this.matchText.addFocusListener((FocusListener)new focusListener());
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        this.hookContextMenu();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RegExpView.this.fillContextMenu(manager);
            }
        });
        Menu menuRegExp = menuMgr.createContextMenu((Control)this.regExpText);
        this.regExpText.setMenu(menuRegExp);
        Menu menuMatch = menuMgr.createContextMenu((Control)this.matchText);
        this.matchText.setMenu(menuMatch);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.cutAction);
        manager.add((IAction)this.copyAction);
        manager.add((IAction)this.pasteAction);
        if (this.regExpText.isFocusControl()) {
            this.createShortcutsMenu(manager);
        }
        manager.add((IContributionItem)new Separator("Additions"));
    }

    private void buildColorTable() {
        Display display = this.panel.getDisplay();
        this.colorTable.add(display.getSystemColor(9));
        this.colorTable.add(display.getSystemColor(2));
        this.colorTable.add(display.getSystemColor(3));
        this.colorTable.add(display.getSystemColor(16));
        this.colorTable.add(display.getSystemColor(6));
        this.colorTable.add(new Color((Device)display, 255, 127, 0));
        this.colorTable.add(display.getSystemColor(12));
        this.colorTable.add(new Color((Device)display, 201, 141, 141));
        this.colorTable.add(new Color((Device)display, 214, 179, 74));
        this.colorTable.add(new Color((Device)display, 204, 74, 214));
    }

    private void createShortcutsMenu(IMenuManager mgr) {
        MenuManager submenu = new MenuManager("Shortcuts");
        mgr.add((IContributionItem)submenu);
        try {
            String line;
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(SHORTCUTS_FILE);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                String token;
                StringTokenizer st = new StringTokenizer(line, "\t");
                if (st.countTokens() == 2) {
                    final String shortc = st.nextToken();
                    String descr = st.nextToken();
                    Action shortcut = new Action(){

                        public void run() {
                            RegExpView.this.insertShortcut(shortc);
                        }
                    };
                    shortcut.setText(String.valueOf(shortc) + " - " + descr);
                    submenu.add((IAction)shortcut);
                    mgr.update(true);
                    continue;
                }
                if (st.countTokens() != 1 || !(token = st.nextToken()).equals("<DEL>")) continue;
                submenu.add((IContributionItem)new Separator());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.stopDebugAction);
        manager.add((IAction)this.backDebugAction);
        manager.add((IAction)this.forwardDebugAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.validateAction);
    }

    private void makeActions() {
        this.stopDebugAction = new Action(){

            public void run() {
                RegExpView.this.resetDebug();
            }
        };
        this.stopDebugAction.setText("Reset");
        this.stopDebugAction.setToolTipText("Reset");
        this.stopDebugAction.setImageDescriptor(RegExpImages.ICON_DEBUG_STOP);
        this.backDebugAction = new Action(){

            public void run() {
                RegExpView.this.backDebug();
            }
        };
        this.backDebugAction.setText("Backward");
        this.backDebugAction.setToolTipText("Backward");
        this.backDebugAction.setImageDescriptor(RegExpImages.ICON_DEBUG_BACK);
        this.forwardDebugAction = new Action(){

            public void run() {
                RegExpView.this.forwardDebug();
            }
        };
        this.forwardDebugAction.setText("Forward");
        this.forwardDebugAction.setToolTipText("Forward");
        this.forwardDebugAction.setImageDescriptor(RegExpImages.ICON_DEBUG_FORWARD);
        this.validateAction = new Action(){

            public void run() {
                RegExpView.this.validateRegExp();
            }
        };
        this.validateAction.setText("Validate RegExp");
        this.validateAction.setToolTipText("Validate RegExp");
        this.validateAction.setImageDescriptor(RegExpImages.ICON_RUN);
        this.cutAction = new Action("Cut", RegExpImages.EDIT_CUT){

            public void run() {
                ((StyledText)RegExpView.this.activeInput).cut();
            }
        };
        this.copyAction = new Action("Copy", RegExpImages.EDIT_COPY){

            public void run() {
                ((StyledText)RegExpView.this.activeInput).copy();
            }
        };
        this.pasteAction = new Action("Paste", RegExpImages.EDIT_PASTE){

            public void run() {
                ((StyledText)RegExpView.this.activeInput).paste();
            }
        };
    }

    private void insertShortcut(String text) {
        int selCount = this.regExpText.getSelectionCount();
        int pos = this.regExpText.getCaretOffset();
        this.regExpText.insert(text);
        if (selCount == 0) {
            this.regExpText.setCaretOffset(pos + text.length());
        }
    }

    public void validateRegExp() {
        boolean result = false;
        int eflags = 0;
        this.regExpText.setStyleRange(null);
        this.debugPosition = 0;
        if (this.ignoreCaseCheckBox.getSelection()) {
            eflags |= 2;
        }
        if (this.multilineCheckBox.getSelection()) {
            eflags |= 8;
        }
        try {
            RE re = new RE((Object)this.regExpText.getText(), eflags);
            REMatch[] matches = re.getAllMatches((Object)this.matchText.getText());
            result = matches.length > 0;
            this.matchText.setStyleRange(null);
            int i = 0;
            while (i < matches.length) {
                int color = 0;
                int j = 1;
                while (j <= re.getNumSubs()) {
                    StyleRange styleRange = new StyleRange();
                    styleRange.start = matches[i].getStartIndex(j);
                    styleRange.length = matches[i].getEndIndex(j) - matches[i].getStartIndex(j);
                    Display display = this.panel.getDisplay();
                    styleRange.foreground = display.getSystemColor(1);
                    styleRange.background = (Color)this.colorTable.get(color);
                    this.matchText.setStyleRange(styleRange);
                    this.matchText.setTopIndex(styleRange.start);
                    this.matchText.setCaretOffset(styleRange.start);
                    int offsetFromLine = styleRange.start - this.matchText.getOffsetAtLine(this.matchText.getLineAtOffset(styleRange.start));
                    this.matchText.setHorizontalIndex(offsetFromLine);
                    this.matchText.redraw();
                    if (++color > this.colorTable.size()) {
                        color = 0;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (REException e) {
            e.printStackTrace();
        }
        if (result) {
            this.setResultLabelImage(RegExpImages.RESULT_GREEN);
        } else {
            this.setResultLabelImage(RegExpImages.RESULT_RED);
        }
    }

    public void setResultLabelImage(ImageDescriptor descr) {
        Image labelImage = new Image((Device)this.resultImageLabel.getDisplay(), descr.getImageData());
        labelImage.setBackground(this.panel.getBackground());
        this.resultImageLabel.setImage(labelImage);
    }

    public void setFocus() {
    }

    private void buildDebugRegExp(String input, String match) {
        String result = "";
        RE re = null;
        boolean inBracket = false;
        boolean escape = false;
        int start = 0;
        int end = 0;
        int bracketStart = 0;
        this.debugInfo = new DebugInfo();
        this.debugInfo.setInput(input);
        this.debugInfo.setMatchString(match);
        try {
            re = new RE((Object)"\\[^.]");
            String convInput = re.substitute((Object)input, "..");
            if (convInput.indexOf(40) == -1) {
                int i = 0;
                while (i < input.length()) {
                    String nextChar;
                    String character = input.substring(i, i + 1);
                    if (!inBracket) {
                        re = new RE((Object)"[\\[\\{]");
                        if (re.isMatch((Object)character)) {
                            bracketStart = result.length();
                            result = String.valueOf(result) + "(" + character;
                            inBracket = true;
                            start = i;
                        } else {
                            if (!escape) {
                                bracketStart = result.length();
                                result = String.valueOf(result) + "(";
                                start = i;
                            } else {
                                escape = false;
                            }
                            result = String.valueOf(result) + character;
                            if (character.equals("\\")) {
                                escape = true;
                            } else {
                                if (i + 1 < input.length() && (re = new RE((Object)"[\\*\\+]")).isMatch((Object)(nextChar = input.substring(i + 1, i + 2)))) {
                                    result = String.valueOf(result) + nextChar;
                                    ++i;
                                }
                                if (i + 1 < input.length() && (re = new RE((Object)"[\\?]")).isMatch((Object)(nextChar = input.substring(i + 1, i + 2)))) {
                                    result = String.valueOf(result) + nextChar;
                                    ++i;
                                }
                                result = String.valueOf(result) + ")";
                                this.debugInfo.addSubexpressionPosition(start, i + 1);
                                this.debugInfo.addBracketPosition(bracketStart, result.length() - 1);
                            }
                        }
                    } else {
                        re = new RE((Object)"[\\]\\}]");
                        if (re.isMatch((Object)character)) {
                            if (i + 1 < input.length()) {
                                nextChar = input.substring(i + 1, i + 2);
                                if (nextChar.equals("{")) {
                                    result = String.valueOf(result) + character + nextChar;
                                    ++i;
                                } else {
                                    re = new RE((Object)"[\\+\\*]");
                                    if (re.isMatch((Object)nextChar)) {
                                        result = String.valueOf(result) + character + nextChar;
                                        if (++i + 1 < input.length() && (re = new RE((Object)"[\\?]")).isMatch((Object)(nextChar = input.substring(i + 1, i + 2)))) {
                                            result = String.valueOf(result) + nextChar;
                                            ++i;
                                        }
                                        result = String.valueOf(result) + ")";
                                        this.debugInfo.addSubexpressionPosition(start, i + 1);
                                        this.debugInfo.addBracketPosition(bracketStart, result.length() - 1);
                                        inBracket = false;
                                    } else {
                                        result = String.valueOf(result) + character + ")";
                                        this.debugInfo.addSubexpressionPosition(start, i + 1);
                                        this.debugInfo.addBracketPosition(bracketStart, result.length() - 1);
                                        inBracket = false;
                                    }
                                }
                            } else {
                                result = String.valueOf(result) + character + ")";
                                this.debugInfo.addSubexpressionPosition(start, i + 1);
                                this.debugInfo.addBracketPosition(bracketStart, result.length() - 1);
                                inBracket = false;
                            }
                        } else {
                            result = String.valueOf(result) + character;
                        }
                    }
                    ++i;
                }
            } else {
                result = input;
                re = new RE((Object)"\\((.*?)\\)");
                REMatch[] matches = re.getAllMatches((Object)convInput);
                int i = 0;
                while (i < matches.length) {
                    int j = 1;
                    while (j <= re.getNumSubs()) {
                        start = matches[i].getStartIndex(j);
                        end = matches[i].getEndIndex(j);
                        this.debugInfo.addSubexpressionPosition(start, end);
                        this.debugInfo.addBracketPosition(start, end);
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        this.debugInfo.setRegexp(result);
    }

    private void resetDebug() {
        this.debugPosition = 0;
        this.regExpText.setStyleRange(null);
        this.matchText.setStyleRange(null);
        this.setResultLabelImage(RegExpImages.RESULT_GRAY);
    }

    private void backDebug() {
        this.showDebugResult(this.debugPosition - 1);
    }

    private void forwardDebug() {
        this.showDebugResult(this.debugPosition + 1);
    }

    private void showDebugResult(int position) {
        if (this.debugInfo == null) {
            this.buildDebugRegExp(this.regExpText.getText(), this.matchText.getText());
            position = 1;
        } else if (!this.debugInfo.getInput().equals(this.regExpText.getText()) || !this.debugInfo.getMatchString().equals(this.matchText.getText())) {
            this.buildDebugRegExp(this.regExpText.getText(), this.matchText.getText());
            position = 1;
        }
        if (position > this.debugInfo.getSubexpressionCount() || position < 1) {
            return;
        }
        REMatch[] matches = this.debugInfo.getMatches(position - 1);
        this.debugPosition = position;
        StyleRange styleRangeRegExp = new StyleRange();
        Display display = this.panel.getDisplay();
        styleRangeRegExp.background = display.getSystemColor(9);
        styleRangeRegExp.foreground = display.getSystemColor(1);
        SubexpressionPos pos = this.debugInfo.getSubexpressionPosition(position - 1);
        this.regExpText.setStyleRange(null);
        styleRangeRegExp.start = pos.getStart();
        styleRangeRegExp.length = pos.getEnd() - pos.getStart();
        this.regExpText.setStyleRange(styleRangeRegExp);
        this.regExpText.setTopIndex(styleRangeRegExp.start);
        this.regExpText.setCaretOffset(styleRangeRegExp.start);
        int offsetFromLine = styleRangeRegExp.start - this.regExpText.getOffsetAtLine(this.regExpText.getLineAtOffset(styleRangeRegExp.start));
        this.regExpText.setHorizontalIndex(offsetFromLine);
        this.regExpText.redraw();
        this.matchText.setStyleRange(null);
        if (position <= this.debugInfo.geMatchingBracketsCount()) {
            this.setResultLabelImage(RegExpImages.RESULT_GREEN);
            int i = 0;
            while (i < matches.length) {
                StyleRange styleRangeMatch = new StyleRange();
                styleRangeMatch.background = display.getSystemColor(9);
                styleRangeMatch.foreground = display.getSystemColor(1);
                styleRangeMatch.start = matches[i].getStartIndex(position);
                styleRangeMatch.length = matches[i].getEndIndex(position) - matches[i].getStartIndex(position);
                this.matchText.setStyleRange(styleRangeMatch);
                this.matchText.setTopIndex(styleRangeMatch.start);
                this.matchText.setCaretOffset(styleRangeMatch.start);
                offsetFromLine = styleRangeMatch.start - this.matchText.getOffsetAtLine(this.matchText.getLineAtOffset(styleRangeMatch.start));
                this.matchText.setHorizontalIndex(offsetFromLine);
                this.matchText.redraw();
                ++i;
            }
        } else {
            this.setResultLabelImage(RegExpImages.RESULT_RED);
        }
    }

    public void setRegExpText(String regexp) {
        this.regExpText.setText(regexp);
    }

    public void setMatchText(String text) {
        this.matchText.setText(text);
    }

    public void setIgnoreCaseCheckbox(boolean state) {
        this.ignoreCaseCheckBox.setSelection(state);
    }

    public void setMultilineCheckbox(boolean state) {
        this.multilineCheckBox.setSelection(state);
    }

    class focusListener
    implements FocusListener {
        focusListener() {
        }

        public void focusGained(FocusEvent e) {
            RegExpView.this.activeInput = e.getSource();
        }

        public void focusLost(FocusEvent e) {
        }
    }

    class DebugInfo {
        private List subexpressions = new ArrayList();
        private List bracketsInRegexp = new ArrayList();
        private List allMatches = new ArrayList();
        private String input;
        private String regexp;
        private String matchString;
        private boolean matchesInitialized = false;
        private int matchingBracketsCount = 0;
        int eflags = 0;

        public void setInput(String input) {
            this.input = input;
        }

        public void setRegexp(String regexp) {
            this.regexp = regexp;
        }

        public void setMatchString(String match) {
            this.matchString = match;
        }

        public String getInput() {
            return this.input;
        }

        public String getRegExp() {
            return this.regexp;
        }

        public String getMatchString() {
            return this.matchString;
        }

        public void addBracketPosition(int start, int end) {
            this.bracketsInRegexp.add(new SubexpressionPos(start, end));
        }

        public void addSubexpressionPosition(int start, int end) {
            this.subexpressions.add(new SubexpressionPos(start, end));
        }

        public SubexpressionPos getSubexpressionPosition(int index) {
            return (SubexpressionPos)this.subexpressions.get(index);
        }

        public int getSubexpressionCount() {
            return this.subexpressions.size();
        }

        public REMatch[] getMatches(int index) {
            int checkEflags = 0;
            if (RegExpView.this.ignoreCaseCheckBox.getSelection()) {
                checkEflags |= 2;
            }
            if (RegExpView.this.multilineCheckBox.getSelection()) {
                checkEflags |= 8;
            }
            if (!this.matchesInitialized || this.eflags != checkEflags) {
                this.eflags = checkEflags;
                this.initMatches();
            }
            return this.allMatches.toArray(new REMatch[0]);
        }

        public int geMatchingBracketsCount() {
            return this.matchingBracketsCount;
        }

        public void initMatches() {
            String reg = null;
            boolean found = false;
            RE re = null;
            this.allMatches.clear();
            try {
                int i = this.bracketsInRegexp.size() - 1;
                while (i >= 0) {
                    SubexpressionPos pos = (SubexpressionPos)this.bracketsInRegexp.get(i);
                    reg = this.regexp.substring(0, pos.getEnd() + 1);
                    re = new RE((Object)reg, this.eflags);
                    if (re.getAllMatches((Object)this.matchString).length > 0) {
                        this.matchingBracketsCount = i + 1;
                        found = true;
                        break;
                    }
                    --i;
                }
                if (re != null && found) {
                    REMatch[] matches = re.getAllMatches((Object)this.matchString);
                    int j = 0;
                    while (j < matches.length) {
                        this.allMatches.add(matches[j]);
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.matchesInitialized = true;
        }
    }

    class SubexpressionPos {
        int start;
        int end;

        public SubexpressionPos(int start, int end) {
            this.start = start;
            this.end = end;
        }

        private int getStart() {
            return this.start;
        }

        private int getEnd() {
            return this.end;
        }
    }
}

