/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.util;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.epic.core.util.ProcessExecutor;
import org.epic.perleditor.PerlEditorPlugin;

class CygwinMount {
    private static String cygDrivePrefix = "/cygdrive/";

    private CygwinMount() {
    }

    public static String drivePrefix() {
        if (cygDrivePrefix == null) {
            try {
                CygwinMount.setDrivePrefix();
            }
            catch (CoreException coreException) {}
        }
        return cygDrivePrefix;
    }

    private static String setDrivePrefix() throws CoreException {
        try {
            ProcessExecutor executor = new ProcessExecutor();
            String[] cmd = new String[]{"mount", "-p"};
            File wrkDir = new File(".");
            Pattern p = Pattern.compile("^([^ \t]+).*user|system", 8);
            Matcher m = p.matcher(executor.execute((String[])cmd, (String)"", (File)wrkDir).stdout);
            if (m.find()) {
                cygDrivePrefix = m.group(1);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PerlEditorPlugin.getUniqueIdentifier(), 0, "Could not execute 'mount' to find out path mappings.\nAdd Cygwin's 'bin' directory (which contains mount.exe) to your PATH.", (Throwable)e));
        }
        return cygDrivePrefix;
    }
}

