/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.actions;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.epic.core.ResourceMessages;
import org.epic.core.util.MarkerUtilities;
import org.epic.perleditor.actions.PerlUserJobAction;
import org.epic.perleditor.editors.PerlEditor;
import org.epic.perleditor.editors.util.SourceCritic;
import org.epic.perleditor.preferences.PerlCriticPreferencePage;

public class PerlCriticAction
extends PerlUserJobAction {
    private static String METRICS_MARKER = "org.epic.perleditor.markers.critic";

    public PerlCriticAction(PerlEditor editor) {
        super(editor);
    }

    protected boolean checkJobPreconditions() {
        if (!PerlCriticPreferencePage.isPerlCriticEnabled()) {
            MessageDialog.openInformation((Shell)this.getEditor().getSite().getShell(), (String)ResourceMessages.getString("PerlCriticAction.perlCriticNotEnabledMessage"), (String)ResourceMessages.getString("PerlCriticAction.perlCriticNotEnabledMessage.descr"));
            return false;
        }
        File perlCriticScript = new File(PerlCriticPreferencePage.getPerlCritic());
        if (!perlCriticScript.exists() || !perlCriticScript.isFile()) {
            MessageDialog.openError((Shell)this.getEditor().getSite().getShell(), (String)ResourceMessages.getString("PerlCriticAction.perlCriticMissingMessage"), (String)ResourceMessages.getString("PerlCriticAction.perlCriticMissingMessage.descr"));
            return false;
        }
        return true;
    }

    protected Map createMarkerAttributes(MarkerUtilities factory, Object violation) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        SourceCritic.Violation v = (SourceCritic.Violation)violation;
        factory.setMessage(attributes, String.valueOf(v.message) + " (" + v.pbp + ")");
        factory.setLineNumber(attributes, v.lineNumber);
        factory.setSeverity((Map)attributes, this.getSeverity(v.severity));
        attributes.put("pbp", v.pbp);
        return attributes;
    }

    protected Object[] doJob(IResource resource) {
        return SourceCritic.critique(resource, this.getLog());
    }

    protected String getJobTitle(IResource resource) {
        return "Executing Perl::Critic against " + resource.getName();
    }

    protected String getMarker() {
        return METRICS_MARKER;
    }

    protected String getPerlEditorActionId() {
        return "org.epic.perleditor.actions.PerlCriticAction";
    }

    private int getSeverity(int severity) {
        return PerlCriticPreferencePage.getMarkerSeverity(severity);
    }
}

