/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.editors.IdleTimerListener;

public class IdleTimer
extends Thread {
    private final ISourceViewer sourceViewer;
    private final Display display;
    private final List listeners = new ArrayList();
    private long lastChange = -1L;
    private int waitForTermination = 1000;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.epic.perleditor.editors.IdleTimer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public IdleTimer(ISourceViewer sourceViewer, Display display) {
        super("IdleTimer");
        if (!$assertionsDisabled && sourceViewer == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && display == null) {
            throw new AssertionError();
        }
        this.sourceViewer = sourceViewer;
        this.display = display;
    }

    public synchronized void addListener(IdleTimerListener listener) {
        this.listeners.add(listener);
        this.lastChange = System.currentTimeMillis();
        this.notifyAll();
    }

    public void dispose() throws InterruptedException {
        this.interrupt();
        this.join(this.waitForTermination);
    }

    public synchronized void removeListener(IdleTimerListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized boolean isRegistered(IdleTimerListener listener) {
        return this.listeners.contains(listener);
    }

    public void run() {
        IDocumentListener changeListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void documentChanged(DocumentEvent event) {
                IdleTimer idleTimer = IdleTimer.this;
                synchronized (idleTimer) {
                    IdleTimer.this.lastChange = System.currentTimeMillis();
                    IdleTimer.this.notifyAll();
                }
            }
        };
        this.sourceViewer.getDocument().addDocumentListener(changeListener);
        try {
            this.runImpl();
        }
        catch (InterruptedException interruptedException) {}
    }

    private boolean isEditorVisible() {
        StyledText widget = ((SourceViewer)this.sourceViewer).getTextWidget();
        return widget != null && widget.isVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runImpl() throws InterruptedException {
        while (!Thread.interrupted()) {
            IdleTimer idleTimer = this;
            synchronized (idleTimer) {
                while (this.lastChange == -1L) {
                    this.wait();
                }
                int sleep = PerlEditorPlugin.getDefault().getPreferenceStore().getInt("SYNTAX_VALIDATION_IDLE_INTERVAL");
                while (System.currentTimeMillis() < this.lastChange + (long)sleep) {
                    this.wait(sleep);
                }
                this.lastChange = -1L;
            }
            try {
                IdleTimerListener[] _listeners = new IdleTimerListener[this.listeners.size()];
                IdleTimer sleep = this;
                synchronized (sleep) {
                    this.listeners.toArray(_listeners);
                }
                int i = 0;
                while (i < _listeners.length) {
                    final IdleTimerListener listener = _listeners[i];
                    this.display.syncExec(new Runnable(){

                        public void run() {
                            if (IdleTimer.this.isEditorVisible()) {
                                listener.onEditorIdle(IdleTimer.this.sourceViewer);
                            }
                        }
                    });
                    ++i;
                }
            }
            catch (SWTException sWTException) {}
        }
    }
}

