/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;

public class PartitionTypes {
    public static final String PERL_PARTITIONING = "org.epic.perleditor.perlPartitioning";
    public static final String DEFAULT = "__dftl_partition_content_type";
    public static final String COMMENT = "COMMENT";
    public static final String POD = "POD";
    public static final String KEYWORD1 = "KEYWORD1";
    public static final String KEYWORD2 = "KEYWORD2";
    public static final String VARIABLE = "VARIABLE";
    public static final String LITERAL1 = "LITERAL1";
    public static final String LITERAL2 = "LITERAL2";
    public static final String NUMBER = "NUMBER";
    public static final String OPERATOR = "OPERATOR";
    private static final String[] contentTypes = new String[]{"__dftl_partition_content_type", "COMMENT", "KEYWORD1", "KEYWORD2", "VARIABLE", "LITERAL1", "LITERAL2", "POD", "NUMBER", "OPERATOR"};

    public static ITypedRegion getPerlPartition(IDocument doc, int offset) throws BadLocationException {
        if (!(doc instanceof IDocumentExtension3)) {
            return doc.getPartition(offset);
        }
        try {
            return ((IDocumentExtension3)doc).getPartition(PERL_PARTITIONING, offset, false);
        }
        catch (BadPartitioningException badPartitioningException) {
            return doc.getPartition(offset);
        }
    }

    public static IDocumentPartitioner getPerlPartitioner(IDocument doc) {
        if (!(doc instanceof IDocumentExtension3)) {
            return null;
        }
        return ((IDocumentExtension3)doc).getDocumentPartitioner(PERL_PARTITIONING);
    }

    public static String[] getTypes() {
        String[] tmp = new String[contentTypes.length];
        System.arraycopy(contentTypes, 0, tmp, 0, tmp.length);
        return tmp;
    }

    private PartitionTypes() {
    }
}

