/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.editors.PartitionTypes;

public class PerlPresentationReconciler
extends PresentationReconciler {
    public PerlPresentationReconciler(IPreferenceStore prefs) {
        this.setDocumentPartitioning("org.epic.perleditor.perlPartitioning");
        DefaultDamagerRepairer ddr = new DefaultDamagerRepairer((ITokenScanner)new ColoringScanner(prefs));
        String[] contentTypes = PartitionTypes.getTypes();
        int i = 0;
        while (i < contentTypes.length) {
            this.setDamager((IPresentationDamager)ddr, contentTypes[i]);
            this.setRepairer((IPresentationRepairer)ddr, contentTypes[i]);
            ++i;
        }
    }

    private static class ColoringScanner
    implements ITokenScanner {
        private final IPreferenceStore prefs;
        private final IToken[] tokens;
        private final int[] lengths;
        private final Map textAttributes;
        private int offset;
        private int tokenI;
        private static String[] colors;

        static {
            String[] stringArray = new String[30];
            stringArray[0] = "COMMENT";
            stringArray[1] = "comment1Color";
            stringArray[2] = "comment1ColorBold";
            stringArray[3] = "__dftl_partition_content_type";
            stringArray[4] = "AbstractTextEditor.Color.Foreground";
            stringArray[6] = "KEYWORD1";
            stringArray[7] = "keyword1Color";
            stringArray[8] = "keyword1ColorBold";
            stringArray[9] = "KEYWORD2";
            stringArray[10] = "keyword2Color";
            stringArray[11] = "keyword2ColorBold";
            stringArray[12] = "LITERAL1";
            stringArray[13] = "literal1Color";
            stringArray[14] = "literal1ColorBold";
            stringArray[15] = "LITERAL2";
            stringArray[16] = "literal2Color";
            stringArray[17] = "literal2ColorBold";
            stringArray[18] = "POD";
            stringArray[19] = "comment2Color";
            stringArray[20] = "comment2ColorBold";
            stringArray[21] = "VARIABLE";
            stringArray[22] = "variableColor";
            stringArray[23] = "variableColorBold";
            stringArray[24] = "NUMBER";
            stringArray[25] = "numberColor";
            stringArray[26] = "numberColorBold";
            stringArray[27] = "OPERATOR";
            stringArray[28] = "operatorColor";
            stringArray[29] = "operatorColorBold";
            colors = stringArray;
        }

        public ColoringScanner(IPreferenceStore prefs) {
            this.prefs = prefs;
            this.tokens = new IToken[3];
            this.tokens[0] = Token.EOF;
            this.lengths = new int[3];
            this.textAttributes = new HashMap();
            int i = 0;
            while (i < colors.length) {
                this.textAttributes.put(colors[i], new Integer(i));
                i += 3;
            }
        }

        public void setRange(IDocument document, int offset, int length) {
            this.offset = offset;
            this.tokenI = -1;
            try {
                String type = PartitionTypes.getPerlPartition(document, offset).getType();
                if (type.equals("VARIABLE")) {
                    this.tokens[0] = new Token((Object)this.attr("__dftl_partition_content_type"));
                    this.tokens[1] = new Token((Object)this.attr(type));
                    this.tokens[2] = Token.EOF;
                    this.lengths[0] = 1;
                    this.lengths[1] = length - 1;
                    this.lengths[2] = 0;
                } else {
                    this.tokens[0] = new Token((Object)this.attr(type));
                    this.tokens[1] = Token.EOF;
                    this.lengths[0] = length;
                    this.lengths[1] = 0;
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        public IToken nextToken() {
            IToken ret;
            if (this.tokenI >= 0) {
                this.offset += this.lengths[this.tokenI];
            }
            if (!(ret = this.tokens[this.tokenI + 1]).isEOF()) {
                ++this.tokenI;
            }
            return ret;
        }

        public int getTokenOffset() {
            return this.offset;
        }

        public int getTokenLength() {
            return this.lengths[this.tokenI];
        }

        private TextAttribute attr(String type) {
            int index = (Integer)this.textAttributes.get(type);
            String colorPref = colors[index + 1];
            String boldPref = colors[index + 2];
            PerlEditorPlugin p = PerlEditorPlugin.getDefault();
            int style = 0;
            if (boldPref != null && this.prefs.getBoolean(boldPref)) {
                style = 1;
            }
            return new TextAttribute(this.getColor(p, colorPref), null, style);
        }

        private Color getColor(PerlEditorPlugin p, String colorPref) {
            return p.getColor(PreferenceConverter.getColor((IPreferenceStore)this.prefs, (String)colorPref));
        }
    }
}

