/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.epic.core.util.WidgetUtils;
import org.epic.perleditor.PerlEditorPlugin;

public class ModuleStarterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String MODULE_STARTER_PREF_ID = "org.epic.perleditor.preferences.ModuleStarterPreferencePage";
    private static final String DEFAULT_LOCATION = "/usr/bin/module-starter";
    private static final String ENTER_PATH_MSG = "Enter path to module-starter executable";
    private static final String INVALID_PATH_ERR = "Invalid module-starter location";
    private Button moduleEnabledButton;
    private Button useDefaultButton;
    private Button useCustomButton;
    private Text customLocationText;
    private Button overrideConfigButton;
    private Text authorText;
    private Text emailText;
    private Text addnOptsText;
    private List errors = new ArrayList(5);

    protected Control createContents(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        this.moduleEnabledButton = WidgetUtils.createButton(composite, "Enable Module::Starter", 16416);
        this.moduleEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ModuleStarterPreferencePage.this.validateEnabled();
                ModuleStarterPreferencePage.this.toggleEnabled(ModuleStarterPreferencePage.this.moduleEnabledButton.getSelection());
            }
        });
        Composite locations = WidgetUtils.createGroup(composite, 768);
        this.useDefaultButton = WidgetUtils.createButton(locations, "Default location (/usr/bin/module-starter)", 16400);
        this.useDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ModuleStarterPreferencePage.this.validateLocation(ModuleStarterPreferencePage.DEFAULT_LOCATION);
            }
        });
        this.useDefaultButton.setSelection(true);
        this.useCustomButton = WidgetUtils.createButton(locations, "Custom location", 16400);
        this.useCustomButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ModuleStarterPreferencePage.this.customLocationText.setText(ModuleStarterPreferencePage.this.loadString("moduleStarterLocation", ModuleStarterPreferencePage.DEFAULT_LOCATION, false));
                ModuleStarterPreferencePage.this.customLocationText.setEnabled(ModuleStarterPreferencePage.this.useCustomButton.getSelection() && ModuleStarterPreferencePage.this.moduleEnabledButton.getSelection());
                ModuleStarterPreferencePage.this.validateLocation(ModuleStarterPreferencePage.this.customLocationText.getText());
            }
        });
        this.customLocationText = WidgetUtils.createText(locations, "Path to module-starter");
        this.customLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModuleStarterPreferencePage.this.validateLocation(ModuleStarterPreferencePage.this.customLocationText.getText());
            }
        });
        Composite fields = WidgetUtils.createGroup(composite, 768);
        this.overrideConfigButton = WidgetUtils.createButton(fields, "Override module-starter config file", 32);
        this.overrideConfigButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ModuleStarterPreferencePage.this.authorText.setEnabled(ModuleStarterPreferencePage.this.overrideConfigButton.getSelection() && ModuleStarterPreferencePage.this.moduleEnabledButton.getSelection());
                ModuleStarterPreferencePage.this.emailText.setEnabled(ModuleStarterPreferencePage.this.overrideConfigButton.getSelection() && ModuleStarterPreferencePage.this.moduleEnabledButton.getSelection());
                ModuleStarterPreferencePage.this.addnOptsText.setEnabled(ModuleStarterPreferencePage.this.overrideConfigButton.getSelection() && ModuleStarterPreferencePage.this.moduleEnabledButton.getSelection());
            }
        });
        this.overrideConfigButton.setSelection(false);
        Composite cols = this.createComposite(fields, 2);
        WidgetUtils.createLabel(cols, "Module Author");
        this.authorText = WidgetUtils.createText(cols, System.getProperty("user.name"));
        this.authorText.setEnabled(false);
        WidgetUtils.createLabel(cols, "Module Author Email");
        this.emailText = WidgetUtils.createText(cols, "");
        this.emailText.setEnabled(false);
        WidgetUtils.createLabel(cols, "Additional options");
        this.addnOptsText = WidgetUtils.createText(cols, "");
        this.addnOptsText.setEnabled(false);
        this.toggleEnabled(this.moduleEnabledButton.getSelection());
        this.loadPreferences(false);
        return null;
    }

    public static String getModuleStarter() {
        return PerlEditorPlugin.getDefault().getPreferenceStore().getString("moduleStarterLocation");
    }

    public static boolean isModuleStarterEnabled() {
        return PerlEditorPlugin.getDefault().getPreferenceStore().getBoolean("moduleStarterEnabled");
    }

    public static String getModuleStarterAuthor() {
        return PerlEditorPlugin.getDefault().getPreferenceStore().getString("moduleStarterAuthor");
    }

    public static String getModuleStarterEmail() {
        return PerlEditorPlugin.getDefault().getPreferenceStore().getString("moduleStarterEmail");
    }

    public static String getModuleStarterAdditionalOpts() {
        return PerlEditorPlugin.getDefault().getPreferenceStore().getString("moduleStarterAddnOpts");
    }

    public static boolean isOverrideConfig() {
        return PerlEditorPlugin.getDefault().getPreferenceStore().getBoolean("moduleStarterOverrideConfig");
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(PerlEditorPlugin.getDefault().getPreferenceStore());
        this.updateErrorMessage();
    }

    public boolean performOk() {
        this.storeBoolean("moduleStarterEnabled", this.moduleEnabledButton.getSelection());
        this.storeBoolean("moduleStarterDefaultLocation", this.useDefaultButton.getSelection());
        String location = this.customLocationText.getText().equals("") ? DEFAULT_LOCATION : this.customLocationText.getText();
        this.storeString("moduleStarterLocation", location);
        this.storeBoolean("moduleStarterOverrideConfig", this.overrideConfigButton.getSelection());
        this.storeString("moduleStarterAuthor", this.authorText.getText());
        this.storeString("moduleStarterEmail", this.emailText.getText());
        this.storeString("moduleStarterAddnOpts", this.addnOptsText.getText());
        return super.performOk();
    }

    protected void performDefaults() {
        this.errors.clear();
        this.loadPreferences(true);
        super.performDefaults();
    }

    protected void removeErrorMessage(String message) {
        this.errors.remove(message);
        this.updateErrorMessage();
    }

    private void addErrorMessage(String message) {
        this.errors.remove(message);
        this.errors.add(message);
        this.updateErrorMessage();
    }

    private Composite createComposite(Composite parent, int numCols) {
        return WidgetUtils.createComposite(parent, numCols);
    }

    private boolean loadBoolean(String name, boolean restoreDefault) {
        IPreferenceStore store = this.getPreferenceStore();
        return restoreDefault ? store.getDefaultBoolean(name) : store.getBoolean(name);
    }

    private void loadPreferences(boolean restoreDefaults) {
        boolean useDefault = this.loadBoolean("moduleStarterDefaultLocation", restoreDefaults);
        this.useDefaultButton.setSelection(useDefault);
        this.useCustomButton.setSelection(!useDefault);
        this.moduleEnabledButton.setSelection(this.loadBoolean("moduleStarterEnabled", restoreDefaults));
        this.customLocationText.setText(this.loadString("moduleStarterLocation", "", restoreDefaults));
        this.overrideConfigButton.setSelection(this.loadBoolean("moduleStarterOverrideConfig", restoreDefaults));
        this.authorText.setText(this.loadString("moduleStarterAuthor", "", restoreDefaults));
        this.emailText.setText(this.loadString("moduleStarterEmail", "", restoreDefaults));
        this.addnOptsText.setText(this.loadString("moduleStarterAddnOpts", "", restoreDefaults));
        this.validateLocation(this.customLocationText.getText());
        this.toggleEnabled(this.moduleEnabledButton.getSelection());
        this.updateErrorMessage();
    }

    private String loadString(String name, String backup, boolean restoreDefault) {
        IPreferenceStore store = this.getPreferenceStore();
        String value = restoreDefault ? store.getDefaultString(name) : store.getString(name);
        return "".equals(value) ? backup : value;
    }

    private void storeBoolean(String name, boolean value) {
        this.getPreferenceStore().setValue(name, value);
    }

    private void storeString(String name, String value) {
        this.getPreferenceStore().setValue(name, value);
    }

    private void toggleEnabled(boolean enabled) {
        System.setProperty("moduleStarterEnabled", Boolean.toString(enabled));
        this.useDefaultButton.setEnabled(enabled);
        this.useCustomButton.setEnabled(enabled);
        this.overrideConfigButton.setEnabled(enabled);
        this.customLocationText.setEnabled(enabled && !this.useDefaultButton.getSelection());
        this.authorText.setEnabled(enabled && this.overrideConfigButton.getSelection());
        this.emailText.setEnabled(enabled && this.overrideConfigButton.getSelection());
        this.addnOptsText.setEnabled(enabled && this.overrideConfigButton.getSelection());
    }

    private void updateErrorMessage() {
        String message = this.errors.isEmpty() ? null : (String)this.errors.get(this.errors.size() - 1);
        this.setErrorMessage(message);
        this.setValid(message == null);
    }

    private void validateEnabled() {
        if (!this.moduleEnabledButton.getSelection()) {
            this.removeErrorMessage(INVALID_PATH_ERR);
            return;
        }
        String location = DEFAULT_LOCATION;
        if (!this.useDefaultButton.getSelection()) {
            location = this.customLocationText.getText();
        }
        this.validateLocation(location);
    }

    private void validateLocation(String location) {
        if (location == null || location.length() == 0) {
            if (!this.useDefaultButton.getSelection()) {
                this.addErrorMessage(ENTER_PATH_MSG);
            }
            return;
        }
        this.removeErrorMessage(ENTER_PATH_MSG);
        if (this.moduleEnabledButton.getSelection() && !new File(location).isFile()) {
            this.addErrorMessage(INVALID_PATH_ERR);
        } else {
            this.removeErrorMessage(INVALID_PATH_ERR);
        }
    }
}

