/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.templates;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.templates.Template;
import org.epic.perleditor.templates.TemplateBuffer;
import org.epic.perleditor.templates.TemplateContext;
import org.epic.perleditor.templates.TemplateMessages;
import org.epic.perleditor.templates.TemplatePosition;
import org.epic.perleditor.templates.perl.IPerlCompletionProposal;
import org.epic.perleditor.templates.perl.PerlTemplateMessages;
import org.epic.perleditor.templates.perl.PerlUnitContext;
import org.epic.perleditor.templates.ui.LinkedPositionManager;
import org.epic.perleditor.templates.ui.LinkedPositionUI;

public class TemplateProposal
implements IPerlCompletionProposal {
    private final Template template;
    private final TemplateContext context;
    private final ITextViewer viewer;
    private final Image image;
    private final IRegion region;
    private TemplateBuffer templateBuffer;
    private IRegion selectedRegion;

    public TemplateProposal(Template template, TemplateContext context, IRegion region, ITextViewer viewer, Image image) {
        this.template = template;
        this.context = context;
        this.viewer = viewer;
        this.image = image;
        this.region = region;
    }

    public void apply(IDocument document) {
        try {
            if (this.templateBuffer == null) {
                this.templateBuffer = this.context.evaluate(this.template);
            }
            int start = this.region.getOffset();
            int end = this.region.getOffset() + this.region.getLength();
            this.templateBuffer.indent(this.getLineIndent(document, this.region.getOffset()));
            String templateString = this.templateBuffer.getString();
            document.replace(start, end - start, templateString);
            LinkedPositionManager manager = new LinkedPositionManager(document);
            TemplatePosition[] variables = this.templateBuffer.getVariables();
            int i = 0;
            while (i < variables.length) {
                TemplatePosition variable = variables[i];
                if (!variable.isResolved()) {
                    int[] offsets = variable.getOffsets();
                    int length = variable.getLength();
                    int j = 0;
                    while (j < offsets.length) {
                        manager.addPosition(offsets[j] + start, length);
                        ++j;
                    }
                }
                ++i;
            }
            LinkedPositionUI editor = new LinkedPositionUI(this.viewer, manager);
            editor.setFinalCaretOffset(TemplateProposal.getCaretOffset(this.templateBuffer) + start);
            editor.enter();
            this.selectedRegion = editor.getSelectedRegion();
        }
        catch (Exception e) {
            this.logException("Failed to apply template", e);
            this.openErrorDialog(e);
        }
    }

    private static int getCaretOffset(TemplateBuffer buffer) {
        TemplatePosition[] variables = buffer.getVariables();
        int i = 0;
        while (i != variables.length) {
            TemplatePosition variable = variables[i];
            if (variable.getName().equals(PerlTemplateMessages.getString("GlobalVariables.variable.name.cursor"))) {
                return variable.getOffsets()[0];
            }
            ++i;
        }
        return buffer.getString().length();
    }

    public Point getSelection(IDocument document) {
        return new Point(this.selectedRegion.getOffset(), this.selectedRegion.getLength());
    }

    public String getAdditionalProposalInfo() {
        try {
            if (this.templateBuffer == null) {
                this.templateBuffer = this.context.evaluate(this.template);
            }
            return this.templateBuffer.getString();
        }
        catch (CoreException e) {
            this.logException("Failed to evaluate template", e);
            return null;
        }
    }

    public String getDisplayString() {
        return String.valueOf(this.template.getName()) + TemplateMessages.getString("TemplateProposal.delimiter") + this.template.getDescription();
    }

    public Image getImage() {
        return this.image;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    private void openErrorDialog(Exception e) {
        Shell shell = this.viewer.getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)TemplateMessages.getString("TemplateEvaluator.error.title"), (String)e.getMessage());
    }

    public int getRelevance() {
        if (this.context instanceof PerlUnitContext) {
            PerlUnitContext ctx = (PerlUnitContext)this.context;
            switch (ctx.getCharacterBeforeStart()) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    return 90;
                }
            }
            return 0;
        }
        return 90;
    }

    private String getLineIndent(IDocument doc, int offset) {
        int lineOffset;
        block5: {
            int line = doc.getLineOfOffset(offset);
            lineOffset = doc.getLineOffset(line);
            if (lineOffset != this.region.getOffset()) break block5;
            return "";
        }
        try {
            String lineStart = doc.get(lineOffset, this.region.getOffset() - lineOffset);
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < lineStart.length()) {
                char c = lineStart.charAt(i);
                if (Character.isWhitespace(c)) {
                    buf.append(c);
                }
                ++i;
            }
            return buf.toString();
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    private void logException(String msg, Throwable e) {
        Status status = new Status(4, PerlEditorPlugin.getPluginId(), 0, msg, e);
        PerlEditorPlugin.getDefault().getLog().log((IStatus)status);
    }
}

