/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.PerlTarget;
import org.epic.debug.db.DebuggerInterface;
import org.epic.debug.db.PerlDebugThread;
import org.epic.debug.ui.action.ShowGlobalVariableActionDelegate;
import org.epic.debug.ui.action.ShowLocalVariableActionDelegate;
import org.epic.debug.util.DebuggerProxy2;
import org.epic.debug.util.IPathMapper;
import org.epic.debug.util.RemotePort;
import org.epic.perleditor.PerlEditorPlugin;

public class DebugTarget
extends PerlTarget {
    public static final int SESSION_TERMINATED = 10000;
    private final IDebugEventSetListener listener = new IDebugEventSetListener(){

        public void handleDebugEvents(DebugEvent[] events) {
            int i = 0;
            while (i < events.length) {
                if (events[i].getKind() == 8 && DebugTarget.this.getProcess().equals(events[i].getSource())) {
                    DebugTarget.this.shutdown();
                    return;
                }
                ++i;
            }
        }
    };
    private final IProcess process;
    private final RemotePort debugPort;
    private final PerlDebugThread thread;
    private final DebuggerInterface db;
    private final IPathMapper pathMapper;

    public DebugTarget(ILaunch launch, IProcess process, RemotePort debugPort, IPathMapper pathMapper) throws CoreException {
        super(launch);
        try {
            try {
                this.process = process;
                this.debugPort = debugPort;
                this.pathMapper = pathMapper;
                this.db = this.createDebuggerInterface();
                this.checkPadWalker();
                this.thread = new PerlDebugThread(this, this.db);
                this.registerDebugEventListener(this.listener);
                this.fireCreationEvent();
            }
            catch (DebuggerInterface.SessionTerminatedException e) {
                throw new DebugException((IStatus)new Status(0, PerlDebugPlugin.getUniqueIdentifier(), 10000, "Debugger session terminated (compile error?)", (Throwable)e));
            }
        }
        catch (CoreException e) {
            this.shutdown();
            throw e;
        }
        catch (RuntimeException e) {
            this.shutdown();
            throw e;
        }
    }

    public String getName() throws DebugException {
        return this.getProcess().getLabel();
    }

    public IProcess getProcess() {
        return this.process;
    }

    public boolean isLocal() {
        return true;
    }

    public IPathMapper getPathMapper() {
        return this.pathMapper;
    }

    public IThread getThread() {
        return this.thread;
    }

    public IThread[] getThreads() throws DebugException {
        return new IThread[]{this.thread};
    }

    public boolean hasThreads() throws DebugException {
        return true;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return false;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.thread.terminate();
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public void resume() throws DebugException {
        this.thread.resume();
    }

    public void suspend() throws DebugException {
        this.thread.suspend();
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
        this.unsupportedOperation();
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        this.unsupportedOperation();
        return null;
    }

    protected void shutdown() {
        this.unregisterDebugEventListener(this.listener);
        this.debugPort.shutdown();
        super.shutdown();
    }

    protected RemotePort getRemotePort() {
        return this.debugPort;
    }

    protected DebuggerInterface initDebuggerInterface(DebuggerInterface db) throws DebugException {
        if (this.getPathMapper().requiresEffectiveIncPath()) {
            this.getPathMapper().setEffectiveIncPath(this.getEffectiveIncPath(db));
        }
        return db;
    }

    protected void registerDebugEventListener(IDebugEventSetListener listener) {
        DebugPlugin.getDefault().addDebugEventListener(listener);
    }

    protected final void throwDebugException(IOException e) throws DebugException {
        throw new DebugException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "An error occurred during communication with the debugger process", (Throwable)e));
    }

    protected void unregisterDebugEventListener(IDebugEventSetListener listener) {
        DebugPlugin.getDefault().removeDebugEventListener(listener);
    }

    protected void checkPadWalker() throws DebugException {
        try {
            if ((ShowLocalVariableActionDelegate.getPreferenceValue() || ShowGlobalVariableActionDelegate.getPreferenceValue()) && !this.db.hasPadWalker()) {
                PerlDebugPlugin.errorDialog("Error displaying local variables\nInstall PadWalker and restart Eclipse or disable displaying of local variables.");
            }
        }
        catch (IOException e) {
            this.throwDebugException(e);
        }
    }

    protected boolean getDebugConsolePreference() {
        return PerlEditorPlugin.getDefault().getBooleanPreference("ENABLE_DEBUG_CONSOLE");
    }

    private DebuggerInterface createDebuggerInterface() throws DebuggerInterface.SessionTerminatedException, DebugException {
        BufferedReader in = this.debugPort.getReadStream();
        PrintWriter out = this.debugPort.getWriteStream();
        if (this.getDebugConsolePreference()) {
            DebuggerProxy2 p = new DebuggerProxy2(in, out, this.getLaunch());
            this.getLaunch().addProcess((IProcess)p);
            in = p.getDebugIn();
            out = p.getDebugOut();
        }
        try {
            return this.initDebuggerInterface(new DebuggerInterface(in, out));
        }
        catch (DebuggerInterface.SessionTerminatedException e) {
            throw e;
        }
        catch (IOException e) {
            this.throwDebugException(e);
            return null;
        }
    }

    private List getEffectiveIncPath(DebuggerInterface db) throws DebugException {
        try {
            ArrayList<Path> ret = new ArrayList<Path>();
            String output = db.eval(";{foreach $t(@INC) {print $DB::OUT $t.\"\\n\";}}");
            StringTokenizer s = new StringTokenizer(output, "\r\n");
            while (s.hasMoreTokens()) {
                ret.add(new Path(s.nextToken()));
            }
            return ret;
        }
        catch (IOException e) {
            this.throwDebugException(e);
            return null;
        }
    }
}

