/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.db;

import org.eclipse.debug.core.DebugException;
import org.epic.debug.db.DebuggerInterface;
import org.epic.debug.db.DumpedEntity;
import org.epic.debug.db.PerlVariable;

class ArrayElement
extends PerlVariable {
    private final PerlVariable array;

    protected ArrayElement(DebuggerInterface db, PerlVariable array, DumpedEntity entity) throws DebugException {
        super(db, array.getStackFrame(), entity);
        this.array = array;
    }

    public String getName() throws DebugException {
        return "[" + super.getName() + "]";
    }

    public String getExpression() throws DebugException {
        StringBuffer buf = new StringBuffer();
        int refCount = this.getDumpedEntity().getReferenceCount();
        int i = 0;
        while (i < refCount) {
            buf.append("${");
            ++i;
        }
        buf.append(this.array.getExpression());
        i = 0;
        while (i < refCount) {
            buf.append("}");
            ++i;
        }
        buf.append(this.getName());
        return buf.toString();
    }
}

