/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.db;

class DumpedEntity {
    private final String name;
    private final String[] refChain;
    private final String value;
    private final int valueLength;
    private final boolean cyclic;
    private final boolean undef;

    public DumpedEntity(String name, String[] refChain, String value, int valueLength) {
        this.name = name;
        this.refChain = refChain;
        this.valueLength = valueLength;
        if (value.length() >= 1 && value.charAt(0) == '\'') {
            this.value = value.substring(1, value.length() - 1);
            this.cyclic = false;
            this.undef = false;
        } else {
            this.value = null;
            this.undef = "undef".equals(value);
            this.cyclic = "cycle".equals(value);
        }
    }

    public String getAddress() {
        return this.addressFrom(this.refChain[0]);
    }

    public String getImmediateValue() {
        return this.refChain.length > 1 ? this.addressFrom(this.refChain[1]) : this.value;
    }

    public String getName() {
        return this.name;
    }

    public int getOriginalValueLength() {
        return this.valueLength;
    }

    public String[] getReferenceChain() {
        return this.refChain;
    }

    public int getReferenceCount() {
        return this.refChain.length - 1;
    }

    public String getReferenceType() {
        String varType = this.refChain[this.refChain.length - 1];
        int i = varType.indexOf(61) + 1;
        if (i <= 0) {
            i = 0;
        }
        return varType.substring(i, varType.indexOf(40, i));
    }

    public String getValue() {
        return this.value;
    }

    public boolean isCyclicReference() {
        return this.cyclic;
    }

    public boolean isDefined() {
        return !this.undef;
    }

    public boolean isTruncated() {
        return this.isDefined() && this.value.length() < this.valueLength;
    }

    private String addressFrom(String ref) {
        try {
            int i = ref.indexOf(40);
            return ref.substring(i + 1, ref.indexOf(41));
        }
        catch (Exception exception) {
            return ref;
        }
    }
}

