/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.db;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.ui.progress.UIJob;
import org.epic.debug.DebugTarget;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.db.DebugCommand;
import org.epic.debug.db.DebuggerInterface;
import org.epic.debug.db.PerlDebugJob;
import org.epic.debug.db.PerlThreadBreakpoints;
import org.epic.debug.db.PerlThreadStack;
import org.epic.debug.db.ResumeCommand;
import org.epic.debug.db.StepIntoCommand;
import org.epic.debug.db.StepOverCommand;
import org.epic.debug.db.StepReturnCommand;
import org.epic.debug.db.TerminateCommand;
import org.epic.perleditor.PerlEditorPlugin;

public class PerlDebugThread
extends DebugElement
implements IThread {
    private static final IBreakpoint[] NO_BREAKPOINTS;
    private static final int INITIALIZING = 0;
    private static final int SUSPENDED = 1;
    private static final int STEPPING = 2;
    private static final int RUNNING = 3;
    private static final int TERMINATING = 4;
    private static final int TERMINATED = 5;
    private final Object LOCK = new Object();
    private final PerlThreadStack stack;
    private final PerlThreadBreakpoints bp;
    private final PerlDebugJob job;
    private final String name;
    private final DebuggerInterface db;
    private int state;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.epic.debug.db.PerlDebugThread");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        NO_BREAKPOINTS = new IBreakpoint[0];
    }

    public PerlDebugThread(IDebugTarget debugTarget, DebuggerInterface db) throws CoreException {
        super(debugTarget);
        this.db = db;
        this.stack = new PerlThreadStack(this);
        this.bp = new PerlThreadBreakpoints(this, db);
        this.state = 0;
        this.name = "Main Thread";
        this.job = new PerlDebugJob();
        this.fireCreationEvent();
        this.suspended(16);
        if (!this.isBreakpointReached() && !PerlEditorPlugin.getDefault().getBooleanPreference("SUSPEND_AT_FIRST_CONSOLE")) {
            UIJob resume = new UIJob("PerlDebugThread.resume"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        PerlDebugThread.this.resume();
                    }
                    catch (DebugException e) {
                        PerlDebugPlugin.log(e);
                    }
                    return Status.OK_STATUS;
                }
            };
            resume.setSystem(true);
            resume.schedule();
        } else {
            this.fireSuspendEvent(16);
        }
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public String evaluateStatement(String text) throws DebugException {
        try {
            String output = this.db.eval(text);
            this.stack.update();
            return output;
        }
        catch (IOException e) {
            this.throwDebugException(e);
            return null;
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.epic.debug.db.PerlDebugThread");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(adapter)) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.debug.core.model.IStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.isAssignableFrom(adapter)) {
            try {
                return this.getTopStackFrame();
            }
            catch (DebugException debugException) {}
        }
        return super.getAdapter(adapter);
    }

    public IBreakpoint[] getBreakpoints() {
        try {
            IBreakpoint breakpoint = this.bp.getCurrentBreakpoint();
            if (breakpoint != null) {
                return new IBreakpoint[]{breakpoint};
            }
            return NO_BREAKPOINTS;
        }
        catch (CoreException e) {
            PerlDebugPlugin.log(e);
            return NO_BREAKPOINTS;
        }
    }

    public String getModelIdentifier() {
        return PerlDebugPlugin.getUniqueIdentifier();
    }

    public String getName() throws DebugException {
        if (this.isSuspended()) {
            return "<suspended> " + this.name;
        }
        if (!this.isTerminated()) {
            return "<running> " + this.name;
        }
        return this.name;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        return this.stack.getFrames();
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] frames = this.getStackFrames();
        return frames.length > 0 ? frames[0] : null;
    }

    public boolean hasStackFrames() throws DebugException {
        return this.stack.getFrames().length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStepping() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.state == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.state == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.state == 5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws DebugException {
        Object object = this.LOCK;
        synchronized (object) {
            this.assertSuspended();
            this.state = 3;
            this.fireResumeEvent(0);
            this.job.setCommand(new ResumeCommand(this));
            this.job.schedule();
        }
    }

    public void stepInto() throws DebugException {
        this.step(1);
    }

    public void stepOver() throws DebugException {
        this.step(2);
    }

    public void stepReturn() throws DebugException {
        this.step(4);
    }

    public void suspend() throws DebugException {
        throw new DebugException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "Suspend not supported", null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() throws DebugException {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isSuspended()) {
                this.state = 4;
                this.job.setCommand(new TerminateCommand(this));
                this.job.schedule();
            } else {
                this.terminated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void debugCommandFinished(DebugCommand cmd) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.state == 5) {
                return;
            }
        }
        if (cmd.hasSuspended()) {
            this.suspended(cmd.getCompletionStatus());
        } else {
            this.terminated();
        }
    }

    DebuggerInterface getDB() {
        return this.db;
    }

    IPath getDebuggerPath(IPath epicPath) {
        return ((DebugTarget)this.getDebugTarget()).getPathMapper().getDebuggerPath(epicPath, this.db);
    }

    IPath getEpicPath(IPath dbPath) {
        if (!dbPath.isAbsolute()) {
            try {
                dbPath = this.bp.getAbsDBPath(dbPath);
            }
            catch (CoreException e) {
                PerlDebugPlugin.log(e);
            }
        }
        return ((DebugTarget)this.getDebugTarget()).getPathMapper().getEpicPath(dbPath);
    }

    void installPendingBreakpoints() {
        try {
            this.bp.installPendingBreakpoints();
        }
        catch (CoreException e) {
            PerlDebugPlugin.log(e);
        }
    }

    boolean isBreakpointReached() throws CoreException {
        return this.bp.getCurrentBreakpoint() != null;
    }

    private void assertSuspended() throws DebugException {
        if (!this.isSuspended()) {
            throw new DebugException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "This action only works when the debugger is suspended", null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void step(int kind) throws DebugException {
        Object object = this.LOCK;
        synchronized (object) {
            DebugCommand cmd;
            this.assertSuspended();
            this.state = 2;
            this.fireResumeEvent(kind);
            switch (kind) {
                case 1: {
                    cmd = new StepIntoCommand(this);
                    break;
                }
                case 2: {
                    cmd = new StepOverCommand(this);
                    break;
                }
                case 4: {
                    cmd = new StepReturnCommand(this);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)"unrecognized step kind");
                    }
                    return;
                }
            }
            this.job.setCommand(cmd);
            this.job.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspended(int kind) {
        try {
            this.stack.update();
            this.bp.installPendingBreakpoints();
        }
        catch (CoreException e) {
            PerlDebugPlugin.log(e);
        }
        Object object = this.LOCK;
        synchronized (object) {
            boolean wasInitializing = this.state == 0;
            this.state = 1;
            if (!wasInitializing) {
                this.fireSuspendEvent(kind);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminated() {
        Object object = this.LOCK;
        synchronized (object) {
            this.db.dispose();
            this.bp.dispose();
            this.state = 5;
            this.fireTerminateEvent();
        }
    }

    void throwDebugException(IOException e) throws DebugException {
        throw new DebugException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "An error occurred during communication with the debugger process", (Throwable)e));
    }

    void unresolvedDebuggerPath(IPath dbPath) {
        PerlDebugPlugin.log((IStatus)new Status(2, PerlDebugPlugin.getUniqueIdentifier(), 0, "Could not map remote path " + dbPath + " to a local path. Some breakpoints may be ignored.", null));
    }

    void unresolvedEpicPath(IPath epicPath) {
        PerlDebugPlugin.log((IStatus)new Status(2, PerlDebugPlugin.getUniqueIdentifier(), 0, "Could not map local path " + epicPath + " to a remote path. Some breakpoints may be ignored.", null));
    }
}

