/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.db;

import gnu.regexp.REMatch;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.epic.debug.db.DebuggerInterface;
import org.epic.debug.db.IPPosition;
import org.epic.debug.db.PerlDebugThread;
import org.epic.debug.db.RE;
import org.epic.debug.db.StackFrame;

class PerlThreadStack {
    private static final IStackFrame[] NO_FRAMES = new IStackFrame[0];
    private final PerlDebugThread thread;
    private final RE re = new RE();
    private IStackFrame[] frames;

    public PerlThreadStack(PerlDebugThread thread) {
        this.thread = thread;
        this.frames = NO_FRAMES;
    }

    public IStackFrame[] getFrames() throws DebugException {
        return this.thread.isSuspended() ? this.frames : NO_FRAMES;
    }

    public void update() throws DebugException {
        try {
            DebuggerInterface db = this.thread.getDB();
            IPPosition currentIP = db.getCurrentIP();
            if (currentIP == null) {
                return;
            }
            String stackTrace = db.getStackTrace();
            REMatch[] matches = this.re.STACK_TRACE.getAllMatches((Object)stackTrace);
            IStackFrame[] previousFrames = this.frames;
            StackFrame previousTopFrame = previousFrames.length > 0 ? (StackFrame)previousFrames[0] : null;
            StackFrame[] frames = new StackFrame[matches.length + 1];
            frames[0] = new StackFrame(this.thread, currentIP.getPath(), currentIP.getLine(), this.thread.getEpicPath(currentIP.getPath()), db, previousTopFrame, 0);
            int pos = 0;
            while (pos < matches.length) {
                Path dbPath = new Path(matches[pos].toString(3));
                frames[pos + 1] = new StackFrame(this.thread, (IPath)dbPath, Integer.parseInt(matches[pos].toString(4)), this.thread.getEpicPath((IPath)dbPath), db, pos + 1 < previousFrames.length ? (StackFrame)previousFrames[pos + 1] : null, pos + 1);
                ++pos;
            }
            this.frames = frames;
        }
        catch (IOException e) {
            this.thread.throwDebugException(e);
        }
    }
}

