/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.ui;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.ui.PerlDebugImages;
import org.epic.debug.ui.ProjectAndFileBlock;
import org.epic.debug.util.RemotePort;

public class LaunchConfigurationRemoteMainTab
extends AbstractLaunchConfigurationTab
implements IPropertyChangeListener {
    protected Label fHostLabel;
    protected Label fPortLabel;
    protected Text fHostText;
    protected Text fPortText;
    protected static final String EMPTY_STRING = "";
    private static final String PERL_NATURE_ID = "org.epic.perleditor.perlnature";
    private Label fDestLabel;
    private Text fDestText;
    private GridLayout layout;
    private FileFieldEditor mDebugPackageFilePath;
    private Object checkComp;
    private Label fCreatePkgLabel;
    private Label fCaptureOutLabel;
    private Button fCreatePkgCheckBox;
    private Button fCaptureOutCheckBox;
    Composite mDebugPackageComp;
    private ProjectAndFileBlock fProjectAndFileBlock = new ProjectAndFileBlock();

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.fProjectAndFileBlock.createControl(comp);
        this.createVerticalSpacer(comp, 2);
        Composite hostComp = new Composite(comp, 0);
        GridLayout hostLayout = new GridLayout();
        hostLayout.numColumns = 3;
        hostLayout.marginHeight = 0;
        hostLayout.marginWidth = 0;
        hostLayout.makeColumnsEqualWidth = true;
        hostComp.setLayout((Layout)hostLayout);
        GridData gd = new GridData(768);
        hostComp.setLayoutData((Object)gd);
        hostComp.setFont(font);
        this.fHostLabel = new Label(hostComp, 0);
        this.fHostLabel.setText("Local Host IP:");
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.fHostLabel.setLayoutData((Object)gd);
        this.fHostLabel.setFont(font);
        this.fHostText = new Text(hostComp, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fHostText.setLayoutData((Object)gd);
        this.fHostText.setFont(font);
        this.fHostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                LaunchConfigurationRemoteMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createVerticalSpacer(comp, 1);
        Composite destComp = new Composite(comp, 0);
        GridLayout destLayout = new GridLayout();
        destLayout.numColumns = 3;
        destLayout.marginHeight = 0;
        destLayout.marginWidth = 0;
        destLayout.makeColumnsEqualWidth = true;
        destComp.setLayout((Layout)destLayout);
        gd = new GridData(768);
        destComp.setLayoutData((Object)gd);
        destComp.setFont(font);
        this.fDestLabel = new Label(destComp, 0);
        this.fDestLabel.setText("Target Host Project Installation Path:");
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.fDestLabel.setLayoutData((Object)gd);
        this.fDestLabel.setFont(font);
        this.fDestText = new Text(destComp, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fDestText.setLayoutData((Object)gd);
        this.fDestText.setFont(font);
        this.fDestText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                LaunchConfigurationRemoteMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createVerticalSpacer(comp, 1);
        Composite portComp = new Composite(comp, 0);
        GridLayout portLayout = new GridLayout();
        portLayout.numColumns = 3;
        portLayout.marginHeight = 0;
        portLayout.marginWidth = 0;
        portLayout.makeColumnsEqualWidth = true;
        portComp.setLayout((Layout)portLayout);
        gd = new GridData(768);
        portComp.setLayoutData((Object)gd);
        portComp.setFont(font);
        this.fPortLabel = new Label(portComp, 0);
        this.fPortLabel.setText("Port:");
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.fPortLabel.setLayoutData((Object)gd);
        this.fPortLabel.setFont(font);
        this.fPortText = new Text(portComp, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fPortText.setLayoutData((Object)gd);
        this.fPortText.setFont(font);
        this.fPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                LaunchConfigurationRemoteMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createVerticalSpacer(comp, 1);
        Composite captureComp = new Composite(comp, 0);
        GridLayout captureLayout = new GridLayout();
        captureLayout.numColumns = 3;
        captureLayout.marginHeight = 0;
        captureLayout.marginWidth = 0;
        captureLayout.makeColumnsEqualWidth = true;
        captureComp.setLayout((Layout)captureLayout);
        gd = new GridData(768);
        captureComp.setLayoutData((Object)gd);
        captureComp.setFont(font);
        this.fCaptureOutLabel = new Label(captureComp, 0);
        this.fCaptureOutLabel.setText("Capture Output");
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.fCaptureOutLabel.setLayoutData((Object)gd);
        this.fCaptureOutLabel.setFont(font);
        this.fCaptureOutCheckBox = new Button(captureComp, 0x1000020);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.fCaptureOutCheckBox.setLayoutData((Object)gd);
        this.fCaptureOutCheckBox.setFont(font);
        this.createVerticalSpacer(comp, 1);
        Composite checkComp = new Composite(comp, 0);
        GridLayout checkLayout = new GridLayout();
        checkLayout.numColumns = 3;
        checkLayout.marginHeight = 0;
        checkLayout.marginWidth = 0;
        checkLayout.makeColumnsEqualWidth = true;
        checkComp.setLayout((Layout)portLayout);
        gd = new GridData(768);
        checkComp.setLayoutData((Object)gd);
        checkComp.setFont(font);
        this.fCreatePkgLabel = new Label(checkComp, 0);
        this.fCreatePkgLabel.setText("Create Debug Package");
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.fCreatePkgLabel.setLayoutData((Object)gd);
        this.fCreatePkgLabel.setFont(font);
        this.fCreatePkgCheckBox = new Button(checkComp, 0x1000020);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.fCreatePkgCheckBox.setLayoutData((Object)gd);
        this.fCreatePkgCheckBox.setFont(font);
        this.fCreatePkgCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LaunchConfigurationRemoteMainTab.this.calculatePackageFilePathEnabled();
                LaunchConfigurationRemoteMainTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.layout = new GridLayout();
        this.layout.numColumns = 3;
        this.layout.marginHeight = 0;
        this.layout.marginWidth = 0;
        this.layout.makeColumnsEqualWidth = true;
        gd = new GridData(768);
        this.mDebugPackageComp = new Composite(comp, 0);
        this.mDebugPackageComp.setLayout((Layout)this.layout);
        this.mDebugPackageComp.setLayoutData((Object)gd);
        this.mDebugPackageComp.setFont(font);
        this.mDebugPackageFilePath = new FileFieldEditor("Test", "Debug Package File Path", this.mDebugPackageComp);
        String[] ext = new String[]{".zip"};
        this.mDebugPackageFilePath.setFileExtensions(ext);
        this.mDebugPackageFilePath.setPropertyChangeListener((IPropertyChangeListener)this);
        this.calculatePackageFilePathEnabled();
    }

    void calculatePackageFilePathEnabled() {
        this.mDebugPackageFilePath.setEnabled(this.fCreatePkgCheckBox.getSelection(), this.mDebugPackageComp);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.fProjectAndFileBlock.initializeFrom(config);
        this.updateParamsFromConfig(config);
        this.updateDebugPackageFromConfig(config);
        String val = EMPTY_STRING;
        try {
            val = config.getAttribute("ATTR_REMOTE_PORT", EMPTY_STRING);
        }
        catch (CoreException ce) {
            PerlDebugPlugin.log(ce);
        }
        this.fPortText.setText(val);
        val = EMPTY_STRING;
        try {
            val = config.getAttribute("ATTR_REMOTE_HOST", EMPTY_STRING);
        }
        catch (CoreException ce) {
            PerlDebugPlugin.log(ce);
        }
        this.fHostText.setText(val);
        val = EMPTY_STRING;
        try {
            val = config.getAttribute("ATTR_REMOTE_DEST", EMPTY_STRING);
        }
        catch (CoreException ce) {
            PerlDebugPlugin.log(ce);
        }
        this.fDestText.setText(val);
        this.calculatePackageFilePathEnabled();
    }

    protected void updateDebugPackageFromConfig(ILaunchConfiguration config) {
        String path = EMPTY_STRING;
        boolean create = true;
        boolean capture = true;
        try {
            path = config.getAttribute("ATTR_REMOTE_DEBUG_PACKAGE_PATH", EMPTY_STRING);
            create = config.getAttribute("ATTR_REMOTE_CREATE_DEBUG_PACKAGE", true);
            capture = config.getAttribute("ATTR_REMOTE_CAPTURE_OUTPUT", true);
        }
        catch (CoreException ce) {
            PerlDebugPlugin.log(ce);
        }
        this.mDebugPackageFilePath.setStringValue(path);
        this.fCreatePkgCheckBox.setSelection(create);
        this.fCaptureOutCheckBox.setSelection(capture);
    }

    protected void updateParamsFromConfig(ILaunchConfiguration config) {
        String params = EMPTY_STRING;
        try {
            params = config.getAttribute("ATTR_PROGRAM_PARAMETERS", EMPTY_STRING);
        }
        catch (CoreException ce) {
            PerlDebugPlugin.log(ce);
        }
        this.fHostText.setText(params);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        this.fProjectAndFileBlock.performApply(config);
        config.setAttribute("ATTR_REMOTE_HOST", this.fHostText.getText());
        config.setAttribute("ATTR_REMOTE_DEST", this.fDestText.getText());
        config.setAttribute("ATTR_REMOTE_PORT", this.fPortText.getText());
        config.setAttribute("ATTR_REMOTE_DEBUG_PACKAGE_PATH", this.mDebugPackageFilePath.getStringValue());
        config.setAttribute("ATTR_REMOTE_CREATE_DEBUG_PACKAGE", this.fCreatePkgCheckBox.getSelection());
        config.setAttribute("ATTR_REMOTE_CAPTURE_OUTPUT", this.fCaptureOutCheckBox.getSelection());
    }

    public void dispose() {
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!this.fProjectAndFileBlock.isValid(config)) {
            return false;
        }
        String name = this.fPortText.getText().trim();
        int port = -1;
        try {
            port = Integer.parseInt(name);
        }
        catch (Exception exception) {}
        if (name.length() == 0 || port < 0) {
            this.setErrorMessage("Port is not valid");
            return false;
        }
        name = this.fDestText.getText().trim();
        if (name.length() == 0) {
            this.setErrorMessage("Target Host Project Installation Path is not specified");
            return false;
        }
        name = this.fHostText.getText().trim();
        if (name.length() == 0) {
            this.setErrorMessage("Local Host is not specified");
            return false;
        }
        if (this.fCreatePkgCheckBox.getSelection()) {
            name = this.mDebugPackageFilePath.getStringValue();
            if (name == null) {
                this.setErrorMessage("Debug Package File Path missing");
            } else {
                Path path = new Path(name);
                File file = path.removeLastSegments(1).toFile();
                if (!path.isValidPath(name) || path.segmentCount() == 0 || !file.exists()) {
                    this.setErrorMessage("Debug Package File Path invalid");
                }
            }
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        String host = null;
        try {
            host = InetAddress.getLocalHost().getHostAddress().toString();
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        this.fProjectAndFileBlock.setDefaults(config);
        config.setAttribute("ATTR_PROGRAM_PARAMETERS", EMPTY_STRING);
        config.setAttribute("ATTR_REMOTE_HOST", host);
        config.setAttribute("ATTR_REMOTE_PORT", Integer.toString(RemotePort.findFreePort()));
        config.setAttribute("ATTR_REMOTE_CREATE_DEBUG_PACKAGE", true);
        config.setAttribute("ATTR_REMOTE_DEBUG_PACKAGE_PATH", EMPTY_STRING);
        config.setAttribute("ATTR_REMOTE", "REMOTE");
    }

    public String getName() {
        return "Configuration";
    }

    public Image getImage() {
        return PerlDebugPlugin.getDefaultDesciptorImageRegistry().get(PerlDebugImages.DESC_OBJS_LaunchTabRemote);
    }

    private String[] getPerlProjects() {
        ArrayList<String> projectList = new ArrayList<String>();
        IWorkspaceRoot workspaceRoot = PerlDebugPlugin.getWorkspace().getRoot();
        IProject[] projects = workspaceRoot.getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            try {
                if (project.isAccessible() && project.hasNature(PERL_NATURE_ID)) {
                    projectList.add(project.getName());
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return projectList.toArray(new String[projectList.size()]);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String path = this.mDebugPackageFilePath.getStringValue();
        if (path.length() >= 1 && !path.endsWith(".zip")) {
            this.mDebugPackageFilePath.setStringValue(String.valueOf(path) + ".zip");
        }
        this.updateLaunchConfigurationDialog();
    }

    class PerlProjectVisitor
    implements IResourceVisitor {
        private static final String PERL_EDITOR_ID = "org.epic.perleditor.editors.PerlEditor";
        private static final String EMB_PERL_FILE_EXTENSION = "epl";
        private List fileList = new ArrayList();

        PerlProjectVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            IEditorDescriptor defaultEditorDescriptor = PerlDebugPlugin.getDefault().getWorkbench().getEditorRegistry().getDefaultEditor(resource.getFullPath().toString());
            if (defaultEditorDescriptor == null) {
                return true;
            }
            if (defaultEditorDescriptor.getId().equals(PERL_EDITOR_ID) && !resource.getFileExtension().equals(EMB_PERL_FILE_EXTENSION)) {
                this.fileList.add(resource.getFullPath().removeFirstSegments(1).toString());
            }
            return true;
        }

        public String[] getList() {
            return this.fileList.toArray(new String[this.fileList.size()]);
        }
    }
}

