/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.ui.action;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.epic.debug.DebugTarget;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.db.StackFrame;
import org.epic.debug.ui.action.HighlightVarUpdatesActionDelegate;
import org.epic.debug.ui.action.ShowGlobalVariableActionDelegate;
import org.epic.debug.ui.action.ShowLocalVariableActionDelegate;
import org.epic.debug.ui.action.ShowPerlInternalVariableActionDelegate;
import org.epic.debug.ui.action.ShowVarAddressActionDelegate;
import org.epic.perleditor.PerlEditorPlugin;

public abstract class VariablesViewActionDelegate
implements IViewActionDelegate,
IActionDelegate2 {
    private static Map actionIdToPreferenceKey;

    public static synchronized void enableVariablesViewActions() {
        VariablesViewActionDelegate.initActionIdToPreferenceKey();
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] window = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < window.length) {
            IWorkbenchPage page = window[i].getActivePage();
            IViewPart variablesView = page.findView("org.eclipse.debug.ui.VariableView");
            if (variablesView != null) {
                Display.getDefault().asyncExec((Runnable)new EnableVariablesViewActions(variablesView));
            }
            ++i;
        }
    }

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(final IAction action) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                action.setChecked(VariablesViewActionDelegate.getPreferenceValue(VariablesViewActionDelegate.this.getPreferenceKey()));
            }
        });
    }

    public void runWithEvent(IAction action, Event event) {
        VariablesViewActionDelegate.getPreferenceStore().setValue(this.getPreferenceKey(), action.isChecked());
        this.updateVariablesView();
    }

    protected abstract String getPreferenceKey();

    protected static final boolean getPreferenceValue(String key) {
        return VariablesViewActionDelegate.getPreferenceStore().getBoolean(key);
    }

    protected final void updateVariablesView() {
        IDebugTarget[] targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
        int i = 0;
        while (i < targets.length) {
            if (targets[i] instanceof DebugTarget) {
                DebugTarget target = (DebugTarget)targets[i];
                try {
                    IThread[] threads = target.getThreads();
                    IStackFrame[] frames = threads[0].getStackFrames();
                    int j = 0;
                    while (j < frames.length) {
                        ((StackFrame)frames[j]).discardCachedVars();
                        ++j;
                    }
                }
                catch (DebugException e) {
                    PerlDebugPlugin.log(e);
                }
            }
            ++i;
        }
    }

    private static IPreferenceStore getPreferenceStore() {
        return PerlEditorPlugin.getDefault().getPreferenceStore();
    }

    private static void initActionIdToPreferenceKey() {
        if (actionIdToPreferenceKey != null) {
            return;
        }
        actionIdToPreferenceKey = new HashMap();
        actionIdToPreferenceKey.put(HighlightVarUpdatesActionDelegate.ACTION_ID, HighlightVarUpdatesActionDelegate.KEY);
        actionIdToPreferenceKey.put(ShowGlobalVariableActionDelegate.ACTION_ID, ShowGlobalVariableActionDelegate.KEY);
        actionIdToPreferenceKey.put(ShowLocalVariableActionDelegate.ACTION_ID, ShowLocalVariableActionDelegate.KEY);
        actionIdToPreferenceKey.put(ShowPerlInternalVariableActionDelegate.ACTION_ID, ShowPerlInternalVariableActionDelegate.KEY);
        actionIdToPreferenceKey.put(ShowVarAddressActionDelegate.ACTION_ID, ShowVarAddressActionDelegate.KEY);
    }

    private static class EnableVariablesViewActions
    implements Runnable {
        private final IViewPart variablesView;

        public EnableVariablesViewActions(IViewPart variablesView) {
            this.variablesView = variablesView;
        }

        public void run() {
            IContributionItem[] item = this.variablesView.getViewSite().getActionBars().getMenuManager().getItems();
            int i = 0;
            while (i < item.length) {
                IAction action;
                String prefKey = (String)actionIdToPreferenceKey.get(item[i].getId());
                if (prefKey != null && item[i] instanceof ActionContributionItem && (action = ((ActionContributionItem)item[i]).getAction()) != null) {
                    action.setEnabled(true);
                    action.setChecked(VariablesViewActionDelegate.getPreferenceValue(prefKey));
                }
                ++i;
            }
        }
    }
}

