/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.util;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.epic.core.util.ProcessExecutor;
import org.epic.core.util.ProcessOutput;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.util.AbstractPathMapper;

public class CygwinPathMapper
extends AbstractPathMapper {
    public CygwinPathMapper() throws CoreException {
        try {
            ProcessExecutor executor = new ProcessExecutor();
            ProcessOutput output = executor.execute(new String[]{"mount"}, "", new File("."));
            this.initMappings(output.stdout.replaceAll("\n", "\r\n"));
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "Could not execute 'mount' to find out path mappings.\nAdd Cygwin's 'bin' directory (which contains mount.exe) to your PATH.", (Throwable)e));
        }
    }

    private void initMappings(String mountOutput) throws CoreException {
        Pattern p = Pattern.compile("^(.+)\\s+on\\s+(/.*) type", 8);
        Matcher m = p.matcher(mountOutput);
        while (m.find()) {
            String epicPath = m.group(1);
            String dbPath = m.group(2);
            if (epicPath.length() == 2 && epicPath.charAt(1) == ':') {
                epicPath = String.valueOf(epicPath.toUpperCase()) + "/";
            }
            this.addMapping((IPath)new Path(epicPath), (IPath)new Path(dbPath));
        }
    }
}

