/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.ITerminate;

public class DebuggerProxy2
extends PlatformObject
implements IProcess,
ITerminate,
IStreamsProxy {
    private final ILaunch launch;
    private boolean terminated;
    private DebugOutProxy debugOut;
    private DebugInProxy debugIn;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DebuggerProxy2(BufferedReader debugIn, PrintWriter debugOut, ILaunch launch) {
        this.launch = launch;
        this.debugIn = new DebugInProxy(debugIn);
        this.debugOut = new DebugOutProxy(debugOut);
        this.fireCreationEvent();
    }

    public PrintWriter getDebugOut() {
        return this.debugOut;
    }

    public BufferedReader getDebugIn() {
        return this.debugIn;
    }

    public String getLabel() {
        return "perl -d";
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IStreamsProxy getStreamsProxy() {
        return this;
    }

    public void setAttribute(String key, String value) {
        this.launch.setAttribute(key, value);
    }

    public String getAttribute(String key) {
        return this.launch.getAttribute(key);
    }

    public int getExitValue() throws DebugException {
        return 0;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IProcess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz2)) {
            ILaunch launch = this.getLaunch();
            IDebugTarget[] targets = launch.getDebugTargets();
            int i = 0;
            while (i < targets.length) {
                if (((Object)((Object)this)).equals(targets[i].getProcess())) {
                    return targets[i];
                }
                ++i;
            }
            return null;
        }
        return super.getAdapter(adapter);
    }

    public boolean canTerminate() {
        return true;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void terminate() throws DebugException {
        this.fireTerminateEvent();
        this.terminated = true;
    }

    public IStreamMonitor getErrorStreamMonitor() {
        return this.debugOut.getStreamMonitor();
    }

    public IStreamMonitor getOutputStreamMonitor() {
        return this.debugIn.getStreamMonitor();
    }

    public void write(String input) throws IOException {
    }

    private void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    private void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    private void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    private static class DebugOutProxy
    extends PrintWriter {
        private static final String NL = System.getProperty("line.separator");
        public final IStreamMonitor monitor = new IStreamMonitor(this){
            final /* synthetic */ DebugOutProxy this$1;
            {
                this.this$1 = debugOutProxy;
            }

            public void addListener(IStreamListener listener) {
                this.this$1.addListener(listener);
            }

            public String getContents() {
                return this.this$1.getContents();
            }

            public void removeListener(IStreamListener listener) {
                this.this$1.removeListener(listener);
            }
        };
        private Set listeners;
        private final PrintWriter w;
        private final StringWriter buf;
        private final PrintWriter bw;

        public DebugOutProxy(PrintWriter w) {
            super((Writer)w, true);
            this.w = w;
            this.listeners = new HashSet();
            this.buf = new StringWriter();
            this.bw = new PrintWriter(this.buf);
        }

        public void print(boolean b) {
            this.bw.print(b);
            this.w.print(b);
            this.fireAppended(String.valueOf(b));
        }

        public void print(char c) {
            this.bw.print(c);
            this.w.print(c);
            this.fireAppended(String.valueOf(c));
        }

        public void print(char[] s) {
            this.bw.print(s);
            this.w.print(s);
            this.fireAppended(new String(s));
        }

        public void print(double d) {
            this.bw.print(d);
            this.w.print(d);
            this.fireAppended(String.valueOf(d));
        }

        public void print(float f) {
            this.bw.print(f);
            this.w.print(f);
            this.fireAppended(String.valueOf(f));
        }

        public void print(int i) {
            this.bw.print(i);
            this.w.print(i);
            this.fireAppended(String.valueOf(i));
        }

        public void print(long l) {
            this.bw.print(l);
            this.w.print(l);
            this.fireAppended(String.valueOf(l));
        }

        public void print(Object obj) {
            this.bw.print(obj);
            this.w.print(obj);
            this.fireAppended(String.valueOf(obj));
        }

        public void print(String s) {
            this.bw.print(s);
            this.w.print(s);
            this.fireAppended(s);
        }

        public void println() {
            this.bw.println();
            this.w.println();
            this.fireAppended(NL);
        }

        public void println(boolean x) {
            this.print(x);
            this.println();
        }

        public void println(char x) {
            this.print(x);
            this.println();
        }

        public void println(char[] x) {
            this.print(x);
            this.println();
        }

        public void println(double x) {
            this.print(x);
            this.println();
        }

        public void println(float x) {
            this.print(x);
            this.println();
        }

        public void println(int x) {
            this.print(x);
            this.println();
        }

        public void println(long x) {
            this.print(x);
            this.println();
        }

        public void println(Object x) {
            this.print(x);
            this.println();
        }

        public void println(String x) {
            this.print(x);
            this.println();
        }

        public void write(char[] buf) {
            this.bw.write(buf);
            this.w.write(buf);
            this.fireAppended(new String(buf));
        }

        public void write(char[] buf, int off, int len) {
            this.bw.write(buf, off, len);
            this.w.write(buf, off, len);
            this.fireAppended(new String(buf, off, len));
        }

        public void write(int c) {
            this.bw.write(c);
            this.w.write(c);
            this.fireAppended(String.valueOf(c));
        }

        public void write(String s) {
            this.bw.write(s);
            this.w.write(s);
            this.fireAppended(s);
        }

        public void write(String s, int off, int len) {
            this.bw.write(s, off, len);
            this.w.write(s, off, len);
            this.fireAppended(s.substring(off, off + len));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(IStreamListener listener) {
            Set set = this.listeners;
            synchronized (set) {
                this.listeners.add(listener);
            }
        }

        public String getContents() {
            return this.buf.toString();
        }

        public IStreamMonitor getStreamMonitor() {
            return this.monitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(IStreamListener listener) {
            Set set = this.listeners;
            synchronized (set) {
                this.listeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireAppended(String text) {
            Set set = this.listeners;
            synchronized (set) {
                Iterator i = this.listeners.iterator();
                while (i.hasNext()) {
                    IStreamListener listener = (IStreamListener)i.next();
                    listener.streamAppended(text, this.monitor);
                }
            }
        }
    }

    private static class DebugInProxy
    extends BufferedReader
    implements IStreamMonitor {
        private static final String NL = System.getProperty("line.separator");
        private Set listeners;
        private StringBuffer buf = new StringBuffer();

        public DebugInProxy(Reader in) {
            super(in);
            this.listeners = new HashSet();
        }

        public int read() throws IOException {
            int ret = super.read();
            if (ret >= 0) {
                this.buf.append((char)ret);
                this.fireAppended(String.valueOf((char)ret));
            }
            return ret;
        }

        public int read(char[] cbuf) throws IOException {
            return this.read(cbuf, 0, cbuf.length);
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int ret = super.read(cbuf, off, len);
            if (ret > 0) {
                String str = new String(cbuf, off, ret);
                this.buf.append(str);
                this.fireAppended(str);
            }
            return ret;
        }

        public String readLine() throws IOException {
            String ret = super.readLine();
            if (ret != null) {
                this.buf.append(ret);
                this.buf.append(NL);
                this.fireAppended(ret);
                this.fireAppended(NL);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(IStreamListener listener) {
            Set set = this.listeners;
            synchronized (set) {
                this.listeners.add(listener);
            }
        }

        public String getContents() {
            return this.buf.toString();
        }

        public IStreamMonitor getStreamMonitor() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(IStreamListener listener) {
            Set set = this.listeners;
            synchronized (set) {
                this.listeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireAppended(String text) {
            Set set = this.listeners;
            synchronized (set) {
                Iterator i = this.listeners.iterator();
                while (i.hasNext()) {
                    IStreamListener listener = (IStreamListener)i.next();
                    listener.streamAppended(text, (IStreamMonitor)this);
                }
            }
        }
    }
}

