/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.epic.core.PerlCore;
import org.epic.debug.db.DebuggerInterface;
import org.epic.debug.util.AbstractPathMapper;

public class RemotePathMapper
extends AbstractPathMapper {
    private static final IPathChecker localPathChecker = new IPathChecker(){

        public boolean fileExists(IPath path) {
            return path.toFile().exists();
        }
    };
    private final String remoteProjectDir;
    private final List epicInc;
    private List debuggerInc;

    public RemotePathMapper(IProject project, String remoteProjectDir) throws CoreException {
        this.remoteProjectDir = remoteProjectDir;
        this.epicInc = this.convertFilesToPaths(PerlCore.create((IProject)project).getEffectiveIncPath());
        this.addMapping(project.getLocation(), (IPath)new Path(remoteProjectDir));
    }

    public IPath getDebuggerPath(IPath epicPath, DebuggerInterface db) {
        IPath ret = super.getDebuggerPath(epicPath, db);
        if (ret != null) {
            return ret;
        }
        IPath convertedPath = this.convertPath(epicPath, this.epicInc, this.debuggerInc, new RemotePathChecker(db));
        if (convertedPath != null) {
            this.addMapping(epicPath, convertedPath);
        }
        return convertedPath;
    }

    public IPath getEpicPath(IPath dbPath) {
        IPath ret = super.getEpicPath(dbPath);
        if (ret != null) {
            return ret;
        }
        return this.convertPath(dbPath, this.debuggerInc, this.epicInc, localPathChecker);
    }

    public boolean requiresEffectiveIncPath() {
        return true;
    }

    public void setEffectiveIncPath(List inc) {
        this.debuggerInc = inc;
    }

    private List convertFilesToPaths(List files) {
        ArrayList<IPath> paths = new ArrayList<IPath>(files.size());
        Iterator i = files.iterator();
        while (i.hasNext()) {
            File file = (File)i.next();
            paths.add(Path.fromOSString((String)file.getAbsolutePath()));
        }
        return paths;
    }

    private IPath convertPath(IPath path, List sourceIncDirs, List targetIncDirs, IPathChecker checker) {
        IPath relativePath = this.makeRelative(path, sourceIncDirs);
        if (relativePath == null) {
            return null;
        }
        Iterator i = targetIncDirs.iterator();
        while (i.hasNext()) {
            IPath incDir = (IPath)i.next();
            IPath convertedPath = incDir.append(relativePath);
            if (!checker.fileExists(convertedPath)) continue;
            return convertedPath;
        }
        return null;
    }

    private IPath makeRelative(IPath dbPath, List incDirs) {
        Iterator i = incDirs.iterator();
        while (i.hasNext()) {
            IPath incDir = (IPath)i.next();
            if (!incDir.isPrefixOf(dbPath)) continue;
            return dbPath.removeFirstSegments(incDir.segmentCount());
        }
        return null;
    }

    public void addLinkedFolderMapping(IFolder folder) {
        this.addMapping(folder.getLocation(), (IPath)new Path(String.valueOf(this.remoteProjectDir) + "/" + folder.getProjectRelativePath().toString()));
    }

    private static interface IPathChecker {
        public boolean fileExists(IPath var1);
    }

    private static class RemotePathChecker
    implements IPathChecker {
        private final DebuggerInterface db;

        public RemotePathChecker(DebuggerInterface db) {
            this.db = db;
        }

        public boolean fileExists(IPath path) {
            try {
                return this.db.fileExists(path);
            }
            catch (IOException iOException) {
                return false;
            }
        }
    }
}

