/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.epic.debug.PerlDebugPlugin;

public class RemotePort {
    private static final int DEFAULT_LOW_PORT = 5000;
    private static final int DEFAULT_HIGH_PORT = 10000;
    public static final int WAIT_OK = 1;
    public static final int WAIT_TERMINATE = 2;
    public static final int WAIT_ERROR = 3;
    private ServerSocket mServer;
    private Socket mClient;
    private PrintWriter mWriter;
    private BufferedReader mReader;
    private OutputStream mOutStream;
    private InputStream mInStream;
    private String name;
    private int lastUsedPort;
    private Thread mConnectionThread;
    private volatile boolean mStop;
    private final int mStartPortSearch;
    private final int mEndPortSearch;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.epic.debug.util.RemotePort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public RemotePort(String name, int startPortSearch, int endPortSearch) {
        this.name = name;
        this.mStartPortSearch = startPortSearch;
        this.mEndPortSearch = endPortSearch;
    }

    public RemotePort(String name) {
        this(name, 5000, 10000);
    }

    public static int findFreePort() {
        boolean found = false;
        ServerSocket s = null;
        int i = 5000;
        while (i <= 10000 && !found) {
            try {
                s = new ServerSocket(i);
                found = true;
            }
            catch (IOException iOException) {}
            ++i;
        }
        if (!found) {
            PerlDebugPlugin.log(new Exception("Couldn't not listen on server port: no free port available?"));
            return -1;
        }
        int port = s.getLocalPort();
        try {
            s.close();
        }
        catch (IOException e) {
            PerlDebugPlugin.log(e);
        }
        return port;
    }

    public InputStream getInStream() {
        if (!$assertionsDisabled && !this.isConnected()) {
            throw new AssertionError();
        }
        if (this.mInStream == null) {
            try {
                this.mInStream = this.mClient.getInputStream();
            }
            catch (IOException e) {
                PerlDebugPlugin.log(e);
            }
        }
        return this.mInStream;
    }

    public OutputStream getOutStream() {
        if (!$assertionsDisabled && !this.isConnected()) {
            throw new AssertionError();
        }
        if (this.mOutStream == null) {
            try {
                this.mOutStream = new BufferedOutputStream(this.mClient.getOutputStream());
            }
            catch (IOException e) {
                PerlDebugPlugin.log(e);
            }
        }
        return this.mOutStream;
    }

    public BufferedReader getReadStream() {
        if (!$assertionsDisabled && !this.isConnected()) {
            throw new AssertionError();
        }
        if (this.mReader == null) {
            this.createReader();
        }
        return this.mReader;
    }

    public int getServerPort() {
        return this.mServer.getLocalPort();
    }

    public PrintWriter getWriteStream() {
        if (!this.isConnected()) {
            return null;
        }
        if (this.mWriter == null) {
            this.mWriter = new PrintWriter(this.getOutStream(), false);
        }
        return this.mWriter;
    }

    public boolean isConnected() {
        return this.mClient != null;
    }

    public void shutdown() {
        this.mServer = null;
        this.reset();
        this.mStop = true;
    }

    public boolean startConnect() {
        return this.startConnect(false);
    }

    public boolean startReconnect() {
        return this.startConnect(true);
    }

    public int waitForConnect(boolean fTimeOut) {
        return this.waitForConnect(fTimeOut, true);
    }

    public int waitForConnect(boolean fTimeOut, boolean shutdownOnTimeout) {
        block7: {
            this.mServer.getLocalPort();
            int x = 0;
            while (!(x >= 100 && fTimeOut || this.mClient != null)) {
                if (this.mStop) break;
                Thread.sleep(100L);
                ++x;
            }
            if (this.mClient != null) break block7;
            if (shutdownOnTimeout) {
                this.shutdown();
            }
            if (this.mStop) {
                return 2;
            }
            return 3;
        }
        try {
            this.mWriter = new PrintWriter(this.mClient.getOutputStream(), true);
            this.mReader = this.createReader();
        }
        catch (IOException e) {
            PerlDebugPlugin.log(e);
            return 3;
        }
        catch (InterruptedException e) {
            PerlDebugPlugin.log(e);
            return 3;
        }
        return 1;
    }

    private BufferedReader createReader() {
        try {
            return new BufferedReader(new InputStreamReader(this.getInStream(), "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            PerlDebugPlugin.log(e);
            return new BufferedReader(new InputStreamReader(this.getInStream()));
        }
    }

    private void reset() {
        if (this.mReader != null) {
            try {
                this.mReader.close();
            }
            catch (IOException e) {
                PerlDebugPlugin.log(e);
            }
            this.mReader = null;
        }
        if (this.mWriter != null) {
            this.mWriter.close();
            this.mWriter = null;
        }
        if (this.mClient != null) {
            try {
                this.mClient.close();
            }
            catch (IOException e) {
                PerlDebugPlugin.log(e);
            }
            this.mClient = null;
        }
        this.mStop = false;
        this.mInStream = null;
        this.mOutStream = null;
        if (this.mConnectionThread != null) {
            this.mConnectionThread.interrupt();
            this.mConnectionThread = null;
        }
    }

    private boolean startConnect(boolean fReconnect) {
        boolean found;
        if (fReconnect) {
            this.reset();
            if (!$assertionsDisabled && this.mServer == null) {
                throw new AssertionError();
            }
            found = true;
        } else {
            this.reset();
            found = false;
            int i = this.mStartPortSearch;
            while (i <= this.mEndPortSearch && !found) {
                try {
                    this.mServer = new ServerSocket(i);
                    this.mServer.setSoTimeout(5000);
                    this.lastUsedPort = i;
                    found = true;
                }
                catch (IOException iOException) {}
                ++i;
            }
        }
        if (!found) {
            PerlDebugPlugin.log(new Exception("Couldn't not listen on server port: no free port available?"));
            return false;
        }
        this.mClient = null;
        this.mConnectionThread = new Thread("EPIC-Debugger:RemotePort.startConnect"){

            public void run() {
                try {
                    ServerSocket server = RemotePort.this.mServer;
                    while (server != null && !this.isInterrupted()) {
                        try {
                            RemotePort.this.mClient = server.accept();
                        }
                        catch (SocketTimeoutException socketTimeoutException) {}
                    }
                    if (RemotePort.this.mServer == null) {
                        server.close();
                    }
                }
                catch (IOException e) {
                    PerlDebugPlugin.log(e);
                }
            }
        };
        this.mConnectionThread.start();
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("RemotePort[");
        buf.append(this.name);
        if (this.mServer != null) {
            buf.append(':');
            buf.append(this.mServer.getLocalPort());
        }
        buf.append(']');
        return buf.toString();
    }
}

