/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.nodes;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Paint;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class PLens
extends PNode {
    public static double LENS_DRAGBAR_HEIGHT = 20.0;
    public static Paint DEFAULT_DRAGBAR_PAINT = Color.DARK_GRAY;
    public static Paint DEFAULT_LENS_PAINT = Color.LIGHT_GRAY;
    private PPath dragBar = PPath.createRectangle(0.0f, 0.0f, 100.0f, 100.0f);
    private PCamera camera;
    private PDragEventHandler lensDragger;

    public PLens() {
        this.dragBar.setPaint(DEFAULT_DRAGBAR_PAINT);
        this.dragBar.setPickable(false);
        this.addChild(this.dragBar);
        this.camera = new PCamera();
        this.camera.setPaint(DEFAULT_LENS_PAINT);
        this.addChild(this.camera);
        this.lensDragger = new PDragEventHandler();
        this.lensDragger.getEventFilter().setMarksAcceptedEventsAsHandled(true);
        this.addInputEventListener(this.lensDragger);
        this.addPropertyChangeListener("transform", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                PLens.this.camera.setViewTransform(PLens.this.getInverseTransform());
            }
        });
    }

    public PLens(PLayer layer) {
        this();
        this.addLayer(0, layer);
    }

    public PCamera getCamera() {
        return this.camera;
    }

    public PPath getDragBar() {
        return this.dragBar;
    }

    public PDragEventHandler getLensDraggerHandler() {
        return this.lensDragger;
    }

    public void addLayer(int index, PLayer layer) {
        this.camera.addLayer(index, layer);
    }

    public void removeLayer(PLayer layer) {
        this.camera.removeLayer(layer);
    }

    protected void layoutChildren() {
        this.dragBar.setPathToRectangle((float)this.getX(), (float)this.getY(), (float)this.getWidth(), (float)LENS_DRAGBAR_HEIGHT);
        this.camera.setBounds(this.getX(), this.getY() + LENS_DRAGBAR_HEIGHT, this.getWidth(), this.getHeight() - LENS_DRAGBAR_HEIGHT);
    }
}

