/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.compare;

import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PyPartitionScanner;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.IPySyntaxHighlightingAndCodeCompletionEditor;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.PyEditConfiguration;
import org.python.pydev.editor.PyEditConfigurationWithoutEditor;
import org.python.pydev.editor.actions.PyBackspace;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.ui.ColorCache;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyMergeViewer
extends TextMergeViewer {
    private List<ColorCache> colorCache;
    private List<Preferences.IPropertyChangeListener> prefChangeListeners;

    public PyMergeViewer(Composite parent, int style, CompareConfiguration configuration) {
        super(parent, style | 0x2000000, configuration);
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return PyPartitionScanner.createPyPartitioner();
    }

    protected String getDocumentPartitioning() {
        return "__PYTHON_PARTITION_TYPE";
    }

    private IPythonNature getPythonNature(Object compareInput) {
        IResource resource = this.getResource(compareInput);
        if (resource != null) {
            return PythonNature.getPythonNature(resource);
        }
        return null;
    }

    private IResource getResource(Object compareInput) {
        if (!(compareInput instanceof ICompareInput)) {
            return null;
        }
        ICompareInput input = (ICompareInput)compareInput;
        if (input == null) {
            // empty if block
        }
        IResourceProvider rp = null;
        ITypedElement te = input.getLeft();
        if (te instanceof IResourceProvider) {
            rp = (IResourceProvider)te;
        }
        if (rp == null && (te = input.getRight()) instanceof IResourceProvider) {
            rp = (IResourceProvider)te;
        }
        if (rp == null && (te = input.getAncestor()) instanceof IResourceProvider) {
            rp = (IResourceProvider)te;
        }
        if (rp != null) {
            return rp.getResource();
        }
        return null;
    }

    protected SourceViewer createSourceViewer(Composite parent, int textOrientation) {
        SourceViewer viewer = super.createSourceViewer(parent, textOrientation);
        viewer.appendVerifyKeyListener(PyBackspace.createVerifyKeyListener(viewer, null));
        return viewer;
    }

    private List<ColorCache> getColorCache() {
        if (this.colorCache == null) {
            this.colorCache = new ArrayList<ColorCache>();
        }
        return this.colorCache;
    }

    public List<Preferences.IPropertyChangeListener> getPrefChangeListeners() {
        if (this.prefChangeListeners == null) {
            this.prefChangeListeners = new ArrayList<Preferences.IPropertyChangeListener>();
        }
        return this.prefChangeListeners;
    }

    protected void configureTextViewer(TextViewer textViewer) {
        if (!(textViewer instanceof SourceViewer)) {
            return;
        }
        final SourceViewer sourceViewer = (SourceViewer)textViewer;
        final DefaultIndentPrefs indentPrefs = new DefaultIndentPrefs();
        final WeakReference[] sourceViewerConfigurationObj = new WeakReference[1];
        final ColorCache c = new ColorCache(PydevPrefs.getChainedPrefStore());
        this.getColorCache().add(c);
        IPySyntaxHighlightingAndCodeCompletionEditor editor = new IPySyntaxHighlightingAndCodeCompletionEditor(){

            public void resetForceTabs() {
            }

            public IIndentPrefs getIndentPrefs() {
                return indentPrefs;
            }

            public ISourceViewer getEditorSourceViewer() {
                return sourceViewer;
            }

            public PyEditConfigurationWithoutEditor getEditConfiguration() {
                return (PyEditConfigurationWithoutEditor)((Object)sourceViewerConfigurationObj[0].get());
            }

            public ColorCache getColorCache() {
                return c;
            }

            public PySelection createPySelection() {
                ISelection selection = sourceViewer.getSelection();
                if (selection instanceof ITextSelection) {
                    return new PySelection(sourceViewer.getDocument(), (ITextSelection)selection);
                }
                return null;
            }

            public File getEditorFile() {
                IResource file = PyMergeViewer.this.getResource(PyMergeViewer.this.getInput());
                if (file != null && file instanceof IFile) {
                    IPath path = file.getLocation().makeAbsolute();
                    return path.toFile();
                }
                return null;
            }

            public IPythonNature getPythonNature() throws MisconfigurationException {
                return PyMergeViewer.this.getPythonNature(PyMergeViewer.this.getInput());
            }

            public Object getAdapter(Class adapter) {
                IResource resource;
                if (adapter == ClassLiteral.getClass((String)"org/eclipse/core/resources/IResource")) {
                    return PyMergeViewer.this.getResource(PyMergeViewer.this.getInput());
                }
                if (adapter == ClassLiteral.getClass((String)"org/eclipse/core/resources/IFile") && (resource = PyMergeViewer.this.getResource(PyMergeViewer.this.getInput())) instanceof IFile) {
                    return resource;
                }
                return null;
            }
        };
        PyEditConfiguration sourceViewerConfiguration = new PyEditConfiguration(c, editor, PydevPrefs.getChainedPrefStore());
        sourceViewerConfigurationObj[0] = new WeakReference<PyEditConfiguration>(sourceViewerConfiguration);
        sourceViewer.configure((SourceViewerConfiguration)sourceViewerConfiguration);
        Preferences.IPropertyChangeListener prefChangeListener = PyEdit.createPrefChangeListener(editor);
        this.getPrefChangeListeners().add(prefChangeListener);
        PydevPrefs.getPreferences().addPropertyChangeListener(prefChangeListener);
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        List<ColorCache> colorCache = this.getColorCache();
        for (ColorCache c : colorCache) {
            c.dispose();
        }
        colorCache.clear();
        List<Preferences.IPropertyChangeListener> prefChangeListeners = this.getPrefChangeListeners();
        for (Preferences.IPropertyChangeListener l : prefChangeListeners) {
            PydevPrefs.getPreferences().removePropertyChangeListener(l);
        }
        prefChangeListeners.clear();
    }
}

