/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import com.rc.retroweaver.runtime.Autobox;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.ICompletionRequest;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.Tuple3;
import org.python.pydev.core.TupleN;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.codecompletion.revisited.AssignAnalysis;
import org.python.pydev.editor.codecompletion.revisited.AssignCompletionInfo;
import org.python.pydev.editor.codecompletion.revisited.CompletionCache;
import org.python.pydev.editor.codecompletion.revisited.CompletionParticipantsHelper;
import org.python.pydev.editor.codecompletion.revisited.CompletionState;
import org.python.pydev.editor.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.editor.codecompletion.revisited.ConcreteToken;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.codecompletion.revisited.visitors.GlobalModelVisitor;
import org.python.pydev.logging.DebugSettings;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.visitors.NodeUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractASTManager
implements ICodeCompletionASTManager,
Serializable {
    protected static final long serialVersionUID = 10L;
    private static final IToken[] EMPTY_ITOKEN_ARRAY = new IToken[0];
    private static final boolean DEBUG_CACHE = false;
    private transient AssignAnalysis assignAnalysis;
    private transient Object lock;
    public volatile IModulesManager modulesManager;

    public abstract void setProject(IProject var1, IPythonNature var2, boolean var3);

    public abstract void rebuildModule(File var1, IDocument var2, IProject var3, IProgressMonitor var4, IPythonNature var5);

    public abstract void removeModule(File var1, IProject var2, IProgressMonitor var3);

    public synchronized Object getLock() {
        if (this.lock == null) {
            this.lock = new Object();
        }
        return this.lock;
    }

    public AssignAnalysis getAssignAnalysis() {
        if (this.assignAnalysis == null) {
            this.assignAnalysis = new AssignAnalysis();
        }
        return this.assignAnalysis;
    }

    public IModulesManager getModulesManager() {
        return this.modulesManager;
    }

    public void setNature(IPythonNature nature) {
        this.getModulesManager().setPythonNature(nature);
    }

    public IPythonNature getNature() {
        return this.getModulesManager().getNature();
    }

    public IToken[] getCompletionsForImport(ICodeCompletionASTManager.ImportInfo importInfo, ICompletionRequest r, boolean onlyGetDirectModules) throws CompletionRecursionException {
        String original = importInfo.importsTipperStr;
        String afterDots = null;
        int level = 0;
        boolean onlyDots = true;
        if (original.startsWith(".")) {
            int i = 0;
            while (i < original.length()) {
                if (original.charAt(i) != '.') {
                    onlyDots = false;
                    afterDots = original.substring(i);
                    break;
                }
                ++level;
                ++i;
            }
        }
        ICompletionRequest request = r;
        IPythonNature nature = request.getNature();
        String relative = null;
        String moduleName = null;
        if (request.getEditorFile() != null && (moduleName = nature.getAstManager().getModulesManager().resolveModule(REF.getFileAbsolutePath((File)request.getEditorFile()))) != null) {
            if (level > 0) {
                List moduleParts = StringUtils.dotSplit((String)moduleName);
                if (moduleParts.size() > level) {
                    relative = FullRepIterable.joinParts((List)moduleParts, (int)(moduleParts.size() - level));
                }
                if (!onlyDots) {
                    relative = new StringBuffer(String.valueOf(relative)).append(".").append(afterDots).toString();
                }
            } else {
                String tail = FullRepIterable.headAndTail((String)moduleName)[0];
                relative = original.length() > 0 ? new StringBuffer(String.valueOf(tail)).append(".").append(original).toString() : tail;
            }
        }
        HashSet<IToken> set = new HashSet<IToken>();
        String absoluteModule = original;
        if (absoluteModule.endsWith(".")) {
            absoluteModule = absoluteModule.substring(0, absoluteModule.length() - 1);
        }
        if (level == 0) {
            this.getAbsoluteImportTokens(absoluteModule, set, 0, false, importInfo, onlyGetDirectModules);
            this.getTokensForModule(original, nature, absoluteModule, set);
        }
        if (relative != null && !relative.equals(absoluteModule)) {
            this.getAbsoluteImportTokens(relative, set, 7, false, importInfo, onlyGetDirectModules);
            if (importInfo.hasImportSubstring) {
                this.getTokensForModule(relative, nature, relative, set);
            }
        }
        if (level == 1 && moduleName != null) {
            String strToRemove = FullRepIterable.getLastPart((String)moduleName);
            Iterator it = set.iterator();
            while (it.hasNext()) {
                IToken o = (IToken)it.next();
                if (!o.getRepresentation().equals(strToRemove)) continue;
                it.remove();
            }
        }
        return set.toArray(EMPTY_ITOKEN_ARRAY);
    }

    public void getAbsoluteImportTokens(String moduleToGetTokensFrom, Set<IToken> set, int type, boolean onlyFilesOnSameLevel, ICodeCompletionASTManager.ImportInfo importInfo, boolean onlyGetDirectModules) {
        boolean getSubModules = false;
        if (importInfo != null && importInfo.hasFromSubstring != importInfo.hasImportSubstring) {
            getSubModules = true;
        }
        SortedMap modulesStartingWith = onlyGetDirectModules ? this.modulesManager.getAllDirectModulesStartingWith(moduleToGetTokensFrom) : this.modulesManager.getAllModulesStartingWith(moduleToGetTokensFrom);
        for (ModulesKey key : modulesStartingWith.keySet()) {
            List splitted;
            String element = key.name;
            if (onlyFilesOnSameLevel && key.file != null && key.file.isDirectory()) continue;
            element = element.substring(moduleToGetTokensFrom.length());
            if (onlyFilesOnSameLevel && PyAction.countChars('.', element) > 1) continue;
            boolean goForIt = false;
            if (moduleToGetTokensFrom.length() != 0) {
                if (element.length() > 0 && element.charAt(0) == '.') {
                    element = element.substring(1);
                    goForIt = true;
                }
            } else {
                goForIt = true;
            }
            if (element.length() <= 0 || !goForIt || (splitted = StringUtils.dotSplit((String)element)).size() <= 0) continue;
            String strToAdd = !getSubModules ? (String)splitted.get(0) : (element.endsWith(".__init__") ? element.substring(0, element.length() - 9) : element);
            set.add(new ConcreteToken(strToAdd, "", "", moduleToGetTokensFrom, type));
        }
    }

    protected void getTokensForModule(String original, IPythonNature nature, String moduleToGetTokensFrom, Set<IToken> set) throws CompletionRecursionException {
        if (moduleToGetTokensFrom.length() > 0) {
            IToken[] globalTokens;
            CompletionState state2;
            if (original.endsWith(".")) {
                original = original.substring(0, original.length() - 1);
            }
            Tuple<IModule, String> modTok = this.findModuleFromPath(original, nature, false, null);
            IModule m = (IModule)modTok.o1;
            String tok = (String)modTok.o2;
            if (m == null) {
                return;
            }
            if (tok != null && tok.length() > 0) {
                state2 = new CompletionState(-1, -1, tok, nature, "");
                state2.builtinsGotten = true;
                globalTokens = m.getGlobalTokens((ICompletionState)state2, (ICodeCompletionASTManager)this);
            } else {
                state2 = new CompletionState(-1, -1, "", nature, "");
                state2.builtinsGotten = true;
                globalTokens = this.getCompletionsForModule(m, state2);
            }
            int i = 0;
            while (i < globalTokens.length) {
                IToken element = globalTokens[i];
                set.add(element);
                ++i;
            }
        }
    }

    public static IModule createModule(File file, IDocument doc, ICompletionState state, ICodeCompletionASTManager manager) throws MisconfigurationException {
        IPythonNature pythonNature = state.getNature();
        int line = state.getLine();
        IModulesManager projModulesManager = manager.getModulesManager();
        return AbstractModule.createModuleFromDoc(file, doc, pythonNature, line, projModulesManager);
    }

    public IToken[] getCompletionsForToken(File file, IDocument doc, ICompletionState state) throws CompletionRecursionException, MisconfigurationException {
        IModule module = AbstractASTManager.createModule(file, doc, state, this);
        return this.getCompletionsForModule(module, state, true, true);
    }

    public IToken[] getCompletionsForToken(IDocument doc, ICompletionState state) {
        IToken[] completionsForModule;
        try {
            Tuple obj = PyParser.reparseDocument((PyParser.ParserInfo)new PyParser.ParserInfo(doc, true, (IGrammarVersionProvider)state.getNature(), state.getLine()));
            SimpleNode n = (SimpleNode)obj.o1;
            IModule module = AbstractModule.createModule(n);
            completionsForModule = this.getCompletionsForModule(module, state, true, true);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                if (e instanceof NullPointerException) {
                    e.printStackTrace();
                    message = "NullPointerException";
                } else {
                    message = "Null error message";
                }
            }
            completionsForModule = new IToken[]{new ConcreteToken(message, message, "", "", -1)};
        }
        return completionsForModule;
    }

    public IModule getModule(String name, IPythonNature nature, boolean dontSearchInit) {
        return this.modulesManager.getModule(name, nature, dontSearchInit, false);
    }

    public IModule getModule(String name, IPythonNature nature, boolean dontSearchInit, boolean lookingForRelative) {
        if (lookingForRelative) {
            return this.modulesManager.getRelativeModule(name, nature);
        }
        return this.modulesManager.getModule(name, nature, dontSearchInit);
    }

    protected IToken[] getBuiltinsCompletions(ICompletionState state) {
        ICompletionState state2 = state.getCopy();
        String act = state.getActivationToken();
        state2.setActivationToken(NodeUtils.getBuiltinType((String)act));
        if (state2.getActivationToken() != null) {
            IModule m = this.getBuiltinMod(state.getNature());
            return m.getGlobalTokens(state2, (ICodeCompletionASTManager)this);
        }
        if (act.equals("__builtins__") || act.startsWith("__builtins__.")) {
            if ((act = act.substring(12)).startsWith(".")) {
                act = act.substring(1);
            }
            IModule m = this.getBuiltinMod(state.getNature());
            ICompletionState state3 = state.getCopy();
            state3.setActivationToken(act);
            return m.getGlobalTokens(state3, (ICodeCompletionASTManager)this);
        }
        return null;
    }

    public IToken[] getCompletionsForModule(IModule module, ICompletionState state) throws CompletionRecursionException {
        return this.getCompletionsForModule(module, state, true);
    }

    public IToken[] getCompletionsForModule(IModule module, ICompletionState state, boolean searchSameLevelMods) throws CompletionRecursionException {
        return this.getCompletionsForModule(module, state, true, false);
    }

    public IToken[] getCompletionsForModule(IModule module, ICompletionState state, boolean searchSameLevelMods, boolean lookForArgumentCompletion) throws CompletionRecursionException {
        return this.getCompletionsForModule(module, state, searchSameLevelMods, lookForArgumentCompletion, false);
    }

    public IToken[] getCompletionsForModule(IModule module, ICompletionState state, boolean searchSameLevelMods, boolean lookForArgumentCompletion, boolean handleAsWildImport) throws CompletionRecursionException {
        String name = module.getName();
        TupleN key = new TupleN(new Object[]{"getCompletionsForModule", name != null ? name : "", state.getActivationToken(), Autobox.valueOf((boolean)searchSameLevelMods), Autobox.valueOf((boolean)lookForArgumentCompletion), Autobox.valueOf((boolean)state.getBuiltinsGotten()), Autobox.valueOf((boolean)state.getLocalImportsGotten()), Autobox.valueOf((boolean)handleAsWildImport)});
        IToken[] ret = (IToken[])state.getObj((Object)key);
        if (ret != null) {
            return ret;
        }
        IToken[] completionsForModule = this.internalGenerateGetCompletionsForModule(module, state, searchSameLevelMods, lookForArgumentCompletion);
        completionsForModule = this.filterForWildImport(module, handleAsWildImport, completionsForModule);
        state.add((Object)key, (Object)completionsForModule);
        return completionsForModule;
    }

    private IToken[] filterForWildImport(IModule module, boolean handleAsWildImport, IToken[] completionsForModule) {
        if (module != null && handleAsWildImport) {
            SourceModule sourceModule;
            GlobalModelVisitor globalModelVisitorCache;
            ArrayList<IToken> ret = new ArrayList<IToken>();
            int j = 0;
            while (j < completionsForModule.length) {
                IToken token = completionsForModule[j];
                if (!token.getRepresentation().startsWith("_")) {
                    ret.add(token);
                }
                ++j;
            }
            if (module instanceof SourceModule && (globalModelVisitorCache = (sourceModule = (SourceModule)module).getGlobalModelVisitorCache()) != null) {
                globalModelVisitorCache.filterAll(ret);
            }
            return ret.toArray(new IToken[ret.size()]);
        }
        return completionsForModule;
    }

    private void log(String message, IModule module, ICompletionState state) {
        String name = module == null ? "null module" : module.getName();
        Log.toLogFile((Object)this, (String)new StringBuffer(String.valueOf(message)).append(": ").append(name).append(" -- ").append(state.getActivationToken()).toString());
    }

    private IToken[] internalGenerateGetCompletionsForModule(IModule module, ICompletionState state, boolean searchSameLevelMods, boolean lookForArgumentCompletion) throws CompletionRecursionException {
        IToken[] builtinsCompletions;
        if (DebugSettings.DEBUG_CODE_COMPLETION) {
            this.log("internalGenerateGetCompletionsForModule", module, state);
        }
        ArrayList<IToken> importedModules = new ArrayList<IToken>();
        ILocalScope localScope = null;
        int line = state.getLine();
        int col = state.getCol();
        if (!state.getLocalImportsGotten()) {
            state.setLocalImportsGotten(true);
            if (module != null && line >= 0 && (localScope = module.getLocalScope(line, col)) != null) {
                importedModules.addAll(localScope.getLocalImportedModules(line + 1, col + 1, module.getName()));
            }
        }
        if ((builtinsCompletions = this.getBuiltinsCompletions(state)) != null) {
            return builtinsCompletions;
        }
        String act = state.getActivationToken();
        int parI = act.indexOf(40);
        if (parI != -1) {
            state.setFullActivationToken(act);
            act = act.substring(0, parI);
            state.setActivationToken(act);
            state.setLookingFor(1);
        }
        if (module != null) {
            IToken[] globalTokens = module.getGlobalTokens();
            List<IToken> tokenImportedModules = Arrays.asList(module.getTokenImportedModules());
            importedModules.addAll(tokenImportedModules);
            state.setTokenImportedModules(importedModules);
            IToken[] wildImportedModules = module.getWildImportedModules();
            HashSet<IToken> initial = new HashSet<IToken>();
            if (searchSameLevelMods && module.isPackage()) {
                HashSet<IToken> gotten = new HashSet<IToken>();
                this.getAbsoluteImportTokens(module.getPackageFolderName(), gotten, 0, true, null, false);
                for (IToken token : gotten) {
                    if (token.getRepresentation().equals("__init__")) continue;
                    initial.add(token);
                }
            }
            if (state.getActivationToken().length() == 0) {
                List<IToken> completions = this.getGlobalCompletions(globalTokens, importedModules.toArray(EMPTY_ITOKEN_ARRAY), wildImportedModules, state, module);
                if (line >= 0) {
                    IToken[] localTokens = module.getLocalTokens(line, col, localScope);
                    int i = 0;
                    while (i < localTokens.length) {
                        completions.add(localTokens[i]);
                        ++i;
                    }
                }
                completions.addAll(initial);
                return completions.toArray(EMPTY_ITOKEN_ARRAY);
            }
            IToken[] tokens = this.findTokensOnImportedMods(importedModules.toArray(EMPTY_ITOKEN_ARRAY), state, module);
            if (tokens != null && tokens.length > 0) {
                return this.decorateWithLocal(tokens, localScope, state);
            }
            if (searchSameLevelMods && (tokens = this.searchOnSameLevelMods(initial, state)) != null && tokens.length > 0) {
                return this.decorateWithLocal(tokens, localScope, state);
            }
            int i = 0;
            while (i < wildImportedModules.length) {
                IToken name = wildImportedModules[i];
                IModule mod = this.getModule(name.getAsRelativeImport(module.getName()), state.getNature(), false);
                if (mod == null) {
                    mod = this.getModule(name.getOriginalRep(), state.getNature(), false);
                }
                if (mod != null) {
                    state.checkFindModuleCompletionsMemory(mod, state.getActivationToken());
                    IToken[] completionsForModule = this.getCompletionsForModule(mod, state);
                    if (completionsForModule.length > 0) {
                        return this.decorateWithLocal(completionsForModule, localScope, state);
                    }
                }
                ++i;
            }
            tokens = module.getGlobalTokens(state, (ICodeCompletionASTManager)this);
            if (tokens.length > 0) {
                return this.decorateWithLocal(tokens, localScope, state);
            }
            IModule builtinsMod = this.getBuiltinMod(state.getNature());
            if (builtinsMod != null && builtinsMod != module && (tokens = this.getCompletionsForModule(builtinsMod, state)).length > 0 && !tokens[0].getRepresentation().equals("ERROR:")) {
                return this.decorateWithLocal(tokens, localScope, state);
            }
            if (lookForArgumentCompletion && localScope != null) {
                List lookForClass = localScope.getPossibleClassesForActivationToken(state.getActivationToken());
                if (lookForClass.size() > 0) {
                    HashSet<IToken> hashSet = new HashSet<IToken>();
                    this.getCompletionsForClassInLocalScope(module, state, searchSameLevelMods, lookForArgumentCompletion, lookForClass, hashSet);
                    if (hashSet.size() > 0) {
                        return hashSet.toArray(EMPTY_ITOKEN_ARRAY);
                    }
                }
                if ((tokens = CompletionParticipantsHelper.getCompletionsForMethodParameter(state, localScope).toArray(EMPTY_ITOKEN_ARRAY)) != null && tokens.length > 0) {
                    return tokens;
                }
            }
            return this.getAssignCompletions(module, state, lookForArgumentCompletion, localScope);
        }
        System.err.println("Module passed in is null!!");
        return EMPTY_ITOKEN_ARRAY;
    }

    private IToken[] decorateWithLocal(IToken[] tokens, ILocalScope localScope, ICompletionState state) {
        Collection interfaceForLocal;
        if (localScope != null && (interfaceForLocal = localScope.getInterfaceForLocal(state.getActivationToken())) != null && interfaceForLocal.size() > 0) {
            IToken[] ret = new IToken[tokens.length + interfaceForLocal.size()];
            Object[] array = interfaceForLocal.toArray();
            System.arraycopy(array, 0, ret, 0, array.length);
            System.arraycopy(tokens, 0, ret, array.length, tokens.length);
            return ret;
        }
        return tokens;
    }

    private IToken[] getAssignCompletions(IModule module, ICompletionState state, boolean lookForArgumentCompletion, ILocalScope localScope) {
        boolean useExtensions;
        AssignCompletionInfo assignCompletions = this.getAssignAnalysis().getAssignCompletions(this, module, state);
        boolean bl = useExtensions = assignCompletions.completions.size() == 0;
        if (lookForArgumentCompletion && localScope != null && assignCompletions.completions.size() == 0 && assignCompletions.defs.length > 0) {
            Definition[] definitionArray = assignCompletions.defs;
            int n = assignCompletions.defs.length;
            int n2 = 0;
            while (n2 < n) {
                Definition d = definitionArray[n2];
                if (d.module.equals(module) && localScope.equals(d.scope)) {
                    Collection interfaceForLocal = localScope.getInterfaceForLocal(state.getActivationToken());
                    assignCompletions.completions.addAll(interfaceForLocal);
                    break;
                }
                ++n2;
            }
        }
        if (useExtensions && localScope != null) {
            assignCompletions.completions.addAll(CompletionParticipantsHelper.getCompletionsForTokenWithUndefinedType(state, localScope));
        }
        return assignCompletions.completions.toArray(EMPTY_ITOKEN_ARRAY);
    }

    public void getCompletionsForClassInLocalScope(IModule module, ICompletionState state, boolean searchSameLevelMods, boolean lookForArgumentCompletion, List<String> lookForClass, HashSet<IToken> hashSet) throws CompletionRecursionException {
        ICompletionState stateCopy = state.getCopy();
        int prevLookingFor = stateCopy.getLookingFor();
        stateCopy.setLookingFor(1, true);
        for (String classFound : lookForClass) {
            stateCopy.setLocalImportsGotten(false);
            stateCopy.setActivationToken(classFound);
            IToken[] tokens = this.getCompletionsForModule(module, stateCopy, searchSameLevelMods, lookForArgumentCompletion);
            if (tokens == null) continue;
            IToken[] iTokenArray = tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                IToken tok = iTokenArray[n2];
                hashSet.add(tok);
                ++n2;
            }
        }
        if (hashSet.size() == 0) {
            stateCopy.setLookingFor(prevLookingFor, true);
        }
    }

    protected IToken[] searchOnSameLevelMods(Set<IToken> initial, ICompletionState state) throws CompletionRecursionException {
        IToken[] ret = null;
        Tuple modUsed = null;
        String actTokUsed = null;
        for (IToken token : initial) {
            String rep = token.getRepresentation();
            if (!state.getActivationToken().startsWith(rep)) continue;
            String absoluteImport = token.getAsAbsoluteImport();
            modUsed = this.modulesManager.getModuleAndRelatedModulesManager(absoluteImport, state.getNature(), true, false);
            IModule sameLevelMod = null;
            if (modUsed != null) {
                sameLevelMod = (IModule)modUsed.o1;
            }
            if (sameLevelMod == null) {
                return null;
            }
            String qualifier = state.getActivationToken().substring(rep.length());
            if (state.getActivationToken().equals(rep)) {
                actTokUsed = "";
            } else if (qualifier.startsWith(".")) {
                actTokUsed = qualifier.substring(1);
            }
            if (actTokUsed == null) continue;
            ICompletionState copy = state.getCopyWithActTok(actTokUsed);
            copy.setBuiltinsGotten(true);
            ret = this.getCompletionsForModule(sameLevelMod, copy);
            break;
        }
        return ret;
    }

    public List<IToken> getGlobalCompletions(IToken[] globalTokens, IToken[] importedModules, IToken[] wildImportedModules, ICompletionState state, IModule current) {
        if (DebugSettings.DEBUG_CODE_COMPLETION) {
            this.log("getGlobalCompletions", current, state);
        }
        ArrayList<IToken> completions = new ArrayList<IToken>();
        int i = 0;
        while (i < globalTokens.length) {
            completions.add(globalTokens[i]);
            ++i;
        }
        i = 0;
        while (i < importedModules.length) {
            completions.add(importedModules[i]);
            ++i;
        }
        if (!state.getBuiltinsGotten()) {
            state.setBuiltinsGotten(true);
            if (DebugSettings.DEBUG_CODE_COMPLETION) {
                Log.toLogFile((Object)this, (String)"getBuiltinCompletions");
            }
            this.getBuiltinCompletions(state, completions);
            if (DebugSettings.DEBUG_CODE_COMPLETION) {
                Log.toLogFile((Object)this, (String)"END getBuiltinCompletions");
            }
        }
        i = 0;
        while (i < wildImportedModules.length) {
            IToken name = wildImportedModules[i];
            this.getCompletionsForWildImport(state, current, completions, name);
            ++i;
        }
        return completions;
    }

    public List<IToken> getBuiltinCompletions(ICompletionState state, List<IToken> completions) {
        IPythonNature nature = state.getNature();
        IToken[] builtinCompletions = this.getBuiltinComps(nature);
        if (builtinCompletions != null) {
            int i = 0;
            while (i < builtinCompletions.length) {
                completions.add(builtinCompletions[i]);
                ++i;
            }
        }
        return completions;
    }

    protected IToken[] getBuiltinComps(IPythonNature nature) {
        IModule builtMod;
        IToken[] builtinCompletions = nature.getBuiltinCompletions();
        if ((builtinCompletions == null || builtinCompletions.length == 0) && (builtMod = this.getBuiltinMod(nature)) != null) {
            builtinCompletions = builtMod.getGlobalTokens();
            nature.setBuiltinCompletions(builtinCompletions);
        }
        return builtinCompletions;
    }

    protected IModule getBuiltinMod(IPythonNature nature) {
        IModule mod = nature.getBuiltinMod();
        if (mod == null) {
            mod = this.getModule("__builtin__", nature, false);
            if (mod == null) {
                mod = this.getModule("builtins", nature, false);
            }
            nature.setBuiltinMod(mod);
        }
        return mod;
    }

    public IToken resolveImport(ICompletionState state, IToken imported) throws CompletionRecursionException {
        String curModName = imported.getParentPackage();
        Tuple3<IModule, String, IToken> modTok = this.findOnImportedMods(new IToken[]{imported}, state.getCopyWithActTok(imported.getRepresentation()), curModName);
        if (modTok != null && modTok.o1 != null) {
            if (((String)modTok.o2).length() == 0) {
                return imported;
            }
            try {
                state.checkResolveImportMemory((IModule)modTok.o1, (String)modTok.o2);
            }
            catch (CompletionRecursionException completionRecursionException) {
                return imported;
            }
            IToken repInModule = this.getRepInModule((IModule)modTok.o1, (String)modTok.o2, state.getNature(), state);
            if (repInModule != null) {
                return repInModule;
            }
        }
        return imported;
    }

    public IToken getRepInModule(IModule module, String tokName, IPythonNature nature) throws CompletionRecursionException {
        return this.getRepInModule(module, tokName, nature, null);
    }

    private IToken getRepInModule(IModule module, String tokName, IPythonNature nature, ICompletionState state) throws CompletionRecursionException {
        if (module != null) {
            IToken[] completionsForModule;
            if (tokName.startsWith(".")) {
                tokName = tokName.substring(1);
            }
            String[] headAndTail = FullRepIterable.headAndTail((String)tokName);
            String actToken = headAndTail[0];
            String hasToBeFound = headAndTail[1];
            if (state == null) {
                state = CompletionStateFactory.getEmptyCompletionState(actToken, nature, new CompletionCache());
            } else {
                state = state.getCopy();
                state.setActivationToken(actToken);
            }
            IToken[] iTokenArray = completionsForModule = this.getCompletionsForModule(module, state);
            int n = completionsForModule.length;
            int n2 = 0;
            while (n2 < n) {
                IToken foundTok = iTokenArray[n2];
                if (foundTok.getRepresentation().equals(hasToBeFound)) {
                    return foundTok;
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean getCompletionsForWildImport(ICompletionState state, IModule current, List<IToken> completions, IToken name) {
        try {
            IModule mod = null;
            if (current != null) {
                mod = this.getModule(name.getAsRelativeImport(current.getName()), state.getNature(), false);
            }
            if (mod == null) {
                mod = this.getModule(name.getOriginalRep(), state.getNature(), false);
            }
            if (mod != null) {
                IToken[] completionsForModule;
                state.checkWildImportInMemory(current, mod);
                IToken[] iTokenArray = completionsForModule = this.getCompletionsForModule(mod, state, true, false, true);
                int n = completionsForModule.length;
                int n2 = 0;
                while (n2 < n) {
                    IToken token = iTokenArray[n2];
                    completions.add(token);
                    ++n2;
                }
                return true;
            }
        }
        catch (CompletionRecursionException completionRecursionException) {}
        return false;
    }

    public IToken[] findTokensOnImportedMods(IToken[] importedModules, ICompletionState state, IModule current) throws CompletionRecursionException {
        Tuple3<IModule, String, IToken> o = this.findOnImportedMods(importedModules, state, current.getName());
        if (o == null) {
            return null;
        }
        IModule mod = (IModule)o.o1;
        String tok = (String)o.o2;
        String tokForSearchInOtherModule = AbstractASTManager.getTokToSearchInOtherModule(o);
        if (tok.length() == 0) {
            ICompletionState copy = state.getCopy();
            copy.setActivationToken("");
            copy.setBuiltinsGotten(true);
            return this.getCompletionsForModule(mod, copy);
        }
        if (mod != null) {
            ICompletionState copy = state.getCopy();
            copy.setActivationToken(tokForSearchInOtherModule);
            copy.setCol(-1);
            copy.setLine(-1);
            copy.raiseNFindTokensOnImportedModsCalled(mod, tokForSearchInOtherModule);
            String parentPackage = ((IToken)o.o3).getParentPackage();
            if (parentPackage.trim().length() > 0 && parentPackage.equals(current.getName()) && state.getActivationToken().equals(tok) && !parentPackage.endsWith("__init__")) {
                String name = mod.getName();
                if (name.endsWith(".__init__")) {
                    name = name.substring(0, name.length() - 9);
                }
                if (((IToken)o.o3).getAsAbsoluteImport().startsWith(name) && current.isInDirectGlobalTokens(tok, (ICompletionCache)state)) {
                    return null;
                }
            }
            return this.getCompletionsForModule(mod, copy);
        }
        return null;
    }

    public static String getTokToSearchInOtherModule(Tuple3<IModule, String, IToken> modTok) {
        SourceToken sourceToken2;
        IToken sourceToken;
        String tok;
        String tokForSearchInOtherModule = tok = (String)modTok.o2;
        if (tok.length() > 0 && (sourceToken = (IToken)modTok.o3) instanceof SourceToken && (sourceToken2 = (SourceToken)sourceToken).getAst() instanceof ImportFrom) {
            ImportFrom importFrom = (ImportFrom)sourceToken2.getAst();
            if (importFrom.names.length > 0 && importFrom.names[0].asname != null) {
                String originalRep = sourceToken.getOriginalRep();
                tokForSearchInOtherModule = FullRepIterable.getLastPart((String)originalRep);
            }
        }
        return tokForSearchInOtherModule;
    }

    public Tuple3<IModule, String, IToken> findOnImportedMods(ICompletionState state, IModule current) throws CompletionRecursionException {
        IToken[] importedModules = current.getTokenImportedModules();
        return this.findOnImportedMods(importedModules, state, current.getName());
    }

    public Tuple3<IModule, String, IToken> findOnImportedMods(IToken[] importedModules, ICompletionState state, String currentModuleName) throws CompletionRecursionException {
        FullRepIterable iterable = new FullRepIterable(state.getActivationToken(), true);
        for (String tok : iterable) {
            IToken[] iTokenArray = importedModules;
            int n = importedModules.length;
            int n2 = 0;
            while (n2 < n) {
                IToken importedModule = iTokenArray[n2];
                String modRep = importedModule.getRepresentation();
                if (modRep.equals(tok)) {
                    String act = state.getActivationToken();
                    Tuple<IModule, String> r = this.findOnImportedMods(importedModule, tok, state, act, currentModuleName);
                    if (r == null) {
                        return null;
                    }
                    return new Tuple3((Object)((IModule)r.o1), (Object)((String)r.o2), (Object)importedModule);
                }
                ++n2;
            }
        }
        return null;
    }

    protected Tuple<IModule, String> findOnImportedMods(IToken importedModule, String tok, ICompletionState state, String activationToken, String currentModuleName) throws CompletionRecursionException {
        SourceToken token;
        Tuple<IModule, String> modTok = null;
        IModule mod = null;
        IPythonNature nature = state.getNature();
        if (importedModule instanceof SourceToken && (token = (SourceToken)importedModule).isImportFrom()) {
            ImportFrom importFrom = (ImportFrom)token.getAst();
            int level = importFrom.level;
            if (level > 0) {
                String modName;
                String parentPackage = token.getParentPackage();
                List moduleParts = StringUtils.dotSplit((String)parentPackage);
                String relative = null;
                if (moduleParts.size() > level) {
                    relative = FullRepIterable.joinParts((List)moduleParts, (int)(moduleParts.size() - level));
                }
                if ((modName = ((NameTok)importFrom.module).id).length() > 0) {
                    relative = new StringBuffer(String.valueOf(relative)).append(".").append(modName).toString();
                }
                relative = new StringBuffer(String.valueOf(relative)).append(".").append(tok).toString();
                modTok = this.findModuleFromPath(relative, nature, false, null);
                mod = (IModule)modTok.o1;
                if (this.checkValidity(currentModuleName, mod)) {
                    Tuple<IModule, String> ret = this.fixTok(modTok, tok, activationToken);
                    return ret;
                }
                return null;
            }
        }
        String asRelativeImport = importedModule.getAsRelativeImport(currentModuleName);
        modTok = this.findModuleFromPath(asRelativeImport, nature, true, currentModuleName);
        mod = (IModule)modTok.o1;
        if (this.checkValidity(currentModuleName, mod)) {
            Tuple<IModule, String> ret = this.fixTok(modTok, tok, activationToken);
            return ret;
        }
        String originalWithoutRep = importedModule.getOriginalWithoutRep();
        if (originalWithoutRep.length() > 0) {
            if (!originalWithoutRep.endsWith("__init__")) {
                originalWithoutRep = new StringBuffer(String.valueOf(originalWithoutRep)).append(".__init__").toString();
            }
            modTok = this.findModuleFromPath(originalWithoutRep, nature, true, null);
            mod = (IModule)modTok.o1;
            if (!((String)modTok.o2).endsWith("__init__") && this.checkValidity(currentModuleName, mod) && mod.isInGlobalTokens(importedModule.getRepresentation(), nature, false, (ICompletionCache)state)) {
                Tuple<IModule, String> ret = this.fixTok(modTok, tok, activationToken);
                ret.o2 = ((String)ret.o2).length() == 0 ? importedModule.getRepresentation() : new StringBuffer(String.valueOf(importedModule.getRepresentation())).append(".").append((String)ret.o2).toString();
                return ret;
            }
        }
        modTok = this.findModuleFromPath(importedModule.getOriginalRep(), nature, false, null);
        mod = (IModule)modTok.o1;
        if (this.checkValidity(currentModuleName, mod)) {
            Tuple<IModule, String> ret = this.fixTok(modTok, tok, activationToken);
            return ret;
        }
        modTok = this.findModuleFromPath(asRelativeImport, nature, false, null);
        mod = (IModule)modTok.o1;
        if (this.checkValidity(currentModuleName, mod, true)) {
            Tuple<IModule, String> ret = this.fixTok(modTok, tok, activationToken);
            if (!mod.getName().endsWith("__init__")) {
                return ret;
            }
            if (activationToken.length() == 0 || !((String)ret.o2).equals(activationToken) || mod.isInGlobalTokens(activationToken, nature, false, (ICompletionCache)state)) {
                return ret;
            }
        }
        return null;
    }

    protected boolean checkValidity(String currentModuleName, IModule mod) {
        return this.checkValidity(currentModuleName, mod, false);
    }

    protected boolean checkValidity(String currentModuleName, IModule mod, boolean isRelative) {
        if (mod == null) {
            return false;
        }
        String modName = mod.getName();
        if (modName == null) {
            return true;
        }
        if (modName.equals(currentModuleName)) {
            return false;
        }
        if (isRelative && currentModuleName != null && modName.endsWith(".__init__")) {
            String withoutLastPart = FullRepIterable.getWithoutLastPart((String)modName);
            String currentWithoutLastPart = FullRepIterable.getWithoutLastPart((String)currentModuleName);
            if (currentWithoutLastPart.equals(withoutLastPart)) {
                return false;
            }
        }
        return true;
    }

    protected Tuple<IModule, String> fixTok(Tuple<IModule, String> modTok, String tok, String activationToken) {
        if (activationToken.length() > tok.length() && activationToken.startsWith(tok)) {
            String toAdd = activationToken.substring(tok.length() + 1);
            modTok.o2 = ((String)modTok.o2).length() == 0 ? toAdd : new StringBuffer(String.valueOf(modTok.o2)).append(".").append(toAdd).toString();
        }
        return modTok;
    }

    protected Tuple<IModule, String> findModuleFromPath(String rep, IPythonNature nature, boolean dontSearchInit, String currentModuleName) {
        int index;
        String tok = "";
        boolean lookingForRelative = currentModuleName != null;
        IModule mod = this.getModule(rep, nature, dontSearchInit, lookingForRelative);
        String mRep = rep;
        while (mod == null && (index = mRep.lastIndexOf(46)) != -1) {
            tok = new StringBuffer(String.valueOf(mRep.substring(index + 1))).append(".").append(tok).toString();
            if ((mRep = mRep.substring(0, index)).length() <= 0) continue;
            mod = this.getModule(mRep, nature, dontSearchInit, lookingForRelative);
        }
        if (tok.endsWith(".")) {
            tok = tok.substring(0, tok.length() - 1);
        }
        if (dontSearchInit && currentModuleName != null && mod != null) {
            String parentModule = FullRepIterable.getParentModule((String)currentModuleName);
            if (mod.getName().length() <= parentModule.length()) {
                return new Tuple(null, null);
            }
        }
        return new Tuple((Object)((AbstractModule)mod), (Object)tok);
    }
}

