/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator.filters;

import java.lang.ref.WeakReference;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.navigator.filters.AbstractFilter;
import org.python.pydev.navigator.properties.StringMatcherSimple;
import org.python.pydev.plugin.PydevPlugin;

public class CustomFilters
extends AbstractFilter {
    private StringMatcherSimple[] filters;

    public CustomFilters() {
        IPreferenceStore prefs = PydevPlugin.getDefault().getPreferenceStore();
        this.update(prefs.getString("org.python.pydev.CUSTOM_PACKAGE_EXPLORER_FILTERS"));
        new PropertyListener(this);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        String name = this.getName(element);
        return this.filterName(name);
    }

    protected boolean filterName(String name) {
        if (name == null) {
            return true;
        }
        StringMatcherSimple[] temp = this.filters;
        int i = 0;
        while (i < temp.length) {
            if (temp[i].match(name)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void update(String customFilters) {
        List splittedCustomFilters = StringUtils.splitAndRemoveEmptyTrimmed((String)customFilters, (char)',');
        StringMatcherSimple[] temp = new StringMatcherSimple[splittedCustomFilters.size()];
        int i = 0;
        while (i < temp.length) {
            temp[i] = new StringMatcherSimple(((String)splittedCustomFilters.get(i)).trim());
            ++i;
        }
        this.filters = temp;
    }

    private static class PropertyListener
    implements IPropertyChangeListener {
        private WeakReference<CustomFilters> weakCustomFilter;

        public PropertyListener(CustomFilters customFilter) {
            this.weakCustomFilter = new WeakReference<CustomFilters>(customFilter);
            IPreferenceStore prefs = PydevPlugin.getDefault().getPreferenceStore();
            prefs.addPropertyChangeListener((IPropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent event) {
            CustomFilters customFilters = (CustomFilters)((Object)this.weakCustomFilter.get());
            if (customFilters == null) {
                IPreferenceStore prefs = PydevPlugin.getDefault().getPreferenceStore();
                prefs.removePropertyChangeListener((IPropertyChangeListener)this);
            } else {
                String property = event.getProperty();
                if (property.equals("org.python.pydev.CUSTOM_PACKAGE_EXPLORER_FILTERS")) {
                    customFilters.update((String)event.getNewValue());
                }
            }
        }
    }
}

