/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.outline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.core.bundle.ImageCache;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.parser.ErrorDescription;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntryWithChildren;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedItem
implements Comparable<Object> {
    private ParsedItem parent;
    private ParsedItem[] children;
    private ASTEntryWithChildren astThis;
    private ASTEntryWithChildren[] astChildrenEntries;
    private ErrorDescription errorDesc;
    private static final int QUALIFIER_PUBLIC = 0;
    private static final int QUALIFIER_PROTECTED = 1;
    private static final int QUALIFIER_PRIVATE = 2;
    private static final int QUALIFIER_MAGIC = 3;
    private static final int DECORATOR_NONE = 0;
    private static final int DECORATOR_STATIC = 1;
    private static final int DECORATOR_CLASS = 2;
    private String toStringCache;

    public ParsedItem(ParsedItem parent, ASTEntryWithChildren root, ASTEntryWithChildren[] astChildren) {
        this(astChildren, null);
        this.parent = parent;
        this.astThis = root;
    }

    public ParsedItem(ParsedItem parent, ErrorDescription errorDesc) {
        this.parent = parent;
        this.setErrorDesc(errorDesc);
    }

    public ParsedItem(ASTEntryWithChildren[] astChildren, ErrorDescription errorDesc) {
        this.astChildrenEntries = astChildren;
        this.setErrorDesc(errorDesc);
    }

    public ASTEntryWithChildren getAstThis() {
        return this.astThis;
    }

    public void setAstThis(ASTEntryWithChildren astThis) {
        this.setAstThis(astThis, null);
    }

    public void setAstThis(ASTEntryWithChildren astThis, ASTEntryWithChildren[] astChildrenEntries) {
        this.toStringCache = null;
        this.astThis = astThis;
        if (astChildrenEntries != null) {
            this.astChildrenEntries = astChildrenEntries;
            this.children = null;
        }
    }

    public ASTEntryWithChildren[] getAstChildrenEntries() {
        return this.astChildrenEntries;
    }

    public ErrorDescription getErrorDesc() {
        return this.errorDesc;
    }

    public void setErrorDesc(ErrorDescription errorDesc) {
        if (this.errorDesc == null && errorDesc == null) {
            return;
        }
        this.toStringCache = null;
        this.errorDesc = errorDesc;
    }

    private static int qualifierFromName(String name) {
        if (name.startsWith("__") && name.endsWith("__")) {
            return 3;
        }
        if (name.startsWith("__")) {
            return 2;
        }
        if (name.startsWith("_")) {
            return 1;
        }
        return 0;
    }

    public Image getImage() {
        ImageCache imageCache = PydevPlugin.getImageCache();
        if (this.astThis == null) {
            return imageCache.get("icons/showerr_tsk.gif");
        }
        SimpleNode token = this.astThis.node;
        if (token instanceof ClassDef) {
            String className = NodeUtils.getNameFromNameTok((NameTok)((NameTok)((ClassDef)token).name));
            switch (ParsedItem.qualifierFromName(className)) {
                case 1: {
                    return imageCache.get("icons/class_protected_obj.gif");
                }
                case 2: {
                    return imageCache.get("icons/class_private_obj.gif");
                }
            }
            return imageCache.get("icons/class_obj.gif");
        }
        if (token instanceof FunctionDef) {
            int decoratorType = 0;
            FunctionDef functionDefToken = (FunctionDef)token;
            if (functionDefToken.decs != null) {
                decoratorsType[] decoratorsTypeArray = functionDefToken.decs;
                int n = functionDefToken.decs.length;
                int n2 = 0;
                while (n2 < n) {
                    decoratorsType decorator = decoratorsTypeArray[n2];
                    if (decorator.func instanceof Name) {
                        Name decoratorFuncName = (Name)decorator.func;
                        if (decoratorFuncName.id.equals("staticmethod")) {
                            decoratorType = 1;
                        } else if (decoratorFuncName.id.equals("classmethod")) {
                            decoratorType = 2;
                        }
                    }
                    ++n2;
                }
            }
            String methodName = NodeUtils.getNameFromNameTok((NameTok)((NameTok)((FunctionDef)token).name));
            switch (ParsedItem.qualifierFromName(methodName)) {
                case 3: {
                    switch (decoratorType) {
                        case 2: {
                            return imageCache.get("icons/methmag_class_obj.gif");
                        }
                        case 1: {
                            return imageCache.get("icons/methmag_static_obj.gif");
                        }
                    }
                    return imageCache.get("icons/methmag_obj.gif");
                }
                case 2: {
                    switch (decoratorType) {
                        case 2: {
                            return imageCache.get("icons/methpri_class_obj.gif");
                        }
                        case 1: {
                            return imageCache.get("icons/methpri_static_obj.gif");
                        }
                    }
                    return imageCache.get("icons/methpri_obj.gif");
                }
                case 1: {
                    switch (decoratorType) {
                        case 2: {
                            return imageCache.get("icons/methpro_class_obj.gif");
                        }
                        case 1: {
                            return imageCache.get("icons/methpro_static_obj.gif");
                        }
                    }
                    return imageCache.get("icons/methpro_obj.gif");
                }
            }
            switch (decoratorType) {
                case 2: {
                    return imageCache.get("icons/methpub_class_obj.gif");
                }
                case 1: {
                    return imageCache.get("icons/methpub_static_obj.gif");
                }
            }
            return imageCache.get("icons/methpub_obj.gif");
        }
        if (token instanceof Import) {
            return imageCache.get("icons/imp_obj.gif");
        }
        if (token instanceof ImportFrom) {
            return imageCache.get("icons/imp_obj.gif");
        }
        if (token instanceof commentType) {
            return imageCache.get("icons/python_comment.png");
        }
        if (token instanceof Attribute || token instanceof Name || token instanceof NameTok) {
            String name = null;
            if (token instanceof Attribute) {
                Attribute attributeToken = (Attribute)token;
                name = NodeUtils.getNameFromNameTok((NameTok)((NameTok)attributeToken.attr));
            } else if (token instanceof Name) {
                Name nameToken = (Name)token;
                name = nameToken.id;
            } else {
                NameTok nameTokToken = (NameTok)token;
                name = NodeUtils.getNameFromNameTok((NameTok)nameTokToken);
            }
            if (name.startsWith("__") && name.endsWith("__")) {
                return imageCache.get("icons/field_default_obj.gif");
            }
            if (name.startsWith("__")) {
                return imageCache.get("icons/field_private_obj.gif");
            }
            if (name.startsWith("_")) {
                return imageCache.get("icons/field_protected_obj.gif");
            }
            return imageCache.get("icons/field_public_obj.gif");
        }
        return imageCache.get("icons/showerr_tsk.gif");
    }

    public ParsedItem[] getChildren() {
        if (this.children != null) {
            return this.children;
        }
        if (this.astChildrenEntries == null) {
            this.astChildrenEntries = new ASTEntryWithChildren[0];
        }
        ArrayList<ParsedItem> items = new ArrayList<ParsedItem>();
        if (this.parent == null && this.errorDesc != null && this.errorDesc.message != null) {
            items.add(new ParsedItem(this, this.errorDesc));
        }
        ASTEntryWithChildren[] aSTEntryWithChildrenArray = this.astChildrenEntries;
        int n = this.astChildrenEntries.length;
        int n2 = 0;
        while (n2 < n) {
            ASTEntryWithChildren c = aSTEntryWithChildrenArray[n2];
            items.add(new ParsedItem(this, c, c.getChildren()));
            ++n2;
        }
        this.children = items.toArray(new ParsedItem[items.size()]);
        return this.children;
    }

    public ParsedItem getParent() {
        return this.parent;
    }

    public String toString() {
        if (this.toStringCache == null) {
            this.toStringCache = this.calcToString();
        }
        return this.toStringCache;
    }

    private String calcToString() {
        if (this.errorDesc != null && this.errorDesc.message != null) {
            return this.errorDesc.message;
        }
        if (this.astThis == null) {
            return "null";
        }
        if (this.astThis.node instanceof Import) {
            aliasType[] imports = ((Import)this.astThis.node).names;
            FastStringBuffer retVal = new FastStringBuffer();
            int i = 0;
            while (i < imports.length) {
                aliasType aliasType2 = imports[i];
                if (aliasType2.asname != null) {
                    retVal.append(((NameTok)aliasType2.asname).id);
                    retVal.append(" = ");
                }
                retVal.append(((NameTok)aliasType2.name).id);
                retVal.append(", ");
                ++i;
            }
            retVal.deleteLast();
            retVal.deleteLast();
            return retVal.toString();
        }
        if (this.astThis.node instanceof ImportFrom) {
            ImportFrom importToken = (ImportFrom)this.astThis.node;
            StringBuffer modules = new StringBuffer();
            int i = 0;
            while (i < importToken.names.length) {
                aliasType aliasType3 = importToken.names[i];
                if (aliasType3.asname != null) {
                    modules.append(((NameTok)aliasType3.asname).id);
                    modules.append(" = ");
                }
                modules.append(((NameTok)aliasType3.name).id);
                modules.append(",");
                ++i;
            }
            if (modules.length() == 0) {
                modules.append("*,");
            }
            modules.deleteCharAt(modules.length() - 1);
            return new StringBuffer(String.valueOf(modules.toString())).append(" (").append(((NameTok)importToken.module).id).append(")").toString();
        }
        if (this.astThis.node instanceof commentType) {
            commentType type = (commentType)this.astThis.node;
            String rep = type.id.trim();
            rep = (String)StringUtils.split((String)rep, (char)'\n').get(0);
            rep = (String)StringUtils.split((String)rep, (char)'\r').get(0);
            rep = rep.substring(1);
            rep = StringUtils.rightTrim((String)rep, (char)'-');
            return StringUtils.leftTrim((String)rep, (char)'-');
        }
        return NodeUtils.getFullRepresentationString((SimpleNode)this.astThis.node);
    }

    public int getClassRanking() {
        int rank = this.astThis == null || this.errorDesc != null && this.errorDesc.message != null ? -2 : (this.astThis.node instanceof ImportFrom ? 0 : (this.astThis.node instanceof Import ? 1 : (this.astThis.node instanceof commentType ? -1 : 10)));
        return rank;
    }

    @Override
    public int compareTo(Object o) {
        int rank;
        if (!(o instanceof ParsedItem)) {
            return 0;
        }
        ParsedItem item = (ParsedItem)o;
        int myRank = this.getClassRanking();
        if (myRank == (rank = item.getClassRanking())) {
            if (rank == -1) {
                return this.astThis.node.beginLine < item.astThis.node.beginLine ? -1 : 1;
            }
            return this.toString().compareTo(item.toString());
        }
        return myRank < rank ? -1 : 1;
    }

    public void updateTo(ParsedItem updateToItem) {
        this.toStringCache = null;
        this.errorDesc = updateToItem.errorDesc;
        this.astThis = updateToItem.astThis;
        this.astChildrenEntries = updateToItem.astChildrenEntries;
        ParsedItem[] newStructureChildren = updateToItem.getChildren();
        if (this.children == null) {
            this.children = newStructureChildren;
            return;
        }
        if (newStructureChildren.length == 0 || this.children.length == 0) {
            this.children = newStructureChildren;
            return;
        }
        ArrayList<ParsedItem> newChildren = new ArrayList<ParsedItem>();
        HashMap<String, List<ParsedItem>> childrensCache = new HashMap<String, List<ParsedItem>>();
        ParsedItem[] parsedItemArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            ParsedItem existing = parsedItemArray[n2];
            String s = existing.toString();
            ArrayList<ParsedItem> list = (ArrayList<ParsedItem>)childrensCache.get(s);
            if (list == null) {
                list = new ArrayList<ParsedItem>();
                childrensCache.put(s, list);
            }
            list.add(existing);
            ++n2;
        }
        parsedItemArray = newStructureChildren;
        n = newStructureChildren.length;
        n2 = 0;
        while (n2 < n) {
            ParsedItem n3 = parsedItemArray[n2];
            ParsedItem similarChild = this.getSimilarChild(n3, childrensCache);
            if (similarChild != null) {
                similarChild.updateTo(n3);
                n3 = similarChild;
            } else {
                n3.parent = this;
            }
            newChildren.add(n3);
            ++n2;
        }
        this.children = newChildren.toArray(new ParsedItem[newChildren.size()]);
    }

    private ParsedItem getSimilarChild(ParsedItem n, HashMap<String, List<ParsedItem>> childrensCache) {
        List<ParsedItem> list = childrensCache.get(n.toString());
        if (list != null && list.size() > 0) {
            return list.remove(0);
        }
        return null;
    }
}

