/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.python.pydev.core.ICallback;
import org.python.pydev.plugin.nature.PythonNature;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyStructureConfigHelpers {
    public static IProject getProjectHandle(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public static void createPydevProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor, String projectType, String projectInterpreter, ICallback<List<IContainer>, IProject> getSourceFolderHandlesCallback, ICallback<List<String>, IProject> getExternalSourceFolderHandlesCallback) throws OperationCanceledException, CoreException {
        PyStructureConfigHelpers.createPydevProject(description, projectHandle, monitor, projectType, projectInterpreter, getSourceFolderHandlesCallback, getExternalSourceFolderHandlesCallback, null);
    }

    public static void createPydevProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor, String projectType, String projectInterpreter, ICallback<List<IContainer>, IProject> getSourceFolderHandlesCallback, ICallback<List<String>, IProject> getExternalSourceFolderHandlesCallback, ICallback<Map<String, String>, IProject> getVariableSubstitutionCallback) throws CoreException, OperationCanceledException {
        try {
            List externalPaths;
            List sourceFolders;
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            String projectPythonpath = null;
            if (getSourceFolderHandlesCallback != null && (sourceFolders = (List)getSourceFolderHandlesCallback.call((Object)projectHandle)) != null && sourceFolders.size() > 0) {
                StringBuffer buf = new StringBuffer();
                for (IContainer container : sourceFolders) {
                    if (container instanceof IFolder) {
                        IFolder iFolder = (IFolder)container;
                        iFolder.create(true, true, monitor);
                    } else if (!(container instanceof IProject)) {
                        throw new RuntimeException(new StringBuffer("Expected container to be an IFolder or IProject. Was: ").append(container).toString());
                    }
                    if (buf.length() > 0) {
                        buf.append("|");
                    }
                    buf.append(container.getFullPath().toString());
                }
                projectPythonpath = buf.toString();
            }
            String externalProjectPythonpath = null;
            if (getExternalSourceFolderHandlesCallback != null && (externalPaths = (List)getExternalSourceFolderHandlesCallback.call((Object)projectHandle)) != null && externalPaths.size() > 0) {
                StringBuffer buf = new StringBuffer();
                for (String path : externalPaths) {
                    if (buf.length() > 0) {
                        buf.append("|");
                    }
                    buf.append(path);
                }
                externalProjectPythonpath = buf.toString();
            }
            Map variableSubstitution = null;
            if (getVariableSubstitutionCallback != null) {
                variableSubstitution = (Map)getVariableSubstitutionCallback.call((Object)projectHandle);
            }
            PythonNature.addNature(projectHandle, null, projectType, projectPythonpath, externalProjectPythonpath, projectInterpreter, variableSubstitution);
        }
        finally {
            monitor.done();
        }
    }

    public static IProject createPydevProject(String projectName, IPath projectLocationPath, IProject[] references, IProgressMonitor monitor, String projectType, String projectInterpreter, ICallback<List<IContainer>, IProject> getSourceFolderHandlesCallback, ICallback<List<String>, IProject> getExternalSourceFolderHandlesCallback, ICallback<Map<String, String>, IProject> getVariableSubstitutionCallback) throws OperationCanceledException, CoreException {
        IProject projectHandle = PyStructureConfigHelpers.getProjectHandle(projectName);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(projectHandle.getName());
        description.setLocation(projectLocationPath);
        if (references != null && references.length > 0) {
            description.setReferencedProjects(references);
        }
        PyStructureConfigHelpers.createPydevProject(description, projectHandle, monitor, projectType, projectInterpreter, getSourceFolderHandlesCallback, getExternalSourceFolderHandlesCallback, getVariableSubstitutionCallback);
        return projectHandle;
    }
}

