/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser;

import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.ICallback;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.Tuple3;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.parser.ChangedParserInfoForObservers;
import org.python.pydev.core.parser.ErrorParserInfoForObservers;
import org.python.pydev.core.parser.IParserObserver;
import org.python.pydev.core.parser.IParserObserver2;
import org.python.pydev.core.parser.IParserObserver3;
import org.python.pydev.core.parser.IPyParser;
import org.python.pydev.core.parser.ISimpleNode;
import org.python.pydev.parser.ErrorDescription;
import org.python.pydev.parser.ParserScheduler;
import org.python.pydev.parser.grammar24.PythonGrammar24;
import org.python.pydev.parser.grammar25.PythonGrammar25;
import org.python.pydev.parser.grammar26.PythonGrammar26;
import org.python.pydev.parser.grammar30.PythonGrammar30;
import org.python.pydev.parser.grammarcommon.AbstractPythonGrammar;
import org.python.pydev.parser.jython.CharStream;
import org.python.pydev.parser.jython.FastCharStream;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.ReaderCharStream;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.Token;
import org.python.pydev.parser.jython.TokenMgrError;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.stmtType;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyParser
implements IPyParser {
    public static boolean DEBUG_SHOW_PARSE_ERRORS = false;
    public static boolean ACCEPT_NULL_INPUT_EDITOR = false;
    public static boolean USE_FAST_STREAM = true;
    private volatile IDocument document;
    private SimpleNode root = null;
    private IDocumentListener documentListener;
    private ArrayList<IParserObserver> parserListeners;
    public static boolean ENABLE_TRACING = false;
    private ParserScheduler scheduler;
    private boolean useAnalysisOnlyOnDocSave;
    private IGrammarVersionProvider grammarVersionProvider;
    private volatile boolean disposed = false;
    private IEditorInput input;
    public static final List<ICallback<Object, Tuple3<SimpleNode, Throwable, ParserInfo>>> successfulParseListeners = new ArrayList<ICallback<Object, Tuple3<SimpleNode, Throwable, ParserInfo>>>();

    public static String getGrammarVersionStr(int grammarVersion) {
        if (grammarVersion == 10) {
            return "grammar: Python 2.4";
        }
        if (grammarVersion == 11) {
            return "grammar: Python 2.5";
        }
        return "grammar: unrecognized";
    }

    PyParser(IGrammarVersionProvider grammarVersionProvider) {
        if (grammarVersionProvider == null) {
            grammarVersionProvider = new IGrammarVersionProvider(){

                public int getGrammarVersion() {
                    return 12;
                }
            };
        }
        this.grammarVersionProvider = grammarVersionProvider;
        this.parserListeners = new ArrayList();
        this.scheduler = new ParserScheduler(this);
        this.documentListener = new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                if (PyParser.this.useAnalysisOnlyOnDocSave) {
                    return;
                }
                String text = event.getText();
                boolean parseNow = true;
                if (event == null || text == null) {
                    parseNow = false;
                }
                if (parseNow && text.indexOf("\n") == -1 && text.indexOf("\r") == -1) {
                    parseNow = false;
                }
                if (!parseNow) {
                    PyParser.this.scheduler.parseLater();
                } else {
                    PyParser.this.scheduler.parseNow();
                }
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        };
    }

    public PyParser(IPyEdit editorView) {
        this(PyParser.getGrammarProviderFromEdit(editorView));
    }

    private static IGrammarVersionProvider getGrammarProviderFromEdit(IPyEdit editorView) {
        return editorView.getGrammarVersionProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.disposed = true;
        this.scheduler.dispose();
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentListener);
        }
        ArrayList<IParserObserver> arrayList = this.parserListeners;
        synchronized (arrayList) {
            this.parserListeners.clear();
        }
    }

    public SimpleNode getRoot() {
        return this.root;
    }

    public void notifySaved() {
        this.forceReparse(new Object[0]);
    }

    public void forceReparse(Object ... argsToReparse) {
        if (this.disposed) {
            return;
        }
        this.scheduler.parseNow(true, argsToReparse);
    }

    public void setDocument(IDocument document, IEditorInput input) {
        this.setDocument(document, true, input);
    }

    public synchronized void setDocument(IDocument doc, boolean addToScheduler, IEditorInput input) {
        this.input = input;
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentListener);
        }
        this.document = doc;
        if (doc == null) {
            System.err.println("No document in PyParser::setDocument?");
            return;
        }
        doc.addDocumentListener(this.documentListener);
        if (addToScheduler) {
            this.scheduler.parseNow(true, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParseListener(IParserObserver listener) {
        Assert.isNotNull((Object)listener);
        ArrayList<IParserObserver> arrayList = this.parserListeners;
        synchronized (arrayList) {
            if (!this.parserListeners.contains(listener)) {
                this.parserListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParseListener(IParserObserver listener) {
        Assert.isNotNull((Object)listener);
        ArrayList<IParserObserver> arrayList = this.parserListeners;
        synchronized (arrayList) {
            this.parserListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireParserChanged(ChangedParserInfoForObservers info) {
        this.root = (SimpleNode)info.root;
        ArrayList<IParserObserver> arrayList = this.parserListeners;
        synchronized (arrayList) {
            for (IParserObserver l : new ArrayList<IParserObserver>(this.parserListeners)) {
                if (l instanceof IParserObserver3) {
                    ((IParserObserver3)l).parserChanged(info);
                    continue;
                }
                if (l instanceof IParserObserver2) {
                    ((IParserObserver2)l).parserChanged(info.root, info.file, info.doc, info.argsToReparse);
                    continue;
                }
                l.parserChanged(info.root, info.file, info.doc);
            }
            List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.parser.pydev_parser_observer");
            for (IParserObserver observer : participants) {
                if (observer instanceof IParserObserver3) {
                    ((IParserObserver3)observer).parserChanged(info);
                    continue;
                }
                if (observer instanceof IParserObserver2) {
                    ((IParserObserver2)observer).parserChanged(info.root, info.file, info.doc, info.argsToReparse);
                    continue;
                }
                observer.parserChanged(info.root, info.file, info.doc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireParserError(ErrorParserInfoForObservers info) {
        ArrayList<IParserObserver> arrayList = this.parserListeners;
        synchronized (arrayList) {
            for (IParserObserver l : new ArrayList<IParserObserver>(this.parserListeners)) {
                if (l instanceof IParserObserver3) {
                    ((IParserObserver3)l).parserError(info);
                    continue;
                }
                if (l instanceof IParserObserver2) {
                    ((IParserObserver2)l).parserError(info.error, info.file, info.doc, info.argsToReparse);
                    continue;
                }
                l.parserError(info.error, info.file, info.doc);
            }
            List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.parser.pydev_parser_observer");
            for (IParserObserver observer : participants) {
                if (observer instanceof IParserObserver3) {
                    ((IParserObserver3)observer).parserError(info);
                    continue;
                }
                if (observer instanceof IParserObserver2) {
                    ((IParserObserver2)observer).parserError(info.error, info.file, info.doc, info.argsToReparse);
                    continue;
                }
                observer.parserError(info.error, info.file, info.doc);
            }
        }
    }

    public Tuple<SimpleNode, Throwable> reparseDocument(Object ... argsToReparse) {
        ChangedParserInfoForObservers info;
        int version;
        try {
            version = this.grammarVersionProvider.getGrammarVersion();
        }
        catch (MisconfigurationException misconfigurationException) {
            version = 12;
        }
        long documentTime = System.currentTimeMillis();
        Tuple<SimpleNode, Throwable> obj = PyParser.reparseDocument(new ParserInfo(this.document, true, version));
        IFile original = null;
        Object adaptable = null;
        if (this.input == null) {
            return obj;
        }
        original = this.input instanceof IFileEditorInput ? ((IFileEditorInput)this.input).getFile() : null;
        adaptable = original != null ? original : this.input;
        if (original != null) {
            try {
                PyParser.deleteErrorMarkers((IResource)original);
            }
            catch (ResourceException e) {
                if (original.exists()) {
                    Log.log((Throwable)e);
                }
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
        } else if (adaptable == null && !ACCEPT_NULL_INPUT_EDITOR) {
            throw new RuntimeException("Null input editor received in parser!");
        }
        if (this.disposed) {
            return new Tuple(null, null);
        }
        if (obj.o1 != null) {
            info = new ChangedParserInfoForObservers((ISimpleNode)obj.o1, (IAdaptable)adaptable, this.document, documentTime, argsToReparse);
            this.fireParserChanged(info);
        }
        if (obj.o2 instanceof ParseException || obj.o2 instanceof TokenMgrError) {
            info = new ErrorParserInfoForObservers((Throwable)obj.o2, (IAdaptable)adaptable, this.document, argsToReparse);
            this.fireParserError((ErrorParserInfoForObservers)info);
        }
        return obj;
    }

    public static void deleteErrorMarkers(IResource resource) throws CoreException {
        IMarker[] markers = resource.findMarkers("org.eclipse.core.resources.problemmarker", false, 0);
        if (markers.length > 0) {
            resource.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
        }
    }

    public static Tuple<SimpleNode, Throwable> reparseDocument(ParserInfo info) {
        Tuple returnVar;
        block21: {
            String startDoc = info.document.get();
            if (startDoc.trim().length() == 0) {
                return new Tuple((Object)new Module(new stmtType[0]), null);
            }
            if (!startDoc.endsWith("\n") && !startDoc.endsWith("\r")) {
                startDoc = new StringBuffer(String.valueOf(startDoc)).append("\n").toString();
            }
            CharStream in = null;
            if (!USE_FAST_STREAM) {
                in = new ReaderCharStream(new StringReader(startDoc));
                throw new RuntimeException("This char stream reader was deprecated (it's maintained only for testing purposes).");
            }
            in = new FastCharStream(startDoc.toCharArray());
            startDoc = null;
            returnVar = new Tuple(null, null);
            AbstractPythonGrammar grammar = null;
            try {
                switch (info.grammarVersion) {
                    case 10: {
                        grammar = new PythonGrammar24(in);
                        break;
                    }
                    case 11: {
                        grammar = new PythonGrammar25(in);
                        break;
                    }
                    case 12: {
                        grammar = new PythonGrammar26(in);
                        break;
                    }
                    case 99: {
                        grammar = new PythonGrammar30(in);
                        break;
                    }
                    default: {
                        throw new RuntimeException(new StringBuffer("The grammar specified for parsing is not valid: ").append(info.grammarVersion).toString());
                    }
                }
                if (ENABLE_TRACING) {
                    grammar.enable_tracing();
                }
                SimpleNode newRoot = grammar.file_input();
                returnVar.o1 = newRoot;
                if (successfulParseListeners.size() > 0) {
                    Tuple3 param = new Tuple3((Object)((SimpleNode)returnVar.o1), (Object)((Throwable)returnVar.o2), (Object)info);
                    for (ICallback<Object, Tuple3<SimpleNode, Throwable, ParserInfo>> callback : successfulParseListeners) {
                        callback.call((Object)param);
                    }
                }
                returnVar.o2 = grammar.getErrorOnParsing();
            }
            catch (Throwable e) {
                if (DEBUG_SHOW_PARSE_ERRORS) {
                    e.printStackTrace();
                }
                if (grammar == null) {
                    throw new RuntimeException(e);
                }
                Throwable errorOnParsing = grammar.getErrorOnParsing();
                if (errorOnParsing != null) {
                    e = errorOnParsing;
                } else if (DEBUG_SHOW_PARSE_ERRORS) {
                    System.out.println("Unhandled error");
                    e.printStackTrace();
                }
                startDoc = null;
                in = null;
                grammar = null;
                if (e instanceof ParseException || e instanceof TokenMgrError) {
                    returnVar = new Tuple(null, (Object)e);
                }
                if (e.getClass().getName().indexOf("LookaheadSuccess") != -1) break block21;
                Log.log((Throwable)e);
            }
        }
        if (DEBUG_SHOW_PARSE_ERRORS && returnVar.o1 == null) {
            System.out.println(new StringBuffer("Unable to parse ").append(info).toString());
        }
        return returnVar;
    }

    public void resetTimeoutPreferences(boolean useAnalysisOnlyOnDocSave) {
        this.useAnalysisOnlyOnDocSave = useAnalysisOnlyOnDocSave;
    }

    public List<IParserObserver> getObservers() {
        return new ArrayList<IParserObserver>(this.parserListeners);
    }

    public static ErrorDescription createParserErrorMarkers(Throwable error, IAdaptable resource, IDocument doc) throws BadLocationException, CoreException {
        if (resource == null) {
            return null;
        }
        IResource fileAdapter = (IResource)resource.getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IResource"));
        if (fileAdapter == null) {
            return null;
        }
        ErrorDescription errDesc = PyParser.createErrorDesc(error, doc);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("message", errDesc.message);
        map.put("severity", Autobox.valueOf((int)2));
        map.put("lineNumber", Autobox.valueOf((int)errDesc.errorLine));
        map.put("charStart", Autobox.valueOf((int)errDesc.errorStart));
        map.put("charEnd", Autobox.valueOf((int)errDesc.errorEnd));
        map.put("transient", Autobox.valueOf((boolean)true));
        MarkerUtilities.createMarker((IResource)fileAdapter, map, (String)"org.eclipse.core.resources.problemmarker");
        return errDesc;
    }

    private static ErrorDescription createErrorDesc(Throwable error, IDocument doc) throws BadLocationException {
        int errorStart = -1;
        int errorEnd = -1;
        int errorLine = -1;
        String message = null;
        if (error instanceof ParseException) {
            ParseException parseErr = (ParseException)error;
            if (parseErr.currentToken == null) {
                IRegion endLine = doc.getLineInformationOfOffset(doc.getLength());
                errorStart = endLine.getOffset();
                errorEnd = endLine.getOffset() + endLine.getLength();
            } else {
                Token errorToken = parseErr.currentToken.next != null ? parseErr.currentToken.next : parseErr.currentToken;
                IRegion startLine = doc.getLineInformation(PyParser.getDocPosFromAstPos(errorToken.beginLine));
                IRegion endLine = errorToken.endLine == 0 ? startLine : doc.getLineInformation(PyParser.getDocPosFromAstPos(errorToken.endLine));
                errorStart = startLine.getOffset() + PyParser.getDocPosFromAstPos(errorToken.beginColumn);
                errorEnd = endLine.getOffset() + errorToken.endColumn;
            }
            message = parseErr.getMessage();
        } else if (error instanceof TokenMgrError) {
            TokenMgrError tokenErr = (TokenMgrError)error;
            IRegion startLine = doc.getLineInformation(tokenErr.errorLine - 1);
            errorStart = startLine.getOffset();
            errorEnd = startLine.getOffset() + tokenErr.errorColumn;
            message = tokenErr.getMessage();
        } else {
            Log.log((String)new StringBuffer("Error, expecting ParseException or TokenMgrError. Received: ").append(error).toString());
            return new ErrorDescription(null, 0, 0, 0);
        }
        errorLine = doc.getLineOfOffset(errorStart);
        if (message != null) {
            message = message.replaceAll("\\r\\n", " ");
            message = message.replaceAll("\\r", " ");
            message = message.replaceAll("\\n", " ");
        }
        return new ErrorDescription(message, errorLine, errorStart, errorEnd);
    }

    private static int getDocPosFromAstPos(int astPos) {
        if (astPos > 0) {
            --astPos;
        }
        return astPos;
    }

    public static class ParserInfo {
        public IDocument document;
        public boolean stillTryToChangeCurrentLine = true;
        public int currentLine = -1;
        public final Set<Integer> linesChanged = new HashSet<Integer>();
        public final int grammarVersion;
        public final String moduleName;
        public final File file;

        public ParserInfo(IDocument document, boolean stillTryToChangeCurrentLine, int grammarVersion) {
            this(document, stillTryToChangeCurrentLine, grammarVersion, -1, null, null);
        }

        public ParserInfo(IDocument document, boolean stillTryToChangeCurrentLine, IGrammarVersionProvider nature) throws MisconfigurationException {
            this(document, stillTryToChangeCurrentLine, nature.getGrammarVersion());
        }

        public ParserInfo(IDocument document, boolean stillTryToChangeCurrentLine, IGrammarVersionProvider nature, int currentLine, String moduleName, File file) throws MisconfigurationException {
            this(document, stillTryToChangeCurrentLine, nature.getGrammarVersion(), currentLine, moduleName, file);
        }

        public ParserInfo(IDocument document, boolean stillTryToChangeCurrentLine, IGrammarVersionProvider nature, int currentLine) throws MisconfigurationException {
            this(document, stillTryToChangeCurrentLine, nature.getGrammarVersion(), currentLine, null, null);
        }

        public ParserInfo(IDocument document, boolean stillTryToChangeCurrentLine, int grammarVersion, int currentLine, String name, File f) {
            this.document = document;
            this.stillTryToChangeCurrentLine = stillTryToChangeCurrentLine;
            this.grammarVersion = grammarVersion;
            this.moduleName = name;
            this.file = f;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("ParserInfo [");
            buf.append("file:");
            buf.append(this.file);
            buf.append("\nmoduleName:");
            buf.append(this.moduleName);
            buf.append("]");
            return buf.toString();
        }
    }
}

