/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.django.ui.wizards.project;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.python.pydev.core.ICallback0;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.ui.wizards.project.IWizardNewProjectNameAndLocationPage;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DjangoSettingsPage
extends WizardPage {
    public static final String CPYTHON = "cpython";
    public static final String JYTHON = "jython";
    static final Map<String, List<String>> DB_ENGINES = new HashMap<String, List<String>>(){
        {
            this.put(DjangoSettingsPage.CPYTHON, new ArrayList<String>(){
                {
                    this.add("postgresql_psycopg2");
                    this.add("sqlite3");
                    this.add("mysql");
                    this.add("oracle");
                    this.add("other (just type in combo)");
                }
            });
            this.put(DjangoSettingsPage.JYTHON, new ArrayList<String>(){
                {
                    this.add("doj.backends.zxjdbc.postgresql");
                    this.add("doj.backends.zxjdbc.sqlite3");
                    this.add("doj.backends.zxjdbc.mysql");
                    this.add("doj.backends.zxjdbc.oracle");
                    this.add("other (just type in combo)");
                }
            });
        }
    };
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private Combo engineCombo;
    private Text nameText;
    private Text hostText;
    private Text portText;
    private Text userText;
    private Text passText;
    private ICallback0<IWizardNewProjectNameAndLocationPage> projectPageCallback;

    public DjangoSettingsPage(String pageName, ICallback0<IWizardNewProjectNameAndLocationPage> projectPage) {
        super(pageName);
        this.projectPageCallback = projectPage;
        this.setTitle("Django Settings");
        this.setDescription("Basic Django Settings");
    }

    private Label newLabel(Composite parent, String label) {
        Label l = new Label(parent, 0);
        l.setText(label);
        l.setLayoutData((Object)new GridData(768));
        return l;
    }

    private Text newText(Composite parent) {
        Text t = new Text(parent, 2048);
        GridData gd = new GridData(768);
        gd.widthHint = 250;
        t.setLayoutData((Object)gd);
        return t;
    }

    public void setPreviousPage(IWizardPage page) {
        super.setPreviousPage(page);
        IWizardNewProjectNameAndLocationPage projectPage = (IWizardNewProjectNameAndLocationPage)this.projectPageCallback.call();
        String projectType = projectPage.getProjectType();
        List<String> engines = DB_ENGINES.get(projectType.startsWith(JYTHON) ? JYTHON : CPYTHON);
        this.engineCombo.removeAll();
        for (String engine : engines) {
            this.engineCombo.add(engine);
        }
        this.engineCombo.setText(engines.get(0));
    }

    public void createControl(Composite parent) {
        Composite topComp = new Composite(parent, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 1;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        topComp.setLayout((Layout)innerLayout);
        GridData gd = new GridData(1808);
        topComp.setLayoutData((Object)gd);
        Group group = new Group(topComp, 0);
        group.setText("Database settings");
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 8;
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        gd = new GridData(768);
        group.setLayoutData((Object)gd);
        this.newLabel((Composite)group, "Database &Engine");
        this.engineCombo = new Combo((Composite)group, 0);
        final IWizardNewProjectNameAndLocationPage projectPage = (IWizardNewProjectNameAndLocationPage)this.projectPageCallback.call();
        this.engineCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String selection = DjangoSettingsPage.this.engineCombo.getText();
                if (selection.endsWith("sqlite3")) {
                    String projectName = projectPage.getProjectName();
                    DjangoSettingsPage.this.nameText.setText(projectPage.getLocationPath().append(projectName).append("sqlite.db").toOSString());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gd = new GridData(768);
        this.engineCombo.setLayoutData((Object)gd);
        this.newLabel((Composite)group, "Database &Name");
        this.nameText = this.newText((Composite)group);
        this.newLabel((Composite)group, "Database &Host");
        this.hostText = this.newText((Composite)group);
        this.newLabel((Composite)group, "Database P&ort");
        this.portText = this.newText((Composite)group);
        this.newLabel((Composite)group, "&Username");
        this.userText = this.newText((Composite)group);
        this.newLabel((Composite)group, "&Password");
        this.passText = this.newText((Composite)group);
        this.passText.setEchoChar('*');
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)topComp);
    }

    public DjangoSettings getSettings() {
        DjangoSettings s = new DjangoSettings();
        s.databaseEngine = this.escapeSlashes(this.engineCombo.getText());
        s.databaseName = this.escapeSlashes(this.nameText.getText());
        s.databaseHost = this.escapeSlashes(this.hostText.getText());
        s.databasePort = this.escapeSlashes(this.portText.getText());
        s.databaseUser = this.escapeSlashes(this.userText.getText());
        s.databasePassword = this.escapeSlashes(this.passText.getText());
        return s;
    }

    private String escapeSlashes(String text) {
        return StringUtils.replaceAll((String)text, (String)"\\", (String)"\\\\\\\\");
    }

    public static class DjangoSettings {
        public String databaseEngine;
        public String databaseName;
        public String databaseHost;
        public String databasePort;
        public String databaseUser;
        public String databasePassword;
    }
}

