/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.Dictionary;
import java.util.Hashtable;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.AbstractDebugTargetWithTransmission;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;
import org.python.pydev.plugin.PydevPlugin;

public class DebuggerReader
implements Runnable {
    private static final boolean DEBUG = false;
    private Socket socket;
    private volatile boolean done = false;
    private Object lock = new Object();
    private Dictionary<Integer, AbstractDebuggerCommand> responseQueue = new Hashtable<Integer, AbstractDebuggerCommand>();
    private InputStreamReader in;
    private AbstractDebugTarget remote;

    public DebuggerReader(Socket s, AbstractDebugTargetWithTransmission r) throws IOException {
        this.remote = (AbstractDebugTarget)r;
        this.socket = s;
        InputStream sin = this.socket.getInputStream();
        this.in = new InputStreamReader(sin);
    }

    public void done() {
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToResponseQueue(AbstractDebuggerCommand cmd) {
        int sequence = cmd.getSequence();
        Dictionary<Integer, AbstractDebuggerCommand> dictionary = this.responseQueue;
        synchronized (dictionary) {
            this.responseQueue.put(new Integer(sequence), cmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommand(String cmdLine) {
        try {
            AbstractDebuggerCommand cmd;
            String[] cmdParsed = cmdLine.split("\t", 3);
            int cmdCode = Integer.parseInt(cmdParsed[0]);
            int seqCode = Integer.parseInt(cmdParsed[1]);
            String payload = URLDecoder.decode(cmdParsed[2], "UTF-8");
            Dictionary<Integer, AbstractDebuggerCommand> dictionary = this.responseQueue;
            synchronized (dictionary) {
                cmd = this.responseQueue.remove(new Integer(seqCode));
            }
            if (cmd == null) {
                if (this.remote != null) {
                    this.remote.processCommand(cmdParsed[0], cmdParsed[1], payload);
                } else {
                    PydevDebugPlugin.log(4, "internal error, command received no target", null);
                }
            } else {
                cmd.processResponse(cmdCode, payload);
            }
        }
        catch (Exception e) {
            PydevPlugin.log((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.done) {
            try {
                String cmdLine = this.readLine();
                if (cmdLine != null && cmdLine.trim().length() > 0) {
                    this.processCommand(cmdLine);
                }
                Object object = this.lock;
                synchronized (object) {
                    Thread.sleep(50L);
                }
            }
            catch (Exception e1) {
                this.done = true;
            }
            if (!this.done && this.socket != null && this.socket.isConnected()) continue;
            AbstractDebugTarget target = this.remote;
            if (target != null) {
                target.terminate();
            }
            this.done = true;
        }
    }

    private String readLine() throws IOException {
        int i;
        StringBuffer contents = new StringBuffer();
        while ((i = this.in.read()) != -1) {
            char c = (char)i;
            if (c == '\n' || c == '\r') {
                return contents.toString();
            }
            contents.append(c);
        }
        throw new IOException("Done");
    }
}

