/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.actions;

import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.python.pydev.core.REF;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.PyBreakpoint;
import org.python.pydev.debug.model.PyDebugModelPresentation;
import org.python.pydev.editorinput.PydevFileEditorInput;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBreakpointRulerAction
extends Action
implements IUpdate {
    protected IVerticalRulerInfo fInfo;
    protected ITextEditor fTextEditor;
    private IBreakpoint fBreakpoint;

    protected IBreakpoint getBreakpoint() {
        return this.fBreakpoint;
    }

    protected void setBreakpoint(IBreakpoint breakpoint) {
        this.fBreakpoint = breakpoint;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected void setTextEditor(ITextEditor textEditor) {
        this.fTextEditor = textEditor;
    }

    protected IVerticalRulerInfo getInfo() {
        return this.fInfo;
    }

    protected void setInfo(IVerticalRulerInfo info) {
        this.fInfo = info;
    }

    protected IBreakpoint determineBreakpoint() {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(PyDebugModelPresentation.PY_DEBUG_MODEL_ID);
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            if (breakpoint instanceof PyBreakpoint) {
                PyBreakpoint pyBreakpoint = (PyBreakpoint)breakpoint;
                try {
                    if (this.breakpointAtRulerLine(pyBreakpoint, this.getPydevFileEditorInput())) {
                        return pyBreakpoint;
                    }
                }
                catch (CoreException ce) {
                    PydevDebugPlugin.log(4, ce.getLocalizedMessage(), ce);
                }
            }
            ++i;
        }
        return null;
    }

    protected IDocument getDocument() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    protected boolean breakpointAtRulerLine(PyBreakpoint pyBreakpoint, PydevFileEditorInput pydevFileEditorInput) throws CoreException {
        block8: {
            IMarker marker;
            IDocument doc = this.getDocument();
            Position position = AbstractBreakpointRulerAction.getMarkerPosition(doc, marker = pyBreakpoint.getMarker());
            if (position != null) {
                block7: {
                    try {
                        int markerLineNumber = doc.getLineOfOffset(position.getOffset());
                        if (!(this.getResourceForDebugMarkers() instanceof IFile)) break block7;
                        int rulerLine = this.getInfo().getLineOfLastMouseButtonActivity();
                        if (rulerLine == markerLineNumber) {
                            if (this.getTextEditor().isDirty()) {
                                return pyBreakpoint.getLineNumber() == markerLineNumber + 1;
                            }
                            return true;
                        }
                        break block8;
                    }
                    catch (BadLocationException badLocationException) {}
                }
                if (AbstractBreakpointRulerAction.isInSameExternalEditor(marker, pydevFileEditorInput)) {
                    return true;
                }
            }
        }
        return false;
    }

    protected IResource getResourceForDebugMarkers() {
        return AbstractBreakpointRulerAction.getResourceForDebugMarkers(this.fTextEditor);
    }

    public boolean isExternalFileEditor() {
        return AbstractBreakpointRulerAction.isExternalFileEditor(this.fTextEditor);
    }

    public PydevFileEditorInput getPydevFileEditorInput() {
        return AbstractBreakpointRulerAction.getPydevFileEditorInput(this.fTextEditor);
    }

    public static boolean isExternalFileEditor(ITextEditor editor) {
        PydevFileEditorInput pydevFileEditorInput = AbstractBreakpointRulerAction.getPydevFileEditorInput(editor);
        return pydevFileEditorInput != null;
    }

    public static PydevFileEditorInput getPydevFileEditorInput(ITextEditor editor) {
        IEditorInput input = editor.getEditorInput();
        PydevFileEditorInput pydevFileEditorInput = null;
        if (input instanceof FileEditorInput) {
            return null;
        }
        if (input instanceof PydevFileEditorInput) {
            pydevFileEditorInput = (PydevFileEditorInput)input;
        } else {
            IPathEditorInput pathEditorInput;
            IPath path;
            File file;
            if (input instanceof IPathEditorInput && !(input instanceof FileEditorInput) && (file = (path = (pathEditorInput = (IPathEditorInput)input).getPath()).toFile()) != null && file.exists()) {
                pydevFileEditorInput = new PydevFileEditorInput(file);
            }
            try {
                if (input instanceof IURIEditorInput) {
                    IURIEditorInput iuriEditorInput = (IURIEditorInput)input;
                    return new PydevFileEditorInput(new File(iuriEditorInput.getURI()));
                }
            }
            catch (Throwable throwable) {}
        }
        return pydevFileEditorInput;
    }

    protected static boolean isInSameExternalEditor(IMarker marker, PydevFileEditorInput pydevFileEditorInput) throws CoreException {
        if (marker == null || pydevFileEditorInput == null) {
            return false;
        }
        String attribute = (String)marker.getAttribute("org.python.pydev.debug.PYDEV_EXTERNAL_PATH_ID");
        if (attribute != null) {
            File file = pydevFileEditorInput.getFile();
            if (file == null) {
                return false;
            }
            if (attribute.equals(REF.getFileAbsolutePath((File)file))) {
                return true;
            }
        }
        return false;
    }

    public static Position getMarkerPosition(IDocument document, IMarker marker) {
        int line;
        int end;
        int start = MarkerUtilities.getCharStart((IMarker)marker);
        if (start > (end = MarkerUtilities.getCharEnd((IMarker)marker))) {
            end = start + end;
            start = end - start;
            end -= start;
        }
        if (start == -1 && end == -1 && (line = MarkerUtilities.getLineNumber((IMarker)marker)) > 0 && document != null) {
            try {
                end = start = document.getLineOffset(line - 1);
            }
            catch (BadLocationException badLocationException) {}
        }
        if (start > -1 && end > -1) {
            return new Position(start, end - start);
        }
        return null;
    }

    public static IResource getResourceForDebugMarkers(ITextEditor textEditor) {
        IEditorInput input = textEditor.getEditorInput();
        IResource resource = (IResource)input.getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IFile"));
        if (resource == null) {
            resource = (IResource)input.getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IResource"));
        }
        if (resource == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return resource;
    }

    public static boolean includesRulerLine(Position position, IDocument document, IVerticalRulerInfo info) {
        if (position != null && info != null && document != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                int line = info.getLineOfLastMouseButtonActivity();
                if (line == markerLine) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    public static List<IMarker> getMarkersFromEditorResource(IResource resource, IDocument document, PydevFileEditorInput pydevFileEditorInput, IVerticalRulerInfo info, boolean onlyIncludeLastLineActivity) {
        if (onlyIncludeLastLineActivity) {
            Assert.isNotNull((Object)info);
        }
        ArrayList<IMarker> breakpoints = new ArrayList<IMarker>();
        try {
            ArrayList<IMarker> markers = new ArrayList<IMarker>();
            boolean isExternalFile = false;
            markers.addAll(Arrays.asList(resource.findMarkers("org.python.pydev.debug.pyStopBreakpointMarker", true, 2)));
            markers.addAll(Arrays.asList(resource.findMarkers("org.python.pydev.debug.pyConditionalStopBreakpointMarker", true, 2)));
            if (!(resource instanceof IFile)) {
                isExternalFile = true;
            }
            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            for (IMarker marker : markers) {
                IBreakpoint breakpoint;
                if (marker == null || (breakpoint = breakpointManager.getBreakpoint(marker)) == null || !breakpointManager.isRegistered(breakpoint)) continue;
                Position pos = AbstractBreakpointRulerAction.getMarkerPosition(document, marker);
                if (!isExternalFile) {
                    if (!onlyIncludeLastLineActivity) {
                        breakpoints.add(marker);
                        continue;
                    }
                    if (!AbstractBreakpointRulerAction.includesRulerLine(pos, document, info)) continue;
                    breakpoints.add(marker);
                    continue;
                }
                if (!AbstractBreakpointRulerAction.isInSameExternalEditor(marker, pydevFileEditorInput)) continue;
                if (!onlyIncludeLastLineActivity) {
                    breakpoints.add(marker);
                    continue;
                }
                if (!AbstractBreakpointRulerAction.includesRulerLine(pos, document, info)) continue;
                breakpoints.add(marker);
            }
        }
        catch (CoreException x) {
            PydevDebugPlugin.log(4, "Unexpected getMarkers error (recovered properly)", x);
        }
        return breakpoints;
    }
}

