/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.wizards;

import com.python.pydev.refactoring.wizards.IRefactorRenameProcess;
import com.python.pydev.refactoring.wizards.rename.PyRenameAnyLocalProcess;
import com.python.pydev.refactoring.wizards.rename.PyRenameAttributeProcess;
import com.python.pydev.refactoring.wizards.rename.PyRenameClassProcess;
import com.python.pydev.refactoring.wizards.rename.PyRenameFunctionProcess;
import com.python.pydev.refactoring.wizards.rename.PyRenameImportProcess;
import com.python.pydev.refactoring.wizards.rename.PyRenameLocalProcess;
import com.python.pydev.refactoring.wizards.rename.PyRenameParameterProcess;
import com.python.pydev.refactoring.wizards.rename.PyRenameSelfAttributeProcess;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.editor.codecompletion.revisited.visitors.AssignDefinition;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.codecompletion.revisited.visitors.KeywordParameterDefinition;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.visitors.NodeUtils;

public class RefactorProcessFactory {
    public static IRefactorRenameProcess getProcess(Definition definition, IPythonNature nature) {
        if (definition instanceof AssignDefinition) {
            AssignDefinition d = (AssignDefinition)definition;
            if (d.target.indexOf(46) != -1) {
                if (d.target.startsWith("self.")) {
                    return new PyRenameSelfAttributeProcess(definition, d.target);
                }
                return new PyRenameAttributeProcess(definition, d.target);
            }
            if (definition.scope != null && definition.scope.isLastClassDef()) {
                return new PyRenameAttributeProcess(definition, d.target);
            }
            return new PyRenameLocalProcess(definition);
        }
        if (definition.ast != null) {
            if (definition.ast instanceof ClassDef) {
                return new PyRenameClassProcess(definition);
            }
            if (definition.ast instanceof Name) {
                Name n = (Name)definition.ast;
                if (n.ctx == 6) {
                    return new PyRenameParameterProcess(definition);
                }
            }
            if (definition instanceof KeywordParameterDefinition) {
                return new PyRenameParameterProcess((KeywordParameterDefinition)definition, nature);
            }
            if (definition.ast instanceof FunctionDef) {
                return new PyRenameFunctionProcess(definition);
            }
            if (NodeUtils.isImport((SimpleNode)definition.ast)) {
                return new PyRenameImportProcess(definition);
            }
        } else {
            return new PyRenameImportProcess(definition);
        }
        if (definition.scope != null && definition.scope.isLastClassDef()) {
            return new PyRenameAttributeProcess(definition, definition.value);
        }
        return new PyRenameLocalProcess(definition);
    }

    public static IRefactorRenameProcess getRenameAnyProcess() {
        return new PyRenameAnyLocalProcess();
    }
}

