/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.event;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PTransformActivity;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class PNavigationEventHandler
extends PBasicInputEventHandler {
    public static final int NORTH = 0;
    public static final int SOUTH = 1;
    public static final int EAST = 2;
    public static final int WEST = 3;
    public static final int IN = 4;
    public static final int OUT = 5;
    private static Hashtable NODE_TO_GLOBAL_NODE_CENTER_MAPPING = new Hashtable();
    private PNode focusNode;
    private PActivity navigationActivity;

    public PNavigationEventHandler() {
        this.setEventFilter(new PInputEventFilter(16));
    }

    public void keyPressed(PInputEvent e) {
        PNode oldLocation = this.focusNode;
        switch (e.getKeyCode()) {
            case 37: {
                this.moveFocusLeft(e);
                break;
            }
            case 39: {
                this.moveFocusRight(e);
                break;
            }
            case 33: 
            case 38: {
                if (e.isAltDown()) {
                    this.moveFocusOut(e);
                    break;
                }
                this.moveFocusUp(e);
                break;
            }
            case 34: 
            case 40: {
                if (e.isAltDown()) {
                    this.moveFocusIn(e);
                    break;
                }
                this.moveFocusDown(e);
            }
        }
        if (this.focusNode != null && oldLocation != this.focusNode) {
            this.directCameraViewToFocus(e.getCamera(), this.focusNode, 500);
        }
    }

    public void mousePressed(PInputEvent aEvent) {
        this.moveFocusToMouseOver(aEvent);
        if (this.focusNode != null) {
            this.directCameraViewToFocus(aEvent.getCamera(), this.focusNode, 500);
            aEvent.getInputManager().setKeyboardFocus(aEvent.getPath());
        }
    }

    public void moveFocusDown(PInputEvent e) {
        PNode n = this.getNeighborInDirection(1);
        if (n != null) {
            this.focusNode = n;
        }
    }

    public void moveFocusIn(PInputEvent e) {
        PNode n = this.getNeighborInDirection(4);
        if (n != null) {
            this.focusNode = n;
        }
    }

    public void moveFocusLeft(PInputEvent e) {
        PNode n = this.getNeighborInDirection(3);
        if (n != null) {
            this.focusNode = n;
        }
    }

    public void moveFocusOut(PInputEvent e) {
        PNode n = this.getNeighborInDirection(5);
        if (n != null) {
            this.focusNode = n;
        }
    }

    public void moveFocusRight(PInputEvent e) {
        PNode n = this.getNeighborInDirection(2);
        if (n != null) {
            this.focusNode = n;
        }
    }

    public void moveFocusUp(PInputEvent e) {
        PNode n = this.getNeighborInDirection(0);
        if (n != null) {
            this.focusNode = n;
        }
    }

    public void moveFocusToMouseOver(PInputEvent e) {
        PNode focus = e.getPickedNode();
        if (!(focus instanceof PCamera)) {
            this.focusNode = focus;
        }
    }

    public PNode getNeighborInDirection(int aDirection) {
        if (this.focusNode == null) {
            return null;
        }
        NODE_TO_GLOBAL_NODE_CENTER_MAPPING.clear();
        Point2D highlightCenter = this.focusNode.getGlobalFullBounds().getCenter2D();
        NODE_TO_GLOBAL_NODE_CENTER_MAPPING.put(this.focusNode, highlightCenter);
        List l = this.getNeighbors();
        this.sortNodesByDistanceFromPoint(l, highlightCenter);
        Iterator i = l.iterator();
        while (i.hasNext()) {
            PNode each = (PNode)i.next();
            if (!this.nodeIsNeighborInDirection(each, aDirection)) continue;
            return each;
        }
        return null;
    }

    public List getNeighbors() {
        ArrayList<PNode> result = new ArrayList<PNode>();
        if (this.focusNode == null) {
            return result;
        }
        if (this.focusNode.getParent() == null) {
            return result;
        }
        PNode focusParent = this.focusNode.getParent();
        ListIterator i = focusParent.getChildrenIterator();
        while (i.hasNext()) {
            PNode each = (PNode)i.next();
            if (each == this.focusNode || !each.getPickable()) continue;
            result.add(each);
        }
        result.add(focusParent);
        i = this.focusNode.getChildrenIterator();
        while (i.hasNext()) {
            result.add((PNode)i.next());
        }
        return result;
    }

    public boolean nodeIsNeighborInDirection(PNode aNode, int aDirection) {
        switch (aDirection) {
            case 4: {
                return aNode.isDescendentOf(this.focusNode);
            }
            case 5: {
                return aNode.isAncestorOf(this.focusNode);
            }
        }
        if (aNode.isAncestorOf(this.focusNode) || aNode.isDescendentOf(this.focusNode)) {
            return false;
        }
        Point2D highlightCenter = (Point2D)NODE_TO_GLOBAL_NODE_CENTER_MAPPING.get(this.focusNode);
        Point2D nodeCenter = (Point2D)NODE_TO_GLOBAL_NODE_CENTER_MAPPING.get(aNode);
        double ytest1 = nodeCenter.getX() - highlightCenter.getX() + highlightCenter.getY();
        double ytest2 = -nodeCenter.getX() + highlightCenter.getX() + highlightCenter.getY();
        switch (aDirection) {
            case 0: {
                if (!(nodeCenter.getY() < highlightCenter.getY()) || !(nodeCenter.getY() < ytest1) || !(nodeCenter.getY() < ytest2)) break;
                return true;
            }
            case 2: {
                if (!(nodeCenter.getX() > highlightCenter.getX()) || !(nodeCenter.getY() < ytest1) || !(nodeCenter.getY() > ytest2)) break;
                return true;
            }
            case 1: {
                if (!(nodeCenter.getY() > highlightCenter.getY()) || !(nodeCenter.getY() > ytest1) || !(nodeCenter.getY() > ytest2)) break;
                return true;
            }
            case 3: {
                if (!(nodeCenter.getX() < highlightCenter.getX()) || !(nodeCenter.getY() > ytest1) || !(nodeCenter.getY() < ytest2)) break;
                return true;
            }
        }
        return false;
    }

    public void sortNodesByDistanceFromPoint(List aNodesList, final Point2D aPoint) {
        Collections.sort(aNodesList, new Comparator(){

            public int compare(Object o1, Object o2) {
                PNode each1 = (PNode)o1;
                PNode each2 = (PNode)o2;
                Point2D each1Center = each1.getGlobalFullBounds().getCenter2D();
                Point2D each2Center = each2.getGlobalFullBounds().getCenter2D();
                NODE_TO_GLOBAL_NODE_CENTER_MAPPING.put(each1, each1Center);
                NODE_TO_GLOBAL_NODE_CENTER_MAPPING.put(each2, each2Center);
                double distance1 = aPoint.distance(each1Center);
                double distance2 = aPoint.distance(each2Center);
                if (distance1 < distance2) {
                    return -1;
                }
                if (distance1 == distance2) {
                    return 0;
                }
                return 1;
            }
        });
    }

    protected PActivity animateCameraViewTransformTo(PCamera aCamera, AffineTransform aTransform, int duration) {
        boolean wasOldAnimation = false;
        if (this.navigationActivity != null) {
            this.navigationActivity.terminate();
            wasOldAnimation = true;
        }
        if (duration == 0) {
            aCamera.setViewTransform(aTransform);
            return null;
        }
        PAffineTransform source = aCamera.getViewTransformReference();
        if (!source.equals(aTransform)) {
            this.navigationActivity = aCamera.animateViewToTransform(aTransform, duration);
            ((PTransformActivity)this.navigationActivity).setSlowInSlowOut(!wasOldAnimation);
            return this.navigationActivity;
        }
        return null;
    }

    public PActivity directCameraViewToFocus(PCamera aCamera, PNode aFocusNode, int duration) {
        PAffineTransform originalViewTransform = aCamera.getViewTransform();
        PDimension d = new PDimension(1.0, 0.0);
        this.focusNode.globalToLocal(d);
        double scaleFactor = d.getWidth() / aCamera.getViewScale();
        Point2D scalePoint = this.focusNode.getGlobalFullBounds().getCenter2D();
        if (scaleFactor != 1.0) {
            aCamera.scaleViewAboutPoint(scaleFactor, scalePoint.getX(), scalePoint.getY());
        }
        aCamera.animateViewToPanToBounds(this.focusNode.getGlobalFullBounds(), 0L);
        PAffineTransform resultingTransform = aCamera.getViewTransform();
        aCamera.setViewTransform(originalViewTransform);
        return this.animateCameraViewTransformTo(aCamera, resultingTransform, duration);
    }

    protected void fillViewWhiteSpace(PCamera aCamera) {
        PBounds rootBounds = aCamera.getRoot().getFullBoundsReference();
        PBounds viewBounds = aCamera.getViewBounds();
        if (!rootBounds.contains(aCamera.getViewBounds())) {
            aCamera.animateViewToPanToBounds(rootBounds, 0L);
            aCamera.animateViewToPanToBounds(this.focusNode.getGlobalFullBounds(), 0L);
            double dx = 0.0;
            double dy = 0.0;
            viewBounds = aCamera.getViewBounds();
            if (viewBounds.getWidth() > rootBounds.getWidth()) {
                double boundsCenterX = rootBounds.getMinX() + rootBounds.getWidth() / 2.0;
                double viewBoundsCenterX = viewBounds.getMinX() + viewBounds.getWidth() / 2.0;
                dx = viewBoundsCenterX - boundsCenterX;
            }
            if (viewBounds.getHeight() > rootBounds.getHeight()) {
                double boundsCenterY = rootBounds.getMinY() + rootBounds.getHeight() / 2.0;
                double viewBoundsCenterY = viewBounds.getMinY() + viewBounds.getHeight() / 2.0;
                dy = viewBoundsCenterY - boundsCenterY;
            }
            aCamera.translateView(dx, dy);
        }
    }
}

