/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import com.rc.retroweaver.runtime.Autobox;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ISystemModulesManager;
import org.python.pydev.core.IToken;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.cache.LRUCache;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.codecompletion.revisited.ModulesManager;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.editor.codecompletion.revisited.modules.CompiledModule;
import org.python.pydev.editor.codecompletion.revisited.modules.EmptyModule;
import org.python.pydev.editor.codecompletion.revisited.modules.PredefinedSourceModule;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemModulesManager
extends ModulesManager
implements ISystemModulesManager {
    private static final long serialVersionUID = 5L;
    private transient IPythonNature nature;
    private transient InterpreterInfo info;
    private LRUCache<String, String> builtinsNotConsidered;
    private transient Map<File, Long> predefinedFilesNotParsedToTimestamp;

    public void setInfo(Object interpreterInfo) {
        this.info = (InterpreterInfo)interpreterInfo;
    }

    public String[] getBuiltins() {
        return this.info.getBuiltins();
    }

    public void setPythonNature(IPythonNature nature) {
        Assert.isTrue((boolean)(nature instanceof SystemPythonNature));
        Assert.isTrue((((SystemPythonNature)nature).info == this.info ? 1 : 0) != 0);
        this.nature = nature;
    }

    public IPythonNature getNature() {
        if (this.nature == null) {
            IInterpreterManager manager;
            int interpreterType = this.info.getInterpreterType();
            switch (interpreterType) {
                case 1: {
                    manager = PydevPlugin.getJythonInterpreterManager();
                    break;
                }
                case 0: {
                    manager = PydevPlugin.getPythonInterpreterManager();
                    break;
                }
                case 2: {
                    manager = PydevPlugin.getIronpythonInterpreterManager();
                    break;
                }
                default: {
                    throw new RuntimeException(new StringBuffer("Don't know how to handle: ").append(interpreterType).toString());
                }
            }
            this.nature = new SystemPythonNature(manager, this.info);
        }
        return this.nature;
    }

    public ISystemModulesManager getSystemModulesManager() {
        return this;
    }

    public IModule getModule(String name, IPythonNature nature, boolean checkSystemManager, boolean dontSearchInit) {
        return this.getModule(name, nature, dontSearchInit);
    }

    public String resolveModule(String full, boolean checkSystemManager) {
        return super.resolveModule(full);
    }

    public List<String> getCompletePythonPath(IInterpreterInfo interpreter, IInterpreterManager manager) {
        if (interpreter == null) {
            throw new RuntimeException("The interpreter must be specified (received null)");
        }
        return interpreter.getPythonPath();
    }

    public IModule getRelativeModule(String name, IPythonNature nature) {
        return super.getModule(name, nature, true);
    }

    @Override
    protected void onChangePythonpath(SortedMap<ModulesKey, ModulesKey> keys) {
        String[] builtins = this.getBuiltins();
        if (builtins != null) {
            int i = 0;
            while (i < builtins.length) {
                String name = builtins[i];
                ModulesKey k = new ModulesKey(name, null);
                keys.put(k, k);
                ++i;
            }
        }
    }

    private LRUCache<String, String> getBuiltinsNotConsidered() {
        if (this.builtinsNotConsidered == null) {
            this.builtinsNotConsidered = new LRUCache(500);
        }
        return this.builtinsNotConsidered;
    }

    private boolean contains(IToken[] tokens, String rep) {
        IToken[] iTokenArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            IToken token = iTokenArray[n2];
            if (token.getRepresentation().equals(rep)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public AbstractModule getBuiltinModule(String name, IPythonNature nature, boolean dontSearchInit) {
        AbstractModule n = null;
        String[] builtins = this.getBuiltins();
        if (builtins == null || this.info == null) {
            return null;
        }
        ModulesKey keyForCacheAccess = new ModulesKey(null, null);
        File predefinedModule = this.info.getPredefinedModule(name);
        if (predefinedModule != null && predefinedModule.exists()) {
            PredefinedSourceModule predefinedSourceModule;
            keyForCacheAccess.name = name;
            keyForCacheAccess.file = predefinedModule;
            n = cache.getObj(keyForCacheAccess, this);
            if (n instanceof PredefinedSourceModule && (predefinedSourceModule = (PredefinedSourceModule)n).isSynched()) {
                return n;
            }
            boolean tryToParse = true;
            Long lastModified = null;
            if (this.predefinedFilesNotParsedToTimestamp == null) {
                this.predefinedFilesNotParsedToTimestamp = new HashMap<File, Long>();
            } else {
                Long lastTimeChanged = this.predefinedFilesNotParsedToTimestamp.get(predefinedModule);
                if (lastTimeChanged != null) {
                    lastModified = Autobox.valueOf((long)predefinedModule.lastModified());
                    if (lastTimeChanged == lastModified) {
                        tryToParse = false;
                    } else {
                        this.predefinedFilesNotParsedToTimestamp.remove(predefinedModule);
                    }
                }
            }
            if (tryToParse) {
                try {
                    IDocument doc = REF.getDocFromFile((File)predefinedModule);
                    IGrammarVersionProvider provider = new IGrammarVersionProvider(){

                        public int getGrammarVersion() throws MisconfigurationException {
                            return 99;
                        }
                    };
                    Tuple obj = PyParser.reparseDocument((PyParser.ParserInfo)new PyParser.ParserInfo(doc, true, provider, 0, name, predefinedModule));
                    if (obj.o2 != null) {
                        if (lastModified == null) {
                            lastModified = Autobox.valueOf((long)predefinedModule.lastModified());
                        }
                        this.predefinedFilesNotParsedToTimestamp.put(predefinedModule, lastModified);
                        PydevPlugin.log(new StringBuffer("Unable to parse: ").append(predefinedModule).toString(), (Throwable)obj.o2);
                    } else if (obj.o1 != null) {
                        n = new PredefinedSourceModule(name, predefinedModule, (SimpleNode)obj.o1, (Throwable)obj.o2);
                        this.doAddSingleModule(keyForCacheAccess, n);
                        return n;
                    }
                }
                catch (Throwable e) {
                    Log.log((Throwable)e);
                }
            }
        }
        boolean foundStartingWithBuiltin = false;
        FastStringBuffer buffer = null;
        int i = 0;
        while (i < builtins.length) {
            String forcedBuiltin = builtins[i];
            if (name.startsWith(forcedBuiltin)) {
                if (name.length() > forcedBuiltin.length() && name.charAt(forcedBuiltin.length()) == '.') {
                    foundStartingWithBuiltin = true;
                    keyForCacheAccess.name = name;
                    n = cache.getObj(keyForCacheAccess, this);
                    if (n == null && !dontSearchInit) {
                        if (buffer == null) {
                            buffer = new FastStringBuffer();
                        } else {
                            buffer.clear();
                        }
                        keyForCacheAccess.name = buffer.append(name).append(".__init__").toString();
                        n = cache.getObj(keyForCacheAccess, this);
                    }
                    if (n instanceof EmptyModule || n instanceof SourceModule) {
                        n = new CompiledModule(name, 4, nature.getAstManager());
                        this.doAddSingleModule(new ModulesKey(n.getName(), null), n);
                        return n;
                    }
                }
                if (name.equals(forcedBuiltin)) {
                    keyForCacheAccess.name = name;
                    n = cache.getObj(keyForCacheAccess, this);
                    if (n == null || n instanceof EmptyModule || n instanceof SourceModule) {
                        n = new CompiledModule(name, 4, nature.getAstManager());
                        this.doAddSingleModule(new ModulesKey(n.getName(), null), n);
                        return n;
                    }
                }
                if (n instanceof CompiledModule) {
                    return n;
                }
            }
            ++i;
        }
        if (foundStartingWithBuiltin) {
            LRUCache<String, String> notConsidered = this.getBuiltinsNotConsidered();
            if (notConsidered.getObj((Object)name) != null) {
                return null;
            }
            n = new CompiledModule(name, 4, nature.getAstManager());
            IToken[] globalTokens = n.getGlobalTokens();
            if (globalTokens.length > 0 && this.contains(globalTokens, "__file__")) {
                this.doAddSingleModule(new ModulesKey(name, null), n);
                return n;
            }
            notConsidered.add((Object)name, (Object)name);
            return null;
        }
        return null;
    }

    @Override
    public IModule getModule(String name, IPythonNature nature, boolean dontSearchInit) {
        AbstractModule n = this.getBuiltinModule(name, nature, dontSearchInit);
        if (n != null) {
            return n;
        }
        return super.getModule(name, nature, dontSearchInit);
    }

    public IModule getModuleWithoutBuiltins(String name, IPythonNature nature, boolean dontSearchInit) {
        return super.getModule(name, nature, dontSearchInit);
    }

    public Tuple<IModule, IModulesManager> getModuleAndRelatedModulesManager(String name, IPythonNature nature, boolean checkSystemManager, boolean dontSearchInit) {
        IModule module = this.getModule(name, nature, checkSystemManager, dontSearchInit);
        if (module != null) {
            return new Tuple((Object)module, (Object)this);
        }
        return null;
    }

    public /* synthetic */ IModule getBuiltinModule(String string, IPythonNature iPythonNature, boolean bl) {
        return this.getBuiltinModule(string, iPythonNature, bl);
    }
}

