/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.templates;

import java.io.File;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.dltk.console.ui.IScriptConsoleViewer;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;
import org.python.pydev.editor.codefolding.PySourceViewer;

public final class PyDocumentTemplateContext
extends DocumentTemplateContext {
    private final String indentTo;
    private IIndentPrefs indentPrefs;
    public ITextViewer viewer;

    PyDocumentTemplateContext(TemplateContextType type, IDocument document, int offset, int length, String indentTo, IIndentPrefs indentPrefs) {
        super(type, document, offset, length);
        this.indentTo = indentTo;
        this.indentPrefs = indentPrefs;
    }

    public PyDocumentTemplateContext(TemplateContextType type, IDocument document, int offset, int length, String indentTo, ITextViewer viewer) {
        this(type, document, offset, length, indentTo, PyDocumentTemplateContext.getIndentPrefs(viewer));
        this.viewer = viewer;
    }

    public File getEditorFile() {
        if (this.viewer instanceof PySourceViewer) {
            return ((PySourceViewer)this.viewer).getEdit().getEditorFile();
        }
        return new File("");
    }

    public int getGrammarVersion() {
        IScriptConsoleViewer v;
        IInterpreterInfo interpreterInfo;
        if (this.viewer instanceof PySourceViewer) {
            try {
                IPythonNature nature = ((PySourceViewer)this.viewer).getEdit().getPythonNature();
                if (nature != null) {
                    return nature.getGrammarVersion();
                }
            }
            catch (MisconfigurationException misconfigurationException) {}
        }
        if (this.viewer instanceof IScriptConsoleViewer && (interpreterInfo = (v = (IScriptConsoleViewer)this.viewer).getInterpreterInfo()) != null) {
            return interpreterInfo.getGrammarVersion();
        }
        return 12;
    }

    public String getModuleName() {
        if (this.viewer instanceof PySourceViewer) {
            try {
                PySourceViewer pyViewer = (PySourceViewer)this.viewer;
                PyEdit edit = pyViewer.getEdit();
                IPythonNature nature = edit.getPythonNature();
                if (nature != null) {
                    return nature.resolveModule(edit.getEditorFile());
                }
            }
            catch (MisconfigurationException misconfigurationException) {}
        }
        return "";
    }

    private static IIndentPrefs getIndentPrefs(ITextViewer viewer) {
        if (viewer instanceof PySourceViewer) {
            PySourceViewer pyViewer = (PySourceViewer)viewer;
            return pyViewer.getEdit().getIndentPrefs();
        }
        return DefaultIndentPrefs.get();
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        String spacesIndentString = StringUtils.createSpaceString((int)this.indentPrefs.getTabWidth());
        String pattern = template.getPattern();
        List splitted = StringUtils.splitInLines((String)pattern);
        boolean changed = false;
        if (this.indentPrefs.getUseSpaces(true)) {
            if (pattern.indexOf("\t") != -1) {
                template = this.createNewTemplate(template, StringUtils.replaceAll((String)pattern, (String)"\t", (String)spacesIndentString));
                changed = true;
            }
        } else if (pattern.indexOf(spacesIndentString) != -1) {
            FastStringBuffer newPattern = new FastStringBuffer();
            FastStringBuffer newTabsIndent = new FastStringBuffer();
            int i = 0;
            while (i < splitted.size()) {
                String string = (String)splitted.get(i);
                int spacesFound = 0;
                while (string.length() > 0 && string.charAt(0) == ' ') {
                    string = string.substring(1);
                    ++spacesFound;
                }
                int tabsToAdd = 0;
                if (spacesFound > 0) {
                    tabsToAdd = spacesFound / spacesIndentString.length();
                    if (spacesFound % spacesIndentString.length() != 0) {
                        ++tabsToAdd;
                    }
                    newTabsIndent.clear();
                    int j = 0;
                    while (j < tabsToAdd) {
                        newTabsIndent.append("\t");
                        ++j;
                    }
                    newPattern.append(newTabsIndent);
                }
                newPattern.append(string);
                ++i;
            }
            template = this.createNewTemplate(template, newPattern.toString());
            changed = true;
        }
        if (changed) {
            pattern = template.getPattern();
            splitted = StringUtils.splitInLines((String)pattern);
        }
        String indentToStr = this.indentTo != null ? this.indentTo : "";
        String endLineDelim = PySelection.getDelimiter((IDocument)this.getDocument());
        int size = splitted.size();
        if (size > 0) {
            FastStringBuffer buffer = new FastStringBuffer("", pattern.length() + size * 2 + (size + 1) * indentToStr.length());
            int i = 0;
            while (i < size) {
                if (i != 0) {
                    buffer.append(indentToStr);
                }
                String str = (String)splitted.get(i);
                boolean hasNewLine = false;
                if (str.endsWith("\r") || str.endsWith("\n")) {
                    hasNewLine = true;
                    str = str.endsWith("\r\n") ? str.substring(0, str.length() - 2) : str.substring(0, str.length() - 1);
                }
                buffer.append(str);
                if (hasNewLine) {
                    buffer.append(endLineDelim);
                }
                ++i;
            }
            template = this.createNewTemplate(template, buffer.toString());
        }
        TemplateTranslator translator = new TemplateTranslator();
        TemplateBuffer templateBuffer = translator.translate(template);
        this.getContextType().resolve(templateBuffer, (TemplateContext)this);
        return templateBuffer;
    }

    private Template createNewTemplate(Template template, String newString) {
        return new Template(template.getName(), template.getDescription(), template.getContextTypeId(), newString, template.isAutoInsertable());
    }
}

