/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.prettyprinterv2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assert;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.AugAssign;
import org.python.pydev.parser.jython.ast.BinOp;
import org.python.pydev.parser.jython.ast.BoolOp;
import org.python.pydev.parser.jython.ast.Break;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Compare;
import org.python.pydev.parser.jython.ast.Comprehension;
import org.python.pydev.parser.jython.ast.Continue;
import org.python.pydev.parser.jython.ast.Delete;
import org.python.pydev.parser.jython.ast.Dict;
import org.python.pydev.parser.jython.ast.DictComp;
import org.python.pydev.parser.jython.ast.Ellipsis;
import org.python.pydev.parser.jython.ast.Exec;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.For;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Global;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.IfExp;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Index;
import org.python.pydev.parser.jython.ast.Lambda;
import org.python.pydev.parser.jython.ast.List;
import org.python.pydev.parser.jython.ast.ListComp;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.Num;
import org.python.pydev.parser.jython.ast.Pass;
import org.python.pydev.parser.jython.ast.Print;
import org.python.pydev.parser.jython.ast.Raise;
import org.python.pydev.parser.jython.ast.Repr;
import org.python.pydev.parser.jython.ast.Return;
import org.python.pydev.parser.jython.ast.Set;
import org.python.pydev.parser.jython.ast.SetComp;
import org.python.pydev.parser.jython.ast.Slice;
import org.python.pydev.parser.jython.ast.Starred;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.StrJoin;
import org.python.pydev.parser.jython.ast.Subscript;
import org.python.pydev.parser.jython.ast.TryExcept;
import org.python.pydev.parser.jython.ast.TryFinally;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.UnaryOp;
import org.python.pydev.parser.jython.ast.VisitorBase;
import org.python.pydev.parser.jython.ast.While;
import org.python.pydev.parser.jython.ast.With;
import org.python.pydev.parser.jython.ast.WithItem;
import org.python.pydev.parser.jython.ast.WithItemType;
import org.python.pydev.parser.jython.ast.Yield;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.jython.ast.argumentsType;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.jython.ast.comprehensionType;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.excepthandlerType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.keywordType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.jython.ast.suiteType;

public class MakeAstValidForPrettyPrintingVisitor
extends VisitorBase {
    int currentLine = 0;
    int currentCol = 0;
    private int isInMultiLine;

    private void nextLine() {
        this.nextLine(false);
    }

    private void nextLine(boolean force) {
        if (force || this.isInMultiLine == 0) {
            ++this.currentLine;
            this.currentCol = 0;
        }
    }

    private void nextCol() {
        ++this.currentCol;
    }

    protected Object unhandled_node(SimpleNode node) throws Exception {
        throw new RuntimeException("Unhandled: " + node);
    }

    public Object visitIndex(Index node) throws Exception {
        this.fixNode(node);
        this.traverse(node);
        this.fixAfterNode(node);
        return null;
    }

    public Object visitModule(Module node) throws Exception {
        this.fixNode(node);
        this.traverse(node);
        this.fixAfterNode(node);
        return null;
    }

    public void traverse(SimpleNode node) throws Exception {
        node.traverse(this);
    }

    protected void fixAfterNode(SimpleNode node) {
        if (node.specialsAfter != null) {
            Iterator<Object> iterator = node.specialsAfter.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (!(o instanceof commentType)) continue;
                this.fixNode((SimpleNode)o);
                this.nextLine();
            }
        }
    }

    protected void fixNode(SimpleNode node) {
        if (node instanceof stmtType) {
            this.nextLine();
        }
        if (node.specialsBefore != null) {
            Iterator<Object> iterator = node.specialsBefore.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (!(o instanceof commentType)) continue;
                this.fixNode((SimpleNode)o);
                this.nextLine();
            }
        }
        if (node.beginLine < this.currentLine) {
            node.beginLine = this.currentLine;
            node.beginColumn = this.currentCol;
        } else if (node.beginLine == this.currentLine && node.beginColumn < this.currentCol) {
            node.beginColumn = this.currentCol;
        } else {
            this.currentLine = node.beginLine;
            this.currentCol = node.beginColumn;
        }
        if (node instanceof stmtType) {
            this.nextCol();
        }
    }

    public static void makeValid(SimpleNode node) throws Exception {
        node.accept(new MakeAstValidForPrettyPrintingVisitor());
    }

    public Object visitAssign(Assign node) throws Exception {
        this.fixNode(node);
        int i = 0;
        while (i < node.targets.length) {
            exprType target = node.targets[i];
            target.accept(this);
            this.nextCol();
            ++i;
        }
        node.value.accept(this);
        this.nextCol();
        this.fixAfterNode(node);
        return null;
    }

    public Object visitAugAssign(AugAssign node) throws Exception {
        this.fixNode(node);
        node.target.accept(this);
        this.nextCol();
        node.value.accept(this);
        this.nextCol();
        this.fixAfterNode(node);
        return null;
    }

    public Object visitBinOp(BinOp node) throws Exception {
        this.fixNode(node);
        node.left.accept(this);
        this.nextCol();
        node.right.accept(this);
        this.nextCol();
        this.fixAfterNode(node);
        return null;
    }

    public Object visitUnaryOp(UnaryOp node) throws Exception {
        this.fixNode(node);
        node.operand.accept(this);
        this.fixAfterNode(node);
        return null;
    }

    public Object visitBoolOp(BoolOp node) throws Exception {
        this.fixNode(node);
        int i = 0;
        while (i < node.values.length) {
            node.values[i].accept(this);
            ++i;
        }
        this.fixAfterNode(node);
        return null;
    }

    public Object visitCompare(Compare node) throws Exception {
        this.fixNode(node);
        node.left.accept(this);
        int i = 0;
        while (i < node.comparators.length) {
            node.comparators[i].accept(this);
            ++i;
        }
        this.fixAfterNode(node);
        return null;
    }

    public Object visitEllipsis(Ellipsis node) throws Exception {
        this.fixNode(node);
        this.fixAfterNode(node);
        return null;
    }

    public Object visitDict(Dict node) throws Exception {
        this.fixNode(node);
        this.pushInMultiline();
        exprType[] keys = node.keys;
        exprType[] values = node.values;
        int i = 0;
        while (i < values.length) {
            keys[i].accept(this);
            values[i].accept(this);
            ++i;
        }
        this.popInMultiline();
        this.fixAfterNode(node);
        return null;
    }

    public Object visitTuple(Tuple node) throws Exception {
        this.fixNode(node);
        this.pushInMultiline();
        if (node.elts != null && node.elts.length > 0) {
            this.visitCommaSeparated(node.elts, node.endsWithComma);
        }
        this.popInMultiline();
        this.fixAfterNode(node);
        return null;
    }

    private void pushInMultiline() {
        ++this.isInMultiLine;
    }

    private void popInMultiline() {
        --this.isInMultiLine;
    }

    private void visitCommaSeparated(exprType[] elts, boolean requireEndWithCommaSingleElement) throws Exception {
        if (elts != null) {
            int i = 0;
            while (i < elts.length) {
                if (elts[i] != null) {
                    elts[i].accept(this);
                }
                ++i;
            }
        }
    }

    public Object visitList(List node) throws Exception {
        this.fixNode(node);
        this.pushInMultiline();
        this.visitCommaSeparated(node.elts, false);
        this.popInMultiline();
        this.fixAfterNode(node);
        return null;
    }

    public Object visitListComp(ListComp node) throws Exception {
        this.fixNode(node);
        node.elt.accept(this);
        comprehensionType[] comprehensionTypeArray = node.generators;
        int n = node.generators.length;
        int n2 = 0;
        while (n2 < n) {
            comprehensionType c = comprehensionTypeArray[n2];
            c.accept(this);
            ++n2;
        }
        this.fixAfterNode(node);
        return null;
    }

    public Object visitSetComp(SetComp node) throws Exception {
        this.fixNode(node);
        node.elt.accept(this);
        comprehensionType[] comprehensionTypeArray = node.generators;
        int n = node.generators.length;
        int n2 = 0;
        while (n2 < n) {
            comprehensionType c = comprehensionTypeArray[n2];
            c.accept(this);
            ++n2;
        }
        this.fixAfterNode(node);
        return null;
    }

    public Object visitDictComp(DictComp node) throws Exception {
        this.fixNode(node);
        node.key.accept(this);
        node.value.accept(this);
        comprehensionType[] comprehensionTypeArray = node.generators;
        int n = node.generators.length;
        int n2 = 0;
        while (n2 < n) {
            comprehensionType c = comprehensionTypeArray[n2];
            c.accept(this);
            ++n2;
        }
        this.fixAfterNode(node);
        return null;
    }

    public Object visitSet(Set node) throws Exception {
        this.fixNode(node);
        this.visitCommaSeparated(node.elts, false);
        this.fixAfterNode(node);
        return null;
    }

    private SimpleNode[] reverseNodeArray(SimpleNode[] expressions) {
        ArrayList<SimpleNode> ifs = new ArrayList<SimpleNode>(Arrays.asList(expressions));
        Collections.reverse(ifs);
        SimpleNode[] ifsInOrder = ifs.toArray(new SimpleNode[0]);
        return ifsInOrder;
    }

    public Object visitComprehension(Comprehension node) throws Exception {
        this.fixNode(node);
        node.target.accept(this);
        node.iter.accept(this);
        SimpleNode[] simpleNodeArray = this.reverseNodeArray(node.ifs);
        int n = simpleNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleNode s = simpleNodeArray[n2];
            s.accept(this);
            ++n2;
        }
        this.fixAfterNode(node);
        return null;
    }

    public Object visitWhile(While node) throws Exception {
        this.fixNode(node);
        node.test.accept(this);
        if (node.body == null || node.body.length == 0) {
            node.body = new stmtType[]{new Pass()};
        }
        stmtType[] stmtTypeArray = node.body;
        int n = node.body.length;
        int n2 = 0;
        while (n2 < n) {
            stmtType n3 = stmtTypeArray[n2];
            n3.accept(this);
            ++n2;
        }
        this.endSuiteWithOrElse(node.orelse);
        this.fixAfterNode(node);
        return null;
    }

    public Object visitWith(With node) throws Exception {
        this.fixNode(node);
        WithItemType[] withItemTypeArray = node.with_item;
        int n = node.with_item.length;
        int n2 = 0;
        while (n2 < n) {
            WithItemType n3 = withItemTypeArray[n2];
            n3.accept(this);
            ++n2;
        }
        if (node.body != null) {
            node.body.accept(this);
        }
        this.fixAfterNode(node);
        return null;
    }

    public Object visitWithItem(WithItem node) throws Exception {
        this.fixNode(node);
        this.traverse(node);
        this.fixAfterNode(node);
        return null;
    }

    public Object visitFor(For node) throws Exception {
        this.fixNode(node);
        node.target.accept(this);
        node.iter.accept(this);
        if (node.body == null || node.body.length == 0) {
            node.body = new stmtType[]{new Pass()};
        }
        stmtType[] stmtTypeArray = node.body;
        int n = node.body.length;
        int n2 = 0;
        while (n2 < n) {
            stmtType n3 = stmtTypeArray[n2];
            n3.accept(this);
            ++n2;
        }
        suiteType orelse = node.orelse;
        this.endSuiteWithOrElse(orelse);
        this.fixAfterNode(node);
        return null;
    }

    private void endSuiteWithOrElse(suiteType orelse) throws Exception {
        if (orelse != null) {
            this.visitOrElsePart(orelse, "else");
        }
    }

    public Object visitRepr(Repr node) throws Exception {
        this.fixNode(node);
        this.traverse(node);
        this.fixAfterNode(node);
        return null;
    }

    public Object visitReturn(Return node) throws Exception {
        this.fixNode(node);
        node.traverse(this);
        this.fixAfterNode(node);
        return null;
    }

    public Object visitDelete(Delete node) throws Exception {
        this.fixNode(node);
        node.traverse(this);
        this.fixAfterNode(node);
        return null;
    }

    public void visitTryPart(SimpleNode node, stmtType[] body) throws Exception {
        this.fixNode(node);
        stmtType[] stmtTypeArray = body;
        int n = body.length;
        int n2 = 0;
        while (n2 < n) {
            stmtType st = stmtTypeArray[n2];
            st.accept(this);
            ++n2;
        }
        this.fixAfterNode(node);
    }

    public void visitOrElsePart(suiteType orelse, String expectedToken) throws Exception {
        if (orelse != null) {
            this.fixNode(orelse);
            stmtType[] stmtTypeArray = orelse.body;
            int n = orelse.body.length;
            int n2 = 0;
            while (n2 < n) {
                stmtType st = stmtTypeArray[n2];
                st.accept(this);
                ++n2;
            }
            this.fixAfterNode(orelse);
        }
    }

    public Object visitTryFinally(TryFinally node) throws Exception {
        if (node.body == null || node.body.length == 0) {
            node.body = new stmtType[]{new Pass()};
        }
        this.visitTryPart(node, node.body);
        this.visitOrElsePart(node.finalbody, "finally");
        return null;
    }

    public Object visitTryExcept(TryExcept node) throws Exception {
        if (node.body == null || node.body.length == 0) {
            node.body = new stmtType[]{new Pass()};
        }
        this.visitTryPart(node, node.body);
        excepthandlerType[] excepthandlerTypeArray = node.handlers;
        int n = node.handlers.length;
        int n2 = 0;
        while (n2 < n) {
            excepthandlerType h = excepthandlerTypeArray[n2];
            this.fixNode(h);
            if (h.type != null) {
                h.type.accept(this);
            }
            if (h.name != null) {
                h.name.accept(this);
            }
            if (h.body == null || h.body.length == 0) {
                h.body = new stmtType[]{new Pass()};
            }
            stmtType[] stmtTypeArray = h.body;
            int n3 = h.body.length;
            int n4 = 0;
            while (n4 < n3) {
                stmtType st = stmtTypeArray[n4];
                st.accept(this);
                ++n4;
            }
            this.fixAfterNode(h);
            ++n2;
        }
        this.visitOrElsePart(node.orelse, "else");
        return null;
    }

    public Object visitPrint(Print node) throws Exception {
        this.fixNode(node);
        if (node.dest != null) {
            node.dest.accept(this);
        }
        if (node.values != null) {
            int i = 0;
            while (i < node.values.length) {
                exprType value;
                if (i <= 0) {
                    exprType cfr_ignored_0 = node.dest;
                }
                if ((value = node.values[i]) != null) {
                    value.accept(this);
                }
                ++i;
            }
        }
        this.fixAfterNode(node);
        return null;
    }

    public Object visitYield(Yield node) throws Exception {
        this.fixNode(node);
        node.traverse(this);
        this.fixAfterNode(node);
        return null;
    }

    public Object visitAttribute(Attribute node) throws Exception {
        this.fixNode(node);
        node.value.accept(this);
        node.attr.accept(this);
        this.fixAfterNode(node);
        return null;
    }

    public Object visitCall(Call node) throws Exception {
        this.fixNode(node);
        node.func.accept(this);
        this.pushInMultiline();
        this.handleArguments(node.args, node.keywords, node.starargs, node.kwargs);
        this.popInMultiline();
        this.fixAfterNode(node);
        return null;
    }

    public Object visitStarred(Starred node) throws Exception {
        this.fixNode(node);
        node.traverse(this);
        this.fixAfterNode(node);
        return null;
    }

    public Object visitAssert(Assert node) throws Exception {
        this.fixNode(node);
        if (node.test != null) {
            node.test.accept(this);
        }
        if (node.msg != null) {
            node.msg.accept(this);
        }
        this.fixAfterNode(node);
        return null;
    }

    public Object visitStrJoin(StrJoin node) throws Exception {
        this.fixNode(node);
        if (node.strs != null) {
            int i = 0;
            while (i < node.strs.length) {
                exprType str = node.strs[i];
                if (str != null) {
                    str.accept(this);
                    this.nextLine(true);
                }
                ++i;
            }
        }
        this.fixAfterNode(node);
        return null;
    }

    public Object visitGlobal(Global node) throws Exception {
        this.fixNode(node);
        if (node.names != null) {
            int i = 0;
            while (i < node.names.length) {
                if (node.names[i] != null) {
                    node.names[i].accept(this);
                }
                ++i;
            }
        }
        if (node.value != null) {
            node.value.accept(this);
        }
        this.fixAfterNode(node);
        return null;
    }

    public Object visitExec(Exec node) throws Exception {
        this.fixNode(node);
        if (node.body != null) {
            node.body.accept(this);
        }
        if (node.globals != null) {
            node.globals.accept(this);
        }
        if (node.locals != null) {
            node.locals.accept(this);
        }
        this.fixAfterNode(node);
        return null;
    }

    public Object visitClassDef(ClassDef node) throws Exception {
        SimpleNode n;
        int n2;
        int n3;
        SimpleNode[] simpleNodeArray;
        if (node.decs != null) {
            simpleNodeArray = node.decs;
            n3 = node.decs.length;
            n2 = 0;
            while (n2 < n3) {
                n = simpleNodeArray[n2];
                if (n != null) {
                    this.handleDecorator((decoratorsType)n);
                }
                ++n2;
            }
        }
        this.fixNode(node);
        node.name.accept(this);
        this.handleArguments(node.bases, node.keywords, node.starargs, node.kwargs);
        if (node.body == null || node.body.length == 0) {
            node.body = new stmtType[]{new Pass()};
        }
        simpleNodeArray = node.body;
        n3 = node.body.length;
        n2 = 0;
        while (n2 < n3) {
            n = simpleNodeArray[n2];
            n.accept(this);
            ++n2;
        }
        this.fixAfterNode(node);
        return null;
    }

    public boolean isFilled(SimpleNode[] nodes) {
        return nodes != null && nodes.length > 0;
    }

    private void handleDecorator(decoratorsType node) throws Exception {
        this.fixNode(node);
        if (node.func != null) {
            node.func.accept(this);
        }
        if (node.args != null && node.args.length > 0 || node.keywords != null && node.keywords.length > 0 || node.starargs != null || node.kwargs != null) {
            this.handleArguments(this.reverseNodeArray(node.args), this.reverseNodeArray(node.keywords), node.starargs, node.kwargs);
        }
        this.fixAfterNode(node);
    }

    protected void handleArguments(argumentsType completeArgs) throws Exception {
        exprType[] args = completeArgs.args;
        exprType[] d = completeArgs.defaults;
        exprType[] anns = completeArgs.annotation;
        int argsLen = args == null ? 0 : args.length;
        int defaultsLen = d == null ? 0 : d.length;
        int diff = argsLen - defaultsLen;
        this.fixNode(completeArgs);
        int i = 0;
        while (i < argsLen) {
            exprType defaulArgValue;
            exprType ann;
            exprType argName = args[i];
            argName.accept(this);
            if (anns != null && (ann = anns[i]) != null) {
                ann.accept(this);
            }
            if (i >= diff && (defaulArgValue = d[i - diff]) != null) {
                defaulArgValue.accept(this);
            }
            ++i;
        }
        if (completeArgs.vararg != null) {
            completeArgs.vararg.accept(this);
            if (completeArgs.varargannotation != null) {
                completeArgs.varargannotation.accept(this);
            }
        }
        if (completeArgs.kwonlyargs != null) {
            i = 0;
            while (i < completeArgs.kwonlyargs.length) {
                exprType kwonlyarg = completeArgs.kwonlyargs[i];
                if (kwonlyarg != null) {
                    kwonlyarg.accept(this);
                    if (completeArgs.kwonlyargannotation != null && completeArgs.kwonlyargannotation[i] != null) {
                        completeArgs.kwonlyargannotation[i].accept(this);
                    }
                    if (completeArgs.kw_defaults != null && completeArgs.kw_defaults[i] != null) {
                        completeArgs.kw_defaults[i].accept(this);
                    }
                }
                ++i;
            }
        }
        if (completeArgs.kwarg != null) {
            completeArgs.kwarg.accept(this);
            if (completeArgs.kwargannotation != null) {
                completeArgs.kwargannotation.accept(this);
            }
        }
        this.fixAfterNode(completeArgs);
    }

    public Object visitFunctionDef(FunctionDef node) throws Exception {
        if (node.decs != null) {
            decoratorsType[] decoratorsTypeArray = node.decs;
            int n = node.decs.length;
            int n2 = 0;
            while (n2 < n) {
                decoratorsType n3 = decoratorsTypeArray[n2];
                if (n3 != null) {
                    this.handleDecorator(n3);
                }
                ++n2;
            }
        }
        this.fixNode(node);
        node.name.accept(this);
        if (node.args != null) {
            this.handleArguments(node.args);
        }
        if (node.returns != null) {
            node.returns.accept(this);
        }
        if (node.body == null || node.body.length == 0) {
            node.body = new stmtType[]{new Pass()};
        }
        int length = node.body.length;
        int i = 0;
        while (i < length) {
            if (node.body[i] != null) {
                node.body[i].accept(this);
            }
            ++i;
        }
        this.fixAfterNode(node);
        return null;
    }

    public Object visitPass(Pass node) throws Exception {
        return this.handleSimpleNode(node);
    }

    public Object visitBreak(Break node) throws Exception {
        return this.handleSimpleNode(node);
    }

    public Object visitContinue(Continue node) throws Exception {
        return this.handleSimpleNode(node);
    }

    private Object handleSimpleNode(SimpleNode node) throws Exception {
        this.fixNode(node);
        node.traverse(this);
        this.fixAfterNode(node);
        return null;
    }

    public Object visitIfExp(IfExp node) throws Exception {
        this.fixNode(node);
        node.body.accept(this);
        node.test.accept(this);
        if (node.orelse != null) {
            node.orelse.accept(this);
        }
        this.fixAfterNode(node);
        return null;
    }

    public Object visitName(Name node) throws Exception {
        return this.handleSimpleNode(node);
    }

    public Object visitNameTok(NameTok node) throws Exception {
        return this.handleSimpleNode(node);
    }

    public Object visitNum(Num node) throws Exception {
        return this.handleSimpleNode(node);
    }

    public Object visitSubscript(Subscript node) throws Exception {
        this.fixNode(node);
        if (node.value != null) {
            node.value.accept(this);
        }
        if (node.slice != null) {
            node.slice.accept(this);
        }
        this.fixAfterNode(node);
        return null;
    }

    public Object visitSlice(Slice node) throws Exception {
        this.fixNode(node);
        if (node.lower != null) {
            node.lower.accept(this);
        }
        if (node.upper != null) {
            node.upper.accept(this);
        }
        if (node.step != null) {
            node.step.accept(this);
        }
        this.fixAfterNode(node);
        return null;
    }

    public Object visitStr(Str node) throws Exception {
        return this.handleSimpleNode(node);
    }

    public Object visitImport(Import node) throws Exception {
        this.fixNode(node);
        int i = 0;
        while (i < node.names.length) {
            aliasType alias = node.names[i];
            this.handleAlias(alias);
            ++i;
        }
        this.fixAfterNode(node);
        return null;
    }

    public Object visitImportFrom(ImportFrom node) throws Exception {
        this.fixNode(node);
        if (node.module != null) {
            node.module.accept(this);
        }
        int i = 0;
        while (i < node.names.length) {
            aliasType alias = node.names[i];
            this.handleAlias(alias);
            ++i;
        }
        this.fixAfterNode(node);
        return null;
    }

    private void handleAlias(aliasType alias) throws Exception {
        this.fixNode(alias);
        if (alias.name != null) {
            alias.name.accept(this);
        }
        if (alias.asname != null) {
            alias.asname.accept(this);
        }
        this.fixAfterNode(alias);
    }

    public Object visitRaise(Raise node) throws Exception {
        this.fixNode(node);
        if (node.type != null) {
            node.type.accept(this);
        }
        if (node.inst != null) {
            node.inst.accept(this);
        }
        if (node.tback != null) {
            node.tback.accept(this);
        }
        if (node.cause != null) {
            node.cause.accept(this);
        }
        this.fixAfterNode(node);
        return null;
    }

    public Object visitLambda(Lambda node) throws Exception {
        this.fixNode(node);
        this.handleArguments(node.args);
        if (node.body != null) {
            node.body.accept(this);
        }
        this.fixAfterNode(node);
        return null;
    }

    public Object visitExpr(Expr node) throws Exception {
        this.handleSimpleNode(node);
        return null;
    }

    private void handleArguments(SimpleNode[] args, SimpleNode[] keywords, exprType starargs, exprType kwargs) throws Exception, IOException {
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (args[i] != null) {
                    args[i].accept(this);
                }
                ++i;
            }
        }
        ArrayList<keywordType> keywordsLater = new ArrayList<keywordType>();
        if (keywords != null) {
            int i = 0;
            while (i < keywords.length) {
                keywordType keyword = (keywordType)keywords[i];
                if (keyword != null) {
                    if (keyword.afterstarargs) {
                        keywordsLater.add(keyword);
                    } else {
                        this.handleKeyword(keyword);
                    }
                }
                ++i;
            }
        }
        if (starargs != null) {
            starargs.accept(this);
        }
        Iterator iterator = keywordsLater.iterator();
        while (iterator.hasNext()) {
            keywordType keyword = (keywordType)iterator.next();
            this.handleKeyword(keyword);
        }
        if (kwargs != null) {
            kwargs.accept(this);
        }
    }

    private void handleKeyword(keywordType keyword) throws Exception, IOException {
        this.fixNode(keyword);
        if (keyword.arg != null) {
            keyword.arg.accept(this);
        }
        if (keyword.value != null) {
            keyword.value.accept(this);
        }
        this.fixAfterNode(keyword);
    }

    public Object visitIf(If node) throws Exception {
        this.visitIfPart(null, node, false);
        return null;
    }

    private void visitIfPart(suiteType orelse, If node, boolean isElif) throws Exception {
        if (orelse != null) {
            this.fixNode(orelse);
        }
        this.fixNode(node);
        node.test.accept(this);
        if (node.body == null || node.body.length == 0) {
            node.body = new stmtType[]{new Pass()};
        }
        Object object = node.body;
        int n = node.body.length;
        int n2 = 0;
        while (n2 < n) {
            stmtType n3 = object[n2];
            n3.accept(this);
            ++n2;
        }
        if (orelse != null) {
            this.fixAfterNode(orelse);
        }
        if (node.orelse != null && node.orelse.body != null && node.orelse.body.length > 0) {
            if (node.orelse.body.length == 1 && node.orelse.body[0] instanceof If) {
                If if1 = (If)node.orelse.body[0];
                if (if1.test == null) {
                    this.visitOrElsePart(node.orelse, "else");
                } else {
                    boolean foundIf = false;
                    if (if1.specialsBefore != null) {
                        object = if1.specialsBefore.iterator();
                        while (object.hasNext()) {
                            Object o = object.next();
                            if (!o.toString().equals("if")) continue;
                            foundIf = true;
                            break;
                        }
                    }
                    if (foundIf) {
                        this.visitIfPart(node.orelse, if1, false);
                    } else {
                        this.visitIfPart(node.orelse, if1, true);
                    }
                }
            } else {
                this.visitOrElsePart(node.orelse, "else");
            }
        }
        this.fixAfterNode(node);
    }

    protected SimpleNode visitNode(SimpleNode node) throws Exception {
        if (node == null) {
            return null;
        }
        if (node instanceof decoratorsType) {
            this.handleDecorator((decoratorsType)node);
        } else if (node instanceof keywordType) {
            this.handleKeyword((keywordType)node);
        } else if (node instanceof argumentsType) {
            this.handleArguments((argumentsType)node);
        } else if (node instanceof aliasType) {
            this.handleAlias((aliasType)node);
        } else {
            node.accept(this);
        }
        return null;
    }
}

