/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.util;

import com.rc.retroweaver.runtime.Autobox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class UIUtils {
    public static void execLoop(JComponent editor, Frame parent, boolean modal) {
        UIUtils.execLoop(editor, parent, modal, 800, 600);
    }

    public static void execLoop(JComponent editor, Frame parent, boolean modal, int w, int h) {
        JDialog dialog = new JDialog(parent, modal);
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(editor);
        contentPane.add((Component)scrollPane, "Center");
        dialog.setSize(w, h);
        UIUtils.centerWindow(dialog);
        dialog.setVisible(true);
    }

    public static void execLoop(JComponent editor, boolean modal) {
        UIUtils.execLoop(editor, new JFrame(), modal);
    }

    public static void execLoop(JComponent editor) {
        UIUtils.execLoop(editor, true);
    }

    public static void showString(String strToShow) {
        JTextArea field = new JTextArea();
        field.setText(strToShow);
        UIUtils.execLoop(field);
    }

    public static void showException(Exception e) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(byteOut);
        e.printStackTrace(out);
        String strToShow = new String(byteOut.toByteArray());
        UIUtils.showString(strToShow);
    }

    public static boolean showStringAndConfirm(String strToShow) {
        final JDialog dialog = new JDialog((Frame)new JFrame(), true);
        dialog.setLayout(new GridBagLayout());
        JPanel panel = new JPanel(new BorderLayout());
        JTextArea field = new JTextArea();
        field.setText(strToShow);
        panel.add((Component)field, "Center");
        GridBagConstraints g = new GridBagConstraints();
        g.weightx = 1.0;
        g.weighty = 0.9;
        g.fill = 1;
        dialog.add((Component)panel, g);
        final Boolean[] confirmed = new Boolean[]{Autobox.valueOf((boolean)false)};
        panel = new JPanel(new GridLayout(0, 2));
        JButton button = new JButton("OK");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                confirmed[0] = Autobox.valueOf((boolean)true);
                dialog.setVisible(false);
            }
        });
        panel.add(button);
        button = new JButton("Cancel");
        panel.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        g = new GridBagConstraints();
        g.weightx = 1.0;
        g.fill = 1;
        g.gridy = 1;
        dialog.add((Component)panel, g);
        dialog.pack();
        dialog.setSize(1024, 900);
        UIUtils.centerWindow(dialog);
        dialog.setVisible(true);
        return confirmed[0];
    }

    public static void centerWindow(Window component) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int x = (screenSize.width - component.getWidth()) / 2;
        int y = (screenSize.height - component.getHeight()) / 2;
        component.setLocation(x, y);
    }
}

