/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.debug.remote;

import com.python.pydev.debug.DebugPluginPrefsInitializer;
import com.python.pydev.debug.model.ProcessServer;
import com.python.pydev.debug.model.PyDebugTargetServer;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Iterator;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.PySourceLocator;
import org.python.pydev.debug.model.remote.AbstractRemoteDebugger;

public class RemoteDebuggerServer
extends AbstractRemoteDebugger
implements Runnable {
    private static final int TIMEOUT = 0;
    private static volatile ServerSocket serverSocket;
    private volatile ILaunch launch;
    private volatile boolean terminated = true;
    private volatile ProcessServer serverProcess;
    private volatile IProcess iProcess;
    private volatile boolean inDispose = false;
    private volatile boolean inStopListening = false;
    private static volatile int remoteDebuggerPort;
    private static volatile RemoteDebuggerServer remoteServer;
    private static volatile Thread remoteServerThread;

    static {
        remoteDebuggerPort = -1;
    }

    private RemoteDebuggerServer() {
    }

    public static synchronized RemoteDebuggerServer getInstance() {
        if (remoteDebuggerPort != DebugPluginPrefsInitializer.getRemoteDebuggerPort()) {
            if (remoteServer != null) {
                remoteServer.dispose();
            }
            remoteServer = null;
            remoteServerThread = null;
        }
        if (remoteServer == null) {
            remoteServer = new RemoteDebuggerServer();
        }
        if (remoteServerThread == null) {
            remoteServerThread = new Thread(remoteServer);
            remoteDebuggerPort = DebugPluginPrefsInitializer.getRemoteDebuggerPort();
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
            try {
                serverSocket = new ServerSocket(remoteDebuggerPort);
                serverSocket.setReuseAddress(true);
                serverSocket.setSoTimeout(0);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            remoteServerThread.start();
        }
        return remoteServer;
    }

    public void run() {
        try {
            while (true) {
                this.startDebugging(serverSocket.accept());
            }
        }
        catch (SocketException socketException) {
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    private void startDebugging(Socket socket) throws InterruptedException {
        try {
            Thread.sleep(1000L);
            if (this.launch != null) {
                this.launch.setSourceLocator((ISourceLocator)new PySourceLocator());
            }
            PyDebugTargetServer target = new PyDebugTargetServer(this.launch, null, this);
            target.startTransmission(socket);
            target.initialize();
            this.addTarget(target);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void stopListening() {
        if (this.terminated || this.inStopListening) {
            return;
        }
        this.inStopListening = true;
        try {
            this.terminated = true;
            try {
                if (this.launch != null && this.launch.canTerminate()) {
                    this.launch.terminate();
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
            this.launch = null;
        }
        finally {
            this.inStopListening = false;
        }
    }

    public void dispose() {
        if (this.inDispose) {
            return;
        }
        this.inDispose = true;
        try {
            this.stopListening();
            if (this.launch != null) {
                Iterator iterator = this.targets.iterator();
                while (iterator.hasNext()) {
                    AbstractDebugTarget target = (AbstractDebugTarget)iterator.next();
                    this.launch.removeDebugTarget((IDebugTarget)target);
                    target.terminate();
                }
            }
            this.targets.clear();
        }
        finally {
            this.inDispose = false;
        }
    }

    public void disconnect() throws DebugException {
        this.stopListening();
    }

    public void setLaunch(ILaunch launch, ProcessServer p, IProcess pro) {
        if (this.launch != null) {
            this.stopListening();
        }
        this.terminated = false;
        this.serverProcess = p;
        this.launch = launch;
        this.iProcess = pro;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public IProcess getIProcess() {
        return this.iProcess;
    }

    public ProcessServer getServerProcess() {
        return this.serverProcess;
    }
}

